/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.helper;

import com.rwtema.funkylocomotion.movepermissions.MoveCheckReflector;
import framesapi.BlockPos;
import framesapi.IMoveCheck;
import framesapi.ISlipperyBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHelper {
    public static boolean silentSetBlock(Chunk chunk, BlockPos pos, Block block, int meta) {
        int y = pos.y;
        int dz = pos.z & 0xF;
        int dx = pos.x & 0xF;
        int i1 = dz << 4 | dx;
        if (y >= chunk.field_76638_b[i1] - 1) {
            chunk.field_76638_b[i1] = -999;
        }
        Block block1 = chunk.func_150810_a(dx, y, dz);
        int k1 = chunk.func_76628_c(dx, y, dz);
        if (block1 == block && k1 == meta) {
            return false;
        }
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
        if (extendedblockstorage == null) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !chunk.field_76637_e.field_73011_w.field_76576_e);
            chunk.func_76587_i()[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        extendedblockstorage.func_150818_a(dx, y & 0xF, dz, block);
        extendedblockstorage.func_76654_b(dx, y & 0xF, dz, meta);
        chunk.field_76643_l = true;
        return true;
    }

    public static void silentClear(Chunk chunk, BlockPos pos) {
        BlockHelper.silentSetBlock(chunk, pos, Blocks.field_150350_a, 0);
    }

    public static void postUpdateBlock(World world, BlockPos pos) {
        int j1;
        int i1 = (pos.z & 0xF) << 4 | pos.x & 0xF;
        Chunk chunk = BlockHelper.getChunk(world, pos);
        if (pos.y >= chunk.field_76638_b[i1] - 1) {
            chunk.field_76638_b[i1] = -999;
        }
        boolean flag = pos.y >= (j1 = chunk.field_76634_f[i1]);
        Block newBlock = chunk.func_150810_a(pos.x & 0xF, pos.y, pos.z & 0xF);
        int k2 = 255;
        if (flag) {
            chunk.func_76603_b();
        } else {
            int j2 = newBlock.getLightOpacity((IBlockAccess)world, pos.x, pos.y, pos.z);
            if (j2 > 0) {
                if (pos.y >= j1) {
                    chunk.func_76615_h(pos.x & 0xF, pos.y + 1, pos.z & 0xF);
                }
            } else if (pos.y == j1 - 1) {
                chunk.func_76615_h(pos.x & 0xF, pos.y, pos.z & 0xF);
            }
            if (j2 != k2 && (j2 < k2 || chunk.func_76614_a(EnumSkyBlock.Sky, pos.x & 0xF, pos.y, pos.z & 0xF) > 0 || chunk.func_76614_a(EnumSkyBlock.Block, pos.x & 0xF, pos.y, pos.z & 0xF) > 0)) {
                chunk.func_76595_e(pos.x & 0xF, pos.z & 0xF);
            }
        }
        world.func_147451_t(pos.x, pos.y, pos.z);
        world.func_147471_g(pos.x, pos.y, pos.z);
        world.func_147444_c(pos.x, pos.y, pos.z, Blocks.field_150350_a);
        world.func_147460_e(pos.x, pos.y, pos.z, Blocks.field_150350_a);
        if (newBlock.func_149740_M()) {
            world.func_147453_f(pos.x, pos.y, pos.z, newBlock);
        }
    }

    public static Chunk getChunk(World world, BlockPos pos) {
        return world.func_72938_d(pos.x, pos.z);
    }

    public static Block getBlock(World world, BlockPos pos) {
        return world.func_147439_a(pos.x, pos.y, pos.z);
    }

    public static Block getBlock(Chunk chunk, BlockPos pos) {
        return chunk.func_150810_a(pos.x & 0xF, pos.y, pos.z & 0xF);
    }

    public static boolean canMoveBlock(World world, BlockPos pos) {
        Block b = BlockHelper.getBlock(world, pos);
        if (b == Blocks.field_150350_a || b.isAir((IBlockAccess)world, pos.x, pos.y, pos.z)) {
            return false;
        }
        if (b instanceof IMoveCheck) {
            return ((IMoveCheck)b).canMove(world, pos.x, pos.y, pos.z);
        }
        if (b.func_149712_f(world, pos.x, pos.y, pos.z) < 0.0f) {
            return false;
        }
        TileEntity tile = world.func_147438_o(pos.x, pos.y, pos.z);
        if (tile != null) {
            if (tile instanceof IMoveCheck) {
                return ((IMoveCheck)tile).canMove(world, pos.x, pos.y, pos.z);
            }
            if (!MoveCheckReflector.canMoveClass(tile.getClass())) {
                return false;
            }
        }
        return MoveCheckReflector.canMoveClass(b.getClass());
    }

    public static void breakBlockWithDrop(World world, BlockPos pos) {
        Block block = BlockHelper.getBlock(world, pos);
        if (block.func_149688_o() != Material.field_151579_a) {
            int l = world.func_72805_g(pos.x, pos.y, pos.z);
            world.func_72926_e(2001, pos.x, pos.y, pos.z, Block.func_149682_b((Block)block) + (l << 12));
            block.func_149697_b(world, pos.x, pos.y, pos.z, l, 0);
        }
        world.func_147465_d(pos.x, pos.y, pos.z, Blocks.field_150350_a, 0, 2);
    }

    public static boolean isValid(World world, BlockPos pos) {
        return world.func_72899_e(pos.x, pos.y, pos.z);
    }

    public static boolean canStick(World world, BlockPos pos, ForgeDirection dir) {
        if (!BlockHelper.isValid(world, pos)) {
            return false;
        }
        if (!BlockHelper.canMoveBlock(world, pos)) {
            return false;
        }
        Block b = BlockHelper.getBlock(world, pos);
        return !(b instanceof ISlipperyBlock) || ((ISlipperyBlock)b).canStickTo(world, pos, dir);
    }

    public static boolean canReplace(World world, BlockPos pos) {
        return BlockHelper.isValid(world, pos) && (world.func_147437_c(pos.x, pos.y, pos.z) || BlockHelper.getBlock(world, pos).isReplaceable((IBlockAccess)world, pos.x, pos.y, pos.z));
    }

    public static TileEntity getTile(World world, BlockPos pos) {
        return world.func_147438_o(pos.x, pos.y, pos.z);
    }

    public static int getMeta(World world, BlockPos pos) {
        return world.func_72805_g(pos.x, pos.y, pos.z);
    }
}

