/*
 * Decompiled with CFR 0.152.
 */
package nc.crafting.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nc.NuclearCraft;
import nc.crafting.nei.MetalFurnaceRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class MetalFurnaceFuelRecipeHandler
extends MetalFurnaceRecipeHandler {
    private ArrayList<MetalFurnaceRecipeHandler.MetalSmeltingPair> mmetalfurnace = new ArrayList();

    public MetalFurnaceFuelRecipeHandler() {
        this.loadAllSmelting();
    }

    @Override
    public String getRecipeName() {
        return "Metal Furnace Fuel";
    }

    private void loadAllSmelting() {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            this.mmetalfurnace.add(new MetalFurnaceRecipeHandler.MetalSmeltingPair(this, (ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("metalfuel") && ((Object)((Object)this)).getClass() == MetalFurnaceFuelRecipeHandler.class) {
            for (MetalFurnaceRecipeHandler.MetalFuelPair fuel : ametalfuels) {
                this.arecipes.add(new CachedFuelRecipe(fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (MetalFurnaceRecipeHandler.MetalFuelPair fuel : ametalfuels) {
            if (!fuel.stack.contains(ingredient)) continue;
            this.arecipes.add(new CachedFuelRecipe(fuel));
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedFuelRecipe crecipe = (CachedFuelRecipe)((Object)this.arecipes.get(recipe));
        MetalFurnaceRecipeHandler.MetalFuelPair fuel = crecipe.metalfuel;
        float burnTime = (float)((double)(fuel.burnTime * NuclearCraft.metalFurnaceCookSpeed) / 8000.0);
        if (gui.isMouseOver(fuel.stack, recipe) && burnTime < 1.0f) {
            burnTime = 1.0f / burnTime;
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate((String)"recipe.fuel.required", (Object[])new Object[]{s_time}));
        } else if ((gui.isMouseOver(crecipe.getResult(), recipe) || gui.isMouseOver(crecipe.getIngredient(), recipe)) && burnTime > 1.0f) {
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate((String)("recipe.fuel." + (gui.isMouseOver(crecipe.getResult(), recipe) ? "produced" : "processed")), (Object[])new Object[]{s_time}));
        }
        return currenttip;
    }

    public class CachedFuelRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public MetalFurnaceRecipeHandler.MetalFuelPair metalfuel;

        public CachedFuelRecipe(MetalFurnaceRecipeHandler.MetalFuelPair fuel) {
            super((TemplateRecipeHandler)MetalFurnaceFuelRecipeHandler.this);
            this.metalfuel = fuel;
        }

        public PositionedStack getIngredient() {
            return ((MetalFurnaceRecipeHandler.MetalSmeltingPair)((Object)((MetalFurnaceFuelRecipeHandler)MetalFurnaceFuelRecipeHandler.this).mmetalfurnace.get((int)(MetalFurnaceFuelRecipeHandler.this.cycleticks / 24 % ((MetalFurnaceFuelRecipeHandler)MetalFurnaceFuelRecipeHandler.this).mmetalfurnace.size())))).ingred;
        }

        public PositionedStack getResult() {
            return ((MetalFurnaceRecipeHandler.MetalSmeltingPair)((Object)((MetalFurnaceFuelRecipeHandler)MetalFurnaceFuelRecipeHandler.this).mmetalfurnace.get((int)(MetalFurnaceFuelRecipeHandler.this.cycleticks / 24 % ((MetalFurnaceFuelRecipeHandler)MetalFurnaceFuelRecipeHandler.this).mmetalfurnace.size())))).result;
        }

        public PositionedStack getOtherStack() {
            return this.metalfuel.stack;
        }
    }
}

