/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import team.chisel.init.ChiselBlocks;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class FactoryHouseSmall
extends Structure {
    static ArrayList<MBlock> blockList = new ArrayList();
    static short[][] blocks;

    public FactoryHouseSmall(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.setSwapXZ(true);
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int centerX;
        int centerZ;
        if (sizeX < this.minX && sizeZ > this.minX && sizeX >= this.minZ || sizeZ < this.minZ && sizeX > this.minZ && sizeZ >= this.minX) {
            direction = (direction + 1) % 4;
            centerZ = (int)((float)sizeX / 2.0f);
            centerX = (int)((float)sizeZ / 2.0f);
        } else {
            centerX = (int)((float)sizeX / 2.0f);
            centerZ = (int)((float)sizeZ / 2.0f);
        }
        BlockUtils.placeFoundation(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0, 3);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 0);
        BlockUtils.placeScannedStructure(world, blocks, blockList, posX, posY, posZ, centerX, centerZ, direction, 1);
    }

    static {
        blockList.add(new MBlock(TGBlocks.concrete, 5));
        blockList.add(new MBlock((Block)ChiselBlocks.technical, 0));
        blockList.add(new MBlock((Block)ChiselBlocks.factoryblock, 1));
        blockList.add(new MBlock(Blocks.field_150410_aZ, 0));
        blockList.add(new MBlock((Block)ChiselBlocks.technical, 12));
        blockList.add(new MBlock((Block)ChiselBlocks.factoryblock, 9));
        blockList.add(new MBlock((Block)Blocks.field_150486_ae, 5));
        blockList.add(new MBlock(TGBlocks.airMarker, 0));
        blockList.add(new MBlock(TGBlocks.lamp01, 4, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 6, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock((Block)ChiselBlocks.factoryblock, 0));
        blockList.add(new MBlock(Blocks.field_150462_ai, 0));
        blockList.add(new MBlock((Block)TGBlocks.door01, 7, true, BlockUtils.BlockType.DOOR).setPass(0));
        blockList.add(new MBlock((Block)TGBlocks.door01, 8, true, BlockUtils.BlockType.DOOR).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 1, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 3, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(Blocks.field_150460_al, 3).setPass(1));
        blockList.add(new MBlock(TGBlocks.lamp01, 5, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock(TGBlocks.ladder01, 1, true, BlockUtils.BlockType.TG).setPass(1));
        blockList.add(new MBlock((Block)ChiselBlocks.iron_bars, 6));
        blockList.add(new MBlock(TGBlocks.lamp01, 7, true, BlockUtils.BlockType.TG).setPass(1));
        blocks = BlockUtils.loadStructureFromFile("factoryBuildingSmall");
    }
}

