/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.util.BlockUtils;
import techguns.worldgen.structures.Structure;

public class Containers
extends Structure {
    int containerWidth = 2;
    int containerHeight = 2;
    int containerMinLength = 2;
    Block containerBlock = Blocks.field_150339_S;

    public Containers(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int containerWidth, int containerHeight, int containerMinLength, Block containerBlock) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.containerWidth = containerWidth;
        this.containerHeight = containerHeight;
        this.containerMinLength = containerMinLength;
        this.containerBlock = containerBlock;
    }

    public Containers(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Block containerBlock) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.containerBlock = containerBlock;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int offset = 0;
        if (sizeX > sizeZ) {
            int count = (int)(((float)sizeZ + 1.0f) / ((float)this.containerWidth + 1.0f));
            for (int i = 0; i < count; ++i) {
                BlockUtils.fillBlocks(world, posX, posY + 1, posZ + offset, sizeX, this.containerHeight, this.containerWidth, this.containerBlock);
                offset += this.containerWidth + 1;
            }
        } else {
            int count = (int)(((float)sizeX + 1.0f) / ((float)this.containerWidth + 1.0f));
            for (int i = 0; i < count; ++i) {
                BlockUtils.fillBlocks(world, posX + offset, posY + 1, posZ, this.containerWidth, this.containerHeight, sizeZ, this.containerBlock);
                offset += this.containerWidth + 1;
            }
        }
    }
}

