/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.blocks.TGChiselBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class CampProps
extends Structure {
    MBlock groundBlock = new MBlock(Blocks.field_150351_n, 0);
    MBlock[] crateBlocks = new MBlock[]{TGChiselBlocks.factory_box, TGChiselBlocks.woodenCrate};
    int variant = -1;

    public CampProps(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public CampProps(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int variant) {
        this(minX, minY, minZ, maxX, maxY, maxZ);
        this.variant = variant;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int camoMeta;
        switch (colorType) {
            case DESERT: {
                camoMeta = 2;
                break;
            }
            case SNOW: {
                camoMeta = 1;
                break;
            }
            default: {
                camoMeta = 0;
            }
        }
        if (this.variant == -1) {
            this.variant = new Random().nextInt(2);
        }
        switch (this.variant) {
            default: {
                this.setCrateBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ);
                break;
            }
            case 1: {
                this.setRoofBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, camoMeta);
                this.setCrateBlocks(world, posX + 1, posY, posZ + 1, sizeX - 2, sizeY - 2, sizeZ - 2);
                break;
            }
            case 2: {
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 3: {
                this.setRoofBlocks(world, posX, posY + 1, posZ, sizeX, sizeY - 1, sizeZ, camoMeta);
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 4: {
                this.setSandbagRow(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                break;
            }
            case 5: {
                this.setRoofBlocks(world, posX, posY + 1, posZ, sizeX, sizeY - 1, sizeZ, camoMeta);
                this.setSandbagBlocks(world, posX, posY, posZ, sizeX, sizeY, sizeZ, direction);
                this.setCrateBlocks(world, posX + 1, posY, posZ + 1, sizeX - 2, sizeY - 2, sizeZ - 2);
            }
        }
    }

    private void setSandbagRow(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction) {
        MBlock sandbags = new MBlock(TGBlocks.sandbags, 0);
        int x = 0;
        int z = 0;
        int i = 1;
        for (int y = 1; y < sizeY; ++y) {
            if (sizeX > sizeZ) {
                z = sizeZ / 2;
                for (x = i; x < sizeX - i; ++x) {
                    world.func_147465_d(posX + x, posY + y, posZ + z, sandbags.block, sandbags.meta, 2);
                }
            } else {
                x = sizeX / 2;
                for (z = i; z < sizeZ - i; ++z) {
                    world.func_147465_d(posX + x, posY + y, posZ + z, sandbags.block, sandbags.meta, 2);
                }
            }
            ++i;
        }
    }

    private void setSandbagBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction) {
        int zoffset;
        int xoffset;
        MBlock sandbags = new MBlock(TGBlocks.sandbags, 0);
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                if (x != 0 && x != sizeX - 1 && z != 0 && z != sizeZ - 1) continue;
                world.func_147465_d(posX + x, posY + 1, posZ + z, sandbags.block, sandbags.meta, 2);
            }
        }
        switch (direction) {
            case 0: {
                xoffset = 0;
                zoffset = sizeZ / 2;
                break;
            }
            case 1: {
                xoffset = sizeX / 2;
                zoffset = 0;
                break;
            }
            case 2: {
                xoffset = sizeX - 1;
                zoffset = sizeZ / 2;
                break;
            }
            default: {
                xoffset = sizeX / 2;
                zoffset = sizeZ - 1;
            }
        }
        world.func_147449_b(posX + xoffset, posY + 1, posZ + zoffset, Blocks.field_150350_a);
    }

    private void setRoofBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int camoMeta) {
        BlockUtils.fillBlocks(world, posX, posY + 1, posZ, 1, sizeY - 2, 1, Blocks.field_150422_aJ);
        BlockUtils.fillBlocks(world, posX + sizeX - 1, posY + 1, posZ, 1, sizeY - 2, 1, Blocks.field_150422_aJ);
        BlockUtils.fillBlocks(world, posX, posY + 1, posZ + sizeZ - 1, 1, sizeY - 2, 1, Blocks.field_150422_aJ);
        BlockUtils.fillBlocks(world, posX + sizeX - 1, posY + 1, posZ + sizeZ - 1, 1, sizeY - 2, 1, Blocks.field_150422_aJ);
        BlockUtils.fillBlocksWithMeta(world, posX, posY + sizeY - 1, posZ, sizeX, 1, sizeZ, TGBlocks.camoNetRoof, camoMeta, 2);
    }

    public void setCrateBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        Random r = new Random(world.func_72905_C());
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                world.func_147465_d(posX + x, posY, posZ + z, this.groundBlock.block, this.groundBlock.meta, 2);
                for (int y = 1; y < sizeY; ++y) {
                    if (this.isFreeSpace(world, posX + x, posY + y - 1, posZ + z) || !(Math.random() > 0.5)) continue;
                    int index = r.nextInt(this.crateBlocks.length);
                    world.func_147465_d(posX + x, posY + y, posZ + z, this.crateBlocks[index].block, this.crateBlocks[index].meta, 2);
                }
            }
        }
        if ((float)(sizeX + sizeZ) / 2.0f / 6.0f > r.nextFloat()) {
            for (int y = sizeY; y > 1; --y) {
                for (int t = 0; t < 3; ++t) {
                    int z;
                    int x = r.nextInt(sizeX);
                    if (!world.func_147437_c(posX + x, posY + y, posZ + (z = r.nextInt(sizeZ))) || this.isFreeSpace(world, posX + x, posY + y - 1, posZ + z)) continue;
                    world.func_147465_d(posX + x, posY + y, posZ + z, (Block)TGBlocks.lamp01, 7, 2);
                    return;
                }
            }
        }
    }

    public boolean isFreeSpace(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z) == Blocks.field_150431_aC || world.func_147439_a(x, y, z) == TGBlocks.lamp01;
    }
}

