/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class PacketUtil {
    public static void writeItemStackToBuffer(ByteBuf buf, ItemStack itemstack) throws IOException {
        if (itemstack == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.func_150891_b((Item)itemstack.func_77973_b()));
            buf.writeByte(itemstack.field_77994_a);
            buf.writeShort(itemstack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (itemstack.func_77973_b().func_77645_m() || itemstack.func_77973_b().func_77651_p()) {
                nbttagcompound = itemstack.field_77990_d;
            }
            PacketUtil.writeNBTTagCompoundToBuffer(buf, nbttagcompound);
        }
    }

    public static ItemStack readItemStackFromBuffer(ByteBuf buf) throws IOException {
        ItemStack itemstack = null;
        short short1 = buf.readShort();
        if (short1 >= 0) {
            byte b0 = buf.readByte();
            short short2 = buf.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = PacketUtil.readNBTTagCompoundFromBuffer(buf);
        }
        return itemstack;
    }

    public static void writeNBTTagCompoundToBuffer(ByteBuf buf, NBTTagCompound compound) throws IOException {
        if (compound == null) {
            buf.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
            buf.writeShort((int)((short)abyte.length));
            buf.writeBytes(abyte);
        }
    }

    public static NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf buf) throws IOException {
        short short1 = buf.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        buf.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }
}

