/*
 * Decompiled with CFR 0.152.
 */
package techguns.tileentities;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import techguns.TGItems;
import techguns.inventory.ChemLabRecipes;
import techguns.tileentities.BasicMachineTileEntity;
import techguns.util.ItemUtil;

public class ChemLabTileEnt
extends BasicMachineTileEntity
implements IFluidHandler {
    public FluidTank inputTank;
    public FluidTank outputTank;
    private Random rng = new Random();
    protected ChemLabRecipes.ChemLabOutput currentChemOperation = null;
    protected boolean drainInput = false;

    public ChemLabTileEnt() {
        super(5, 20000);
        this.inputTank = new FluidTank(8000);
        this.outputTank = new FluidTank(16000);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 3;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "techguns.container.chemlab";
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 2) {
            return ChemLabRecipes.allowInFlaskSlot(item);
        }
        if (slot == 0 && this.content[0] == null && this.content[1] == null) {
            return ChemLabRecipes.hasRecipeUsing(item);
        }
        if (slot == 0 && this.content[0] == null && this.content[1] != null) {
            return ChemLabRecipes.allowAsInput2(this.content[1], item);
        }
        if (slot == 0 && this.content[0] != null) {
            return ItemUtil.isItemEqual(this.content[0], item);
        }
        if (slot == 1 && this.content[0] != null) {
            return ChemLabRecipes.allowAsInput2(this.content[0], item);
        }
        if (slot == 1 && this.content[1] != null) {
            return ItemUtil.isItemEqual(this.content[1], item);
        }
        return false;
    }

    @Override
    public void readEntityDataFromNBT(NBTTagCompound tag) {
        NBTTagCompound tankOut;
        super.readEntityDataFromNBT(tag);
        NBTTagCompound tankIn = tag.func_74775_l("inputTank");
        if (tankIn != null) {
            this.inputTank.readFromNBT(tankIn);
        }
        if ((tankOut = tag.func_74775_l("outputTank")) != null) {
            this.outputTank.readFromNBT(tankOut);
        }
        this.drainInput = tag.func_74767_n("drainInput");
        NBTTagCompound chemOp = tag.func_74775_l("currentChemOperation");
        this.currentChemOperation = !chemOp.func_82582_d() ? new ChemLabRecipes.ChemLabOutput(chemOp) : null;
    }

    @Override
    public void writeEntityDataToNBT(NBTTagCompound tag) {
        super.writeEntityDataToNBT(tag);
        NBTTagCompound tagInputTank = new NBTTagCompound();
        NBTTagCompound tagOutputTank = new NBTTagCompound();
        this.inputTank.writeToNBT(tagInputTank);
        tag.func_74782_a("inputTank", (NBTBase)tagInputTank);
        this.outputTank.writeToNBT(tagOutputTank);
        tag.func_74782_a("outputTank", (NBTBase)tagOutputTank);
        tag.func_74757_a("drainInput", this.drainInput);
        if (this.currentChemOperation != null) {
            tag.func_74782_a("currentChemOperation", (NBTBase)this.currentChemOperation.getAsNBTTags());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.inputTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.drainInput) {
            if (resource == null || !resource.isFluidEqual(this.outputTank.getFluid())) {
                return null;
            }
            return this.outputTank.drain(resource.amount, doDrain);
        }
        if (resource == null || !resource.isFluidEqual(this.inputTank.getFluid())) {
            return null;
        }
        return this.inputTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.drainInput) {
            return this.inputTank.drain(maxDrain, doDrain);
        }
        return this.outputTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean isWorking() {
        return this.currentChemOperation != null;
    }

    private boolean canMergeFluidOutput(FluidStack output) {
        if (output == null || this.outputTank.getFluid() == null) {
            return true;
        }
        return this.outputTank.getFluid().isFluidEqual(output) && this.outputTank.getFluidAmount() + output.amount <= this.outputTank.getCapacity();
    }

    public boolean canOutput(ChemLabRecipes.ChemLabOutput output) {
        return this.canOutput(output.getItemOutput(), 3) && this.canMergeFluidOutput(output.getLiquidOutput());
    }

    public boolean canOutput(ChemLabRecipes.ChemLabOutput output, int multiplier) {
        ItemStack output_item = null;
        FluidStack output_fluid = null;
        if (output.getItemOutput() != null) {
            output_item = TGItems.newStack(output.getItemOutput(), output.getItemOutput().field_77994_a * multiplier);
        }
        if (output.getLiquidOutput() != null) {
            output_fluid = new FluidStack(output.getLiquidOutput().getFluid(), output.getLiquidOutput().amount * multiplier);
        }
        return !(output_item != null && !this.canOutput(output_item, 3) || output_fluid != null && !this.canMergeFluidOutput(output_fluid));
    }

    public boolean canConsume(ChemLabRecipes.ChemLabOutput output, int multiplier) {
        int amount0 = output.getAmount(0) * multiplier;
        int amount1 = output.getAmount(1) * multiplier;
        int amount2 = output.getAmount(2) * multiplier;
        int amount_liquid = output.getAmount(3) * multiplier;
        return (amount0 > 0 && this.content[0] != null && this.content[0].field_77994_a >= amount0 || amount0 <= 0 && this.content[0] == null) && (amount1 > 0 && this.content[1] != null && this.content[1].field_77994_a >= amount1 || amount1 <= 0 && this.content[1] == null) && (amount2 > 0 && this.content[2] != null && this.content[2].field_77994_a >= amount2 || amount2 <= 0 && this.content[2] == null) && (amount_liquid > 0 && this.inputTank.getFluid() != null && this.inputTank.getFluidAmount() >= amount_liquid || amount_liquid <= 0);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isRedstoneEnabled()) {
            if (this.currentChemOperation != null) {
                if (this.consumePower(this.currentChemOperation.getPowerPerTick())) {
                    ++this.progress;
                    if (this.field_145850_b.field_72995_K) {
                        this.playAmbientSound();
                        this.createParticles();
                    }
                    if (!this.field_145850_b.field_72995_K && this.progress >= this.totalTime) {
                        if (this.content[3] == null && this.currentChemOperation.getItemOutput() != null) {
                            this.content[3] = new ItemStack(this.currentChemOperation.getItemOutput().func_77973_b(), this.currentChemOperation.getItemOutput().field_77994_a * this.stackmultiplier, this.currentChemOperation.getItemOutput().func_77960_j());
                        } else if (this.currentChemOperation.getItemOutput() != null) {
                            this.content[3].field_77994_a += this.currentChemOperation.getItemOutput().field_77994_a * this.stackmultiplier;
                        }
                        if (this.currentChemOperation.getLiquidOutput() != null) {
                            if (this.outputTank.getFluid() == null) {
                                this.outputTank.setFluid(new FluidStack(this.currentChemOperation.getLiquidOutput().getFluid(), this.currentChemOperation.getLiquidOutput().amount * this.stackmultiplier));
                            } else {
                                this.outputTank.getFluid().amount += this.currentChemOperation.getLiquidOutput().amount * this.stackmultiplier;
                            }
                        }
                        this.progress = 0;
                        this.totalTime = 0;
                        this.currentChemOperation = null;
                        this.stackmultiplier = 0;
                        this.checkAndStartOperation();
                        this.needUpdate();
                    }
                }
            } else if (!(this.content[0] == null && this.content[1] == null || this.field_145850_b.field_72995_K)) {
                this.checkAndStartOperation();
            }
        }
    }

    public void checkAndStartOperation() {
        ChemLabRecipes.ChemLabOutput output = ChemLabRecipes.getOutputFor(this.content[0], this.content[1], this.content[2], this.inputTank.getFluid());
        if (output != null && this.canOutput(output)) {
            int maxStack = 1;
            if (this.content[4] != null && this.content[4].func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && this.content[4].func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
                maxStack = this.content[4].field_77994_a + 1;
            }
            this.stackmultiplier = 1;
            for (int i = maxStack; i > 1; --i) {
                if (!this.canOutput(output, i) || !this.canConsume(output, i)) continue;
                this.stackmultiplier = i;
                break;
            }
            if (output.getAmount(0) > 0) {
                this.content[0].field_77994_a -= output.getAmount(0) * this.stackmultiplier;
                if (this.content[0].field_77994_a <= 0) {
                    this.content[0] = null;
                }
            }
            if (output.getAmount(1) > 0) {
                this.content[1].field_77994_a -= output.getAmount(1) * this.stackmultiplier;
                if (this.content[1].field_77994_a <= 0) {
                    this.content[1] = null;
                }
            }
            if (output.getAmount(2) > 0) {
                this.content[2].field_77994_a -= output.getAmount(2) * this.stackmultiplier;
                if (this.content[2].field_77994_a <= 0) {
                    this.content[2] = null;
                }
            }
            if (output.getAmount(3) > 0) {
                this.inputTank.drain(output.getAmount(3) * this.stackmultiplier, true);
            }
            this.progress = 0;
            this.totalTime = 100;
            ItemStack itemoutput = null;
            if (output.getItemOutput() != null) {
                itemoutput = TGItems.newStack(output.getItemOutput(), output.getItemOutput().field_77994_a);
            }
            this.currentChemOperation = new ChemLabRecipes.ChemLabOutput(itemoutput, output.getLiquidOutput(), output.getAmount(0), output.getAmount(1), output.getAmount(2), output.getAmount(3), output.getPowerPerTick());
            if (!this.field_145850_b.field_72995_K) {
                this.needUpdate();
            }
        }
    }

    public int getValidSlotForItemInMachine(ItemStack item) {
        if (this.content[0] != null && OreDictionary.itemMatches((ItemStack)this.content[0], (ItemStack)item, (boolean)true)) {
            return 0;
        }
        if (this.content[1] != null && OreDictionary.itemMatches((ItemStack)this.content[1], (ItemStack)item, (boolean)true)) {
            return 1;
        }
        if (this.content[0] == null && ChemLabRecipes.hasRecipeUsing(item)) {
            return 0;
        }
        if (this.content[0] != null && this.content[1] == null && ChemLabRecipes.allowAsInput2(this.content[0], item)) {
            return 1;
        }
        if (this.content[2] != null && OreDictionary.itemMatches((ItemStack)this.content[2], (ItemStack)item, (boolean)true)) {
            return 2;
        }
        if (this.content[2] == null && ChemLabRecipes.allowInFlaskSlot(item)) {
            return 2;
        }
        if (item != null && item.func_77973_b() == TGItems.machineStackUpgrade.func_77973_b() && item.func_77960_j() == TGItems.machineStackUpgrade.func_77960_j()) {
            return 4;
        }
        return -1;
    }

    private void playAmbientSound() {
        int soundTick1 = 1;
        int halfTime = Math.round((float)this.totalTime * 0.5f);
        if (this.progress == soundTick1 || this.progress == soundTick1 + halfTime) {
            this.field_145850_b.func_72980_b((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "techguns:machines.chemlabWork", 1.0f, 1.0f, true);
        }
    }

    private void createParticles() {
        int delay = 10;
        if (this.progress % delay == 0) {
            this.field_145850_b.func_72869_a("spell", (double)((float)this.field_145851_c + this.rng.nextFloat()), (double)((float)this.field_145848_d + this.rng.nextFloat()), (double)((float)this.field_145849_e + this.rng.nextFloat()), 0.0, 1.0, 0.0);
        }
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.inputTank.getInfo(), this.outputTank.getInfo()};
    }

    public void setFluidAmountIn(int value) {
        FluidStack fluid = this.inputTank.getFluid();
        if (fluid != null) {
            fluid.amount = value;
        }
    }

    public void setFluidAmountOut(int value) {
        FluidStack fluid = this.outputTank.getFluid();
        if (fluid != null) {
            fluid.amount = value;
        }
    }

    public int getFluidType(boolean output) {
        FluidStack fluidstack = output ? this.outputTank.getFluid() : this.inputTank.getFluid();
        if (fluidstack != null) {
            return fluidstack.getFluidID();
        }
        return -1;
    }

    public void setFluidTypeIn(int id) {
        Fluid f = FluidRegistry.getFluid((int)id);
        if (f != null) {
            this.inputTank.setFluid(new FluidStack(f, 0));
        } else {
            this.inputTank.setFluid(null);
        }
    }

    public void setFluidTypeOut(int id) {
        Fluid f = FluidRegistry.getFluid((int)id);
        if (f != null) {
            this.outputTank.setFluid(new FluidStack(f, 0));
        } else {
            this.outputTank.setFluid(null);
        }
    }

    public byte getDrainMode() {
        return (byte)(this.drainInput ? 1 : 0);
    }

    @Override
    public void buttonClicked(int id, EntityPlayer ply) {
        if (id <= 2) {
            super.buttonClicked(id, ply);
        } else if (this.func_70300_a(ply)) {
            switch (id) {
                case 3: {
                    this.inputTank.setFluid(null);
                    this.needUpdate();
                    break;
                }
                case 4: {
                    this.outputTank.setFluid(null);
                    this.needUpdate();
                    break;
                }
                case 5: {
                    this.drainInput = !this.drainInput;
                    this.needUpdate();
                }
            }
        }
    }
}

