/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.block;

import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import techguns.blocks.IBlockCamoChangeable;
import techguns.client.renderer.block.RenderGenericBlock;
import techguns.client.renderer.block.TessellatorCubeProper;

public class RenderLadder
extends RenderGenericBlock {
    ResourceLocation texture;
    ModelBase model;
    float scale;

    public RenderLadder(ModelBase model, ResourceLocation texture, float scale) {
        this.texture = texture;
        this.model = model;
        this.scale = scale;
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.6f, (float)-0.45f, (float)-1.0f);
        tess.func_78382_b();
        this.renderLadder(block, metadata);
        tess.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78372_c((float)x, (float)y, (float)z);
        this.adjustLightFixture(world, x, y, z, block);
        tess.func_78380_c(block.func_149677_c(world, x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderLadder(block, meta);
        tess.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    protected void renderLadder(Block block, int meta) {
        double px = 0.0625;
        TessellatorCubeProper cube = new TessellatorCubeProper(block, meta);
        Tessellator tess = Tessellator.field_78398_a;
        if ((meta %= ((IBlockCamoChangeable)block).getMetaOffset()) == 3) {
            cube.drawStandardCube(tess, 0.0, 0.0, 0.0, 2.0 * px, 1.0, 2.0 * px);
            cube.drawStandardCube(tess, 0.0, 0.0, 14.0 * px, 2.0 * px, 1.0, 1.0);
            for (int i = 0; i < 16; i += 4) {
                cube.drawStandardCube(tess, 0.0, (double)(i + 1) * px, 2.0 * px, 2.0 * px, (double)(i + 3) * px, 14.0 * px);
            }
        } else if (meta == 1) {
            cube.drawStandardCube(tess, 0.0, 0.0, 0.0, 2.0 * px, 1.0, 2.0 * px);
            cube.drawStandardCube(tess, 14.0 * px, 0.0, 0.0, 1.0, 1.0, 2.0 * px);
            for (int i = 0; i < 16; i += 4) {
                cube.drawStandardCube(tess, 2.0 * px, (double)(i + 1) * px, 0.0, 14.0 * px, (double)(i + 3) * px, 2.0 * px);
            }
        } else if (meta == 2) {
            cube.drawStandardCube(tess, 14.0 * px, 0.0, 14.0 * px, 1.0, 1.0, 1.0);
            cube.drawStandardCube(tess, 14.0 * px, 0.0, 0.0, 1.0, 1.0, 2.0 * px);
            for (int i = 0; i < 16; i += 4) {
                cube.drawStandardCube(tess, 14.0 * px, (double)(i + 1) * px, 2.0 * px, 1.0, (double)(i + 3) * px, 14.0 * px);
            }
        } else {
            cube.drawStandardCube(tess, 0.0, 0.0, 14.0 * px, 2.0 * px, 1.0, 1.0);
            cube.drawStandardCube(tess, 14.0 * px, 0.0, 14.0 * px, 1.0, 1.0, 1.0);
            for (int i = 0; i < 16; i += 4) {
                cube.drawStandardCube(tess, 2.0 * px, (double)(i + 1) * px, 14.0 * px, 14.0 * px, (double)(i + 3) * px, 1.0);
            }
        }
    }

    private void adjustLightFixture(IBlockAccess world, int i, int j, int k, Block block) {
        Tessellator tess = Tessellator.field_78398_a;
        float brightness = block.getLightValue(world, i, j, k);
        int skyLight = world.func_72802_i(i, j, k, 0);
        int modulousModifier = skyLight % 65536;
        int divModifier = skyLight / 65536;
        tess.func_78386_a(brightness, brightness, brightness);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)modulousModifier, (float)divModifier);
    }
}

