/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RegistryHelper;
import sonar.core.utils.IBufManager;
import sonar.core.utils.IBufObject;
import sonar.core.utils.INBTManager;
import sonar.core.utils.INBTObject;

public abstract class NBTRegistryHelper<T extends INBTObject>
extends RegistryHelper
implements INBTManager<T> {
    @Override
    public T readFromNBT(NBTTagCompound tag) {
        return (T)NBTHelper.readNBTObject(tag, this);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, T object) {
        NBTHelper.writeNBTObject(object, tag);
    }

    public static abstract class Buf<T extends IBufObject>
    extends NBTRegistryHelper<T>
    implements IBufManager<T> {
        @Override
        public T readFromBuf(ByteBuf buf) {
            return (T)NBTHelper.readBufObject(buf, this);
        }

        @Override
        public void writeToBuf(ByteBuf buf, T object) {
            NBTHelper.writeBufObject(object, buf);
        }
    }
}

