/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.SonarAPI;
import sonar.core.api.SonarProvider;
import sonar.core.api.StoredItemStack;

public abstract class InventoryHandler
extends SonarProvider {
    public int getID() {
        return SonarAPI.getRegistry().getInventorHandlerID(this.getName());
    }

    public abstract boolean canHandleItems(TileEntity var1, ForgeDirection var2);

    public abstract StoredItemStack getStack(int var1, TileEntity var2, ForgeDirection var3);

    public abstract StoredItemStack addStack(StoredItemStack var1, TileEntity var2, ForgeDirection var3, ActionType var4);

    public abstract StoredItemStack removeStack(StoredItemStack var1, TileEntity var2, ForgeDirection var3, ActionType var4);

    public abstract StorageSize getItems(List<StoredItemStack> var1, TileEntity var2, ForgeDirection var3);

    public static class StorageSize {
        public static final StorageSize EMPTY = new StorageSize(0L, 0L);
        private long stored;
        private long max;

        public StorageSize(long stored, long max) {
            this.stored = stored;
            this.max = max;
        }

        public long getStoredFluids() {
            return this.stored;
        }

        public long getMaxFluids() {
            return this.max;
        }

        public void addItems(long add) {
            this.stored += add;
        }

        public void addStorage(long add) {
            this.max += add;
        }
    }
}

