/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCoords {
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int dimension;
    private boolean hasDimension;

    public BlockCoords(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.hasDimension = false;
    }

    public BlockCoords(int x, int y, int z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.hasDimension = true;
        this.dimension = dimension;
    }

    public BlockCoords(TileEntity tile) {
        this.xCoord = tile.field_145851_c;
        this.yCoord = tile.field_145848_d;
        this.zCoord = tile.field_145849_e;
        if (tile.func_145831_w() == null) {
            this.hasDimension = false;
        } else {
            this.hasDimension = true;
            this.dimension = tile.func_145831_w().field_73011_w.field_76574_g;
        }
    }

    public BlockCoords(TileEntity tile, int dimension) {
        this.xCoord = tile.field_145851_c;
        this.yCoord = tile.field_145848_d;
        this.zCoord = tile.field_145849_e;
        this.hasDimension = true;
        this.dimension = dimension;
    }

    public int getX() {
        return this.xCoord;
    }

    public int getY() {
        return this.yCoord;
    }

    public int getZ() {
        return this.zCoord;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean hasDimension() {
        return this.hasDimension;
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.xCoord, this.yCoord, this.zCoord);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
    }

    public Block getBlock() {
        if (this.hasDimension()) {
            return this.getWorld().func_147439_a(this.xCoord, this.yCoord, this.zCoord);
        }
        return null;
    }

    public TileEntity getTileEntity() {
        if (this.hasDimension()) {
            return this.getWorld().func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        }
        return null;
    }

    public World getWorld() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer world = server.func_71218_a(this.getDimension());
        return world;
    }

    public static void writeToBuf(ByteBuf tag, BlockCoords coords) {
        tag.writeInt(coords.xCoord);
        tag.writeInt(coords.yCoord);
        tag.writeInt(coords.zCoord);
        tag.writeInt(coords.dimension);
    }

    public static BlockCoords readFromBuf(ByteBuf tag) {
        return new BlockCoords(tag.readInt(), tag.readInt(), tag.readInt(), tag.readInt());
    }

    public static void writeToNBT(NBTTagCompound tag, BlockCoords coords) {
        tag.func_74768_a("x", coords.xCoord);
        tag.func_74768_a("y", coords.yCoord);
        tag.func_74768_a("z", coords.zCoord);
        tag.func_74757_a("hasDimension", coords.hasDimension);
        tag.func_74768_a("dimension", coords.dimension);
    }

    public static BlockCoords readFromNBT(NBTTagCompound tag) {
        if (tag.func_74767_n("hasDimension")) {
            return new BlockCoords(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("dimension"));
        }
        return new BlockCoords(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static void writeBlockCoords(NBTTagCompound tag, List<BlockCoords> coords, String tagName) {
        NBTTagList list = new NBTTagList();
        if (coords != null) {
            for (int i = 0; i < coords.size(); ++i) {
                if (coords.get(i) == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                BlockCoords.writeToNBT(compound, coords.get(i));
                list.func_74742_a((NBTBase)compound);
            }
        }
        tag.func_74782_a(tagName, (NBTBase)list);
    }

    public static void writeBlockCoords(NBTTagCompound tag, BlockCoords[] coords) {
        NBTTagList list = new NBTTagList();
        if (coords != null) {
            for (int i = 0; i < coords.length; ++i) {
                if (coords[i] == null) continue;
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74774_a("Slot", (byte)i);
                BlockCoords.writeToNBT(compound, coords[i]);
                list.func_74742_a((NBTBase)compound);
            }
        }
        tag.func_74782_a("BlockCoords", (NBTBase)list);
    }

    public static List<BlockCoords> readBlockCoords(NBTTagCompound tag, String tagName) {
        ArrayList<BlockCoords> coords = new ArrayList<BlockCoords>();
        if (tag.func_74764_b(tagName)) {
            NBTTagList list = tag.func_150295_c(tagName, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                coords.add(BlockCoords.readFromNBT(compound));
            }
        }
        return coords;
    }

    public static BlockCoords[] readBlockCoords(NBTTagCompound tag, int listSize) {
        NBTTagList list = tag.func_150295_c("BlockCoords", 10);
        BlockCoords[] coords = new BlockCoords[listSize];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte b = compound.func_74771_c("Slot");
            if (b < 0 || b >= listSize) continue;
            coords[b] = BlockCoords.readFromNBT(compound);
        }
        return coords;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BlockCoords)) {
            return false;
        }
        BlockCoords coords = (BlockCoords)obj;
        return this.xCoord == coords.xCoord && this.yCoord == coords.yCoord && this.zCoord == coords.zCoord && this.dimension == coords.dimension;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.hasDimension ? 0 : 1);
        result = 37 * result + this.xCoord;
        result = 37 * result + this.yCoord;
        result = 37 * result + this.zCoord;
        result = 37 * result + this.dimension;
        return result;
    }

    public static boolean equalCoords(BlockCoords coords1, BlockCoords coords2) {
        if (coords1 == null && coords2 == null) {
            return true;
        }
        if (coords1 != null && coords2 == null) {
            return false;
        }
        if (coords2 != null && coords1 == null) {
            return false;
        }
        return coords1.xCoord == coords2.xCoord && coords1.yCoord == coords2.yCoord && coords1.zCoord == coords2.zCoord && coords1.dimension == coords2.dimension;
    }

    public static boolean equalCoordArrays(BlockCoords[] coords1, BlockCoords[] coords2) {
        if (coords1.length != coords2.length) {
            return false;
        }
        for (int i = 0; i < coords1.length; ++i) {
            if (BlockCoords.equalCoords(coords1[i], coords2[i])) continue;
            return false;
        }
        return true;
    }

    public static BlockCoords translateCoords(BlockCoords coords, ForgeDirection dir) {
        return new BlockCoords(coords.getX() + dir.offsetX, coords.getY() + dir.offsetY, coords.getZ() + dir.offsetZ, coords.dimension);
    }

    public String toString() {
        return "X: " + this.xCoord + " Y: " + this.yCoord + " Z: " + this.zCoord + " D: " + this.dimension;
    }

    public BlockCoords fromString(String string) {
        String[] split = string.split(": ");
        int x = Integer.parseInt(split[1]);
        int y = Integer.parseInt(split[3]);
        int z = Integer.parseInt(split[5]);
        int d = Integer.parseInt(split[7]);
        return new BlockCoords(x, y, z, d);
    }

    public boolean contains(Map<BlockCoords, ?> map) {
        for (Map.Entry<BlockCoords, ?> set : map.entrySet()) {
            if (!set.getKey().equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(List<BlockCoords> list) {
        for (BlockCoords coords : list) {
            if (!coords.equals(this)) continue;
            return true;
        }
        return false;
    }
}

