/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class RailcraftHandler
extends ModHandlerBase {
    private static final RailcraftHandler instance = new RailcraftHandler();
    public final Block hiddenID;
    private final Block cubeID;
    public final Block oreID;
    public final Item firestoneID;

    private RailcraftHandler() {
        Block idhidden = null;
        Block idcube = null;
        Block idore = null;
        Item idfirestone = null;
        if (this.hasMod()) {
            try {
                Item i;
                Block b;
                Class<?> c = Class.forName("mods.railcraft.common.blocks.hidden.BlockHidden");
                Field block = c.getDeclaredField("block");
                block.setAccessible(true);
                idhidden = b = (Block)block.get(null);
                c = Class.forName("mods.railcraft.common.blocks.aesthetics.cube.BlockCube");
                block = c.getDeclaredField("instance");
                block.setAccessible(true);
                idcube = b = (Block)block.get(null);
                c = Class.forName("mods.railcraft.common.blocks.ore.BlockOre");
                block = c.getDeclaredField("instance");
                block.setAccessible(true);
                idore = b = (Block)block.get(null);
                c = Class.forName("mods.railcraft.common.items.firestone.ItemFirestoneRaw");
                Field item = c.getDeclaredField("item");
                item.setAccessible(true);
                idfirestone = i = (Item)item.get(null);
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.hiddenID = idhidden;
        this.cubeID = idcube;
        this.oreID = idore;
        this.firestoneID = idfirestone;
    }

    public boolean isPoorOre(Block b, int meta) {
        return b == this.oreID && meta >= 7;
    }

    public boolean isDarkOre(Block b, int meta) {
        return b == this.oreID && ReikaMathLibrary.isValueInsideBoundsIncl(2, 4, meta);
    }

    public static RailcraftHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.hiddenID != null && this.firestoneID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.RAILCRAFT;
    }

    public static enum Blocks {
        COKE,
        CONCRETE,
        STEEL,
        INFERNALBRICK,
        CRUSHEDOBSIDIAN,
        SANDYBRICK,
        ABYSSAL,
        QUARRIED,
        CREOSOTE,
        COPPER,
        TIN,
        LEAD;


        public int getMetadata() {
            return this.ordinal();
        }

        public boolean match(Block b, int meta) {
            return b == instance.cubeID && meta == this.getMetadata();
        }

        public ItemStack getItem() {
            return new ItemStack(instance.cubeID, 1, this.getMetadata());
        }
    }
}

