/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.HybridTank;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ReikaFluidHelper {
    private static final MultiMap<Fluid, FluidContainer> containers = new MultiMap();
    private static final HashMap<String, String> nameSwaps = new HashMap();
    private static final HashMap<String, Integer> fluidColorMap = new HashMap();
    private static boolean init;
    public static final Comparator<FluidStack> fluidStackComparator;

    public static void initEarlyRegistrations() {
        if (!init) {
            FluidContainerRegistry.FluidContainerData[] dat = FluidContainerRegistry.getRegisteredFluidContainerData();
            for (int i = 0; i < dat.length; ++i) {
                FluidContainerRegistry.FluidContainerData fcd = dat[i];
                if (fcd.fluid == null || fcd.filledContainer == null) continue;
                ReikaFluidHelper.mapContainerToFluid(fcd.fluid.getFluid(), fcd.emptyContainer, fcd.filledContainer);
            }
            init = true;
        }
    }

    public static void mapContainerToFluid(Fluid f, ItemStack empty, ItemStack filled) {
        containers.addValue(f, new FluidContainer(filled, empty));
    }

    public static ArrayList<ItemStack> getAllContainersFor(Fluid f) {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (FluidContainer fc : containers.get(f)) {
            if (fc.filled == null) continue;
            c.add(fc.filled);
        }
        return c;
    }

    public static ArrayList<ItemStack> getAllEmptyContainers() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (FluidContainer fc : containers.allValues(false)) {
            if (fc.empty == null) continue;
            c.add(fc.empty);
        }
        return c;
    }

    public static boolean isInfinite(Fluid f) {
        return f == FluidRegistry.WATER;
    }

    public static void sortFluids(ArrayList<FluidStack> li) {
        Collections.sort(li, fluidStackComparator);
    }

    public static String fluidToString(Fluid f) {
        return f.getUnlocalizedName() + "[" + f + "](" + f.getID() + ")";
    }

    public static String fluidStackToString(FluidStack f) {
        return f.amount + "x" + f.getUnlocalizedName() + "[" + f.getFluid() + "](" + f.getFluidID() + ")" + "{" + f.tag + "}";
    }

    public static void registerNameSwap(String old, String next) {
        nameSwaps.put(old, next);
    }

    public static String getFluidNameSwap(String oldName) {
        return nameSwaps.get(oldName);
    }

    public static String getOldNameIfApplicable(String fluidName) {
        if (fluidName == null) {
            return fluidName;
        }
        String repl = nameSwaps.get(fluidName);
        return repl != null ? repl : fluidName;
    }

    public static boolean isFluidNullOrMatch(Fluid f, HybridTank tank) {
        return f == null || f == tank.getActualFluid();
    }

    public static boolean isFluidDrainableFromTank(Fluid f, HybridTank tank) {
        return !tank.isEmpty() && ReikaFluidHelper.isFluidNullOrMatch(f, tank);
    }

    public static boolean isFlammable(Fluid f) {
        String s = f.getName().toLowerCase(Locale.ENGLISH);
        if (s.contains("fuel")) {
            return true;
        }
        if (s.contains("ethanol")) {
            return true;
        }
        if (s.contains("oil")) {
            return true;
        }
        if (s.equals("creosote")) {
            return true;
        }
        if (s.contains("gas")) {
            return true;
        }
        if (s.endsWith("ane") || s.endsWith("ene") || s.endsWith("yne")) {
            return true;
        }
        return s.endsWith("ol") || s.endsWith("al") || s.endsWith("one");
    }

    public static int getFluidColor(Fluid f) {
        int c = f.getColor();
        if (c == 0xFFFFFF && fluidColorMap.containsKey(f.getName())) {
            c = fluidColorMap.get(f.getName());
        }
        return c;
    }

    static {
        fluidColorMap.put("water", 26111);
        fluidColorMap.put("lava", 0xFF3300);
        fluidColorMap.put("ender", 25712);
        fluidColorMap.put("glowstone", 16770142);
        fluidColorMap.put("redstone", 0xBC0000);
        fluidColorMap.put("cryotheum", 4382719);
        fluidColorMap.put("steam", 0xD0D0D0);
        fluidColorMap.put("xp", 8716032);
        fluidColorMap.put("for.honey", 16753408);
        fluidColorMap.put("ic2distilledwater", 5203426);
        fluidColorMap.put("oil", 0x101010);
        fluidColorMap.put("fuel", 12886784);
        fluidColorMap.put("creosote", 9844480);
        fluidColorMap.put("biomass", 3515702);
        init = false;
        fluidStackComparator = new FluidStackComparator();
    }

    private static class FluidStackComparator
    implements Comparator<FluidStack> {
        private FluidStackComparator() {
        }

        @Override
        public int compare(FluidStack o1, FluidStack o2) {
            if (o1.getFluidID() == o2.getFluidID()) {
                return o1.amount - o2.amount;
            }
            return o1.getFluidID() - o2.getFluidID();
        }
    }

    private static class FluidContainer {
        private final ItemStack filled;
        private final ItemStack empty;

        private FluidContainer(ItemStack fill, ItemStack emp) {
            this.filled = fill;
            this.empty = emp;
        }
    }
}

