/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.CommutativePair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ReikaSortingHelper {
    private static boolean debug = false;

    public static void bubbleSort(List li) {
        ReikaSortingHelper.bubbleSort(li, new DefaultComparator());
    }

    public static void bubbleSort(List li, Comparator c) {
        if (li.size() > 1) {
            for (int i = 0; i < li.size(); ++i) {
                for (int x = 1; x < li.size() - i; ++x) {
                    Object o = li.get(x);
                    Object p = li.get(x - 1);
                    if (c.compare(p, o) <= 0) continue;
                    Object temp = p;
                    li.set(x - 1, o);
                    li.set(x, temp);
                }
            }
        }
    }

    public static void mergeSort(List li) {
        ReikaSortingHelper.mergeSort(li, new DefaultComparator());
    }

    public static void mergeSort(List li, Comparator c) {
        if (li.size() > 1) {
            int mid = li.size() / 2;
            List left = li.subList(0, mid);
            List right = li.subList(mid, li.size());
            ReikaSortingHelper.mergeSort(left);
            ReikaSortingHelper.mergeSort(right);
            ReikaSortingHelper.merge(li, left, right, c);
        }
    }

    private static void merge(List li, List left, List right, Comparator c) {
        int sum = left.size() + right.size();
        int i = 0;
        int il = 0;
        int ir = 0;
        while (i < sum) {
            Object ol = left.get(il);
            Object or = right.get(ir);
            if (il < left.size() && ir < right.size()) {
                if (c.compare(ol, or) < 0) {
                    li.set(i, ol);
                    ++i;
                    ++il;
                    continue;
                }
                li.set(i, or);
                ++i;
                ++ir;
                continue;
            }
            if (il >= left.size()) {
                while (ir < right.size()) {
                    li.set(i, or);
                    ++i;
                    ++ir;
                }
            }
            if (ir < right.size()) continue;
            while (il < left.size()) {
                li.set(i, ol);
                ++il;
                ++i;
            }
        }
    }

    public static void allPairSort(ArrayList li) {
        ReikaSortingHelper.allPairSort(li, new DefaultComparator());
    }

    public static void allPairSort(ArrayList li, Comparator c) {
        HashMap<ImmutablePair, Integer> map = new HashMap<ImmutablePair, Integer>();
        ArrayList pairs = new ArrayList();
        for (Object o1 : li) {
            for (Object o2 : li) {
                CommutativePair cp = new CommutativePair(o1, o2);
                if (pairs.contains(cp)) continue;
                map.put(new ImmutablePair(o1, o2), c.compare(o1, o2));
                pairs.add(cp);
            }
        }
        DragonAPICore.log("About to perform a very slow sorting! If your game locks up here, come to Reika with this message!");
        DragonAPICore.log("Size: " + li.size() + "; Contents: " + li + "; Map: " + map);
        boolean flag = ReikaSortingHelper.sortListByPairMap(li, map);
        int cycles = 1;
        while (flag) {
            if (debug) {
                DragonAPICore.log(cycles + " cycles.");
            }
            flag = ReikaSortingHelper.sortListByPairMap(li, map);
            ++cycles;
        }
    }

    private static boolean sortListByPairMap(ArrayList li, HashMap<ImmutablePair, Integer> map) {
        for (int i = 0; i < li.size(); ++i) {
            Object o1 = li.get(i);
            for (int k = 0; k < li.size(); ++k) {
                Object o2 = li.get(k);
                Integer rel = map.get(new ImmutablePair(o1, o2));
                if (rel == null) continue;
                if (debug) {
                    // empty if block
                }
                if ((rel >= 0 || i <= k) && (rel <= 0 || i >= k)) continue;
                if (debug) {
                    String s = rel < 0 && i > k ? "after when it should be before" : "before when it should be after";
                    DragonAPICore.log("Swapping " + o1 + " and " + o2 + ": o1 was " + s);
                }
                li.set(i, o2);
                li.set(k, o1);
                return true;
            }
        }
        return false;
    }

    private static class DefaultComparator
    implements Comparator<Comparable> {
        private DefaultComparator() {
        }

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    }
}

