/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.Transient;

public class DoubleRectangle {
    public double x;
    public double y;
    public double width;
    public double height;
    private static final long serialVersionUID = -4345857070255674764L;

    private static native void initIDs();

    public DoubleRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DoubleRectangle(DoubleRectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public DoubleRectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public DoubleRectangle(int width, int height) {
        this(0.0, 0.0, width, height);
    }

    public DoubleRectangle(Point p, Dimension d) {
        this(p.x, p.y, d.width, d.height);
    }

    public DoubleRectangle(Point p) {
        this(p.x, p.y, 0.0, 0.0);
    }

    public DoubleRectangle(Dimension d) {
        this(0.0, 0.0, d.width, d.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    @Transient
    public DoubleRectangle getBounds() {
        return new DoubleRectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(DoubleRectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.reshape(x, y, width, height);
    }

    public void setRect(double x, double y, double width, double height) {
        int newh;
        int newy;
        int neww;
        int newx;
        if (x > 4.294967294E9) {
            newx = Integer.MAX_VALUE;
            neww = -1;
        } else {
            newx = DoubleRectangle.clip(x, false);
            if (width >= 0.0) {
                width += x - (double)newx;
            }
            neww = DoubleRectangle.clip(width, width >= 0.0);
        }
        if (y > 4.294967294E9) {
            newy = Integer.MAX_VALUE;
            newh = -1;
        } else {
            newy = DoubleRectangle.clip(y, false);
            if (height >= 0.0) {
                height += y - (double)newy;
            }
            newh = DoubleRectangle.clip(height, height >= 0.0);
        }
        this.reshape(newx, newy, neww, newh);
    }

    private static int clip(double v, boolean doceil) {
        if (v <= -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        if (v >= 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        return (int)(doceil ? Math.ceil(v) : Math.floor(v));
    }

    @Deprecated
    public void reshape(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(double x, double y) {
        this.move(x, y);
    }

    @Deprecated
    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void translate(double dx, double dy) {
        double oldv = this.x;
        double newv = oldv + dx;
        if (dx < 0.0) {
            if (newv > oldv) {
                if (this.width >= 0.0) {
                    this.width += newv - -2.147483648E9;
                }
                newv = -2.147483648E9;
            }
        } else if (newv < oldv) {
            if (this.width >= 0.0) {
                this.width += newv - 2.147483647E9;
                if (this.width < 0.0) {
                    this.width = 2.147483647E9;
                }
            }
            newv = 2.147483647E9;
        }
        this.x = newv;
        oldv = this.y;
        newv = oldv + dy;
        if (dy < 0.0) {
            if (newv > oldv) {
                if (this.height >= 0.0) {
                    this.height += newv - -2.147483648E9;
                }
                newv = -2.147483648E9;
            }
        } else if (newv < oldv) {
            if (this.height >= 0.0) {
                this.height += newv - 2.147483647E9;
                if (this.height < 0.0) {
                    this.height = 2.147483647E9;
                }
            }
            newv = 2.147483647E9;
        }
        this.y = newv;
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    @Deprecated
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(double x, double y) {
        return this.inside(x, y);
    }

    public boolean contains(DoubleRectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean contains(double X, double Y, double W, double H) {
        double w = this.width;
        double h = this.height;
        double x = this.x;
        double y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        w += x;
        if ((W += X) <= X ? w >= x || W > w : w >= x && W > w) {
            return false;
        }
        h += y;
        return !((H += Y) <= Y ? h >= y || H > h : h >= y && H > h);
    }

    @Deprecated
    public boolean inside(double X, double Y) {
        double w = this.width;
        double h = this.height;
        double x = this.x;
        double y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        return ((w += x) < x || w > X) && ((h += y) < y || h > Y);
    }

    public boolean intersects(DoubleRectangle r) {
        double tw = this.width;
        double th = this.height;
        double rw = r.width;
        double rh = r.height;
        if (rw <= 0.0 || rh <= 0.0 || tw <= 0.0 || th <= 0.0) {
            return false;
        }
        double tx = this.x;
        double ty = this.y;
        double rx = r.x;
        double ry = r.y;
        return ((rw += rx) < rx || rw > tx) && ((rh += ry) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
    }

    public DoubleRectangle intersection(DoubleRectangle r) {
        double tx1 = this.x;
        double ty1 = this.y;
        double rx1 = r.x;
        double ry1 = r.y;
        double tx2 = tx1;
        tx2 += this.width;
        double ty2 = ty1;
        ty2 += this.height;
        double rx2 = rx1;
        rx2 += r.width;
        double ry2 = ry1;
        ry2 += r.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        tx2 -= tx1;
        ty2 -= ty1;
        if (tx2 < -2.147483648E9) {
            tx2 = -2.147483648E9;
        }
        if (ty2 < -2.147483648E9) {
            ty2 = -2.147483648E9;
        }
        return new DoubleRectangle(tx1, ty1, (int)tx2, (int)ty2);
    }

    public DoubleRectangle union(DoubleRectangle r) {
        double tx2 = this.width;
        double ty2 = this.height;
        double rx2 = r.width;
        double ry2 = r.height;
        double tx1 = this.x;
        double ty1 = this.y;
        tx2 += tx1;
        ty2 += ty1;
        double rx1 = r.x;
        double ry1 = r.y;
        rx2 += rx1;
        ry2 += ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        tx2 -= tx1;
        ty2 -= ty1;
        if (tx2 > 2.147483647E9) {
            tx2 = 2.147483647E9;
        }
        if (ty2 > 2.147483647E9) {
            ty2 = 2.147483647E9;
        }
        return new DoubleRectangle(tx1, ty1, (int)tx2, (int)ty2);
    }

    public void add(double newx, double newy) {
        double x1 = this.x;
        double y1 = this.y;
        double x2 = this.width;
        double y2 = this.height;
        x2 += x1;
        y2 += y1;
        if (x1 > newx) {
            x1 = newx;
        }
        if (y1 > newy) {
            y1 = newy;
        }
        if (x2 < newx) {
            x2 = newx;
        }
        if (y2 < newy) {
            y2 = newy;
        }
        x2 -= x1;
        y2 -= y1;
        if (x2 > 2.147483647E9) {
            x2 = 2.147483647E9;
        }
        if (y2 > 2.147483647E9) {
            y2 = 2.147483647E9;
        }
        this.reshape(x1, y1, (int)x2, (int)y2);
    }

    public void add(Point pt) {
        this.add(pt.x, pt.y);
    }

    public void add(DoubleRectangle r) {
        double tx2 = this.width;
        double ty2 = this.height;
        double rx2 = r.width;
        double ry2 = r.height;
        double tx1 = this.x;
        double ty1 = this.y;
        tx2 += tx1;
        ty2 += ty1;
        double rx1 = r.x;
        double ry1 = r.y;
        rx2 += rx1;
        ry2 += ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        tx2 -= tx1;
        ty2 -= ty1;
        if (tx2 > 2.147483647E9) {
            tx2 = 2.147483647E9;
        }
        if (ty2 > 2.147483647E9) {
            ty2 = 2.147483647E9;
        }
        this.reshape(tx1, ty1, (int)tx2, (int)ty2);
    }

    public void grow(double h, double v) {
        double x0 = this.x;
        double y0 = this.y;
        double x1 = this.width;
        double y1 = this.height;
        x1 += x0;
        y1 += y0;
        x0 -= h;
        y0 -= v;
        x1 += h;
        y1 += v;
        if (x1 < x0) {
            if ((x1 -= x0) < -2.147483648E9) {
                x1 = -2.147483648E9;
            }
            if (x0 < -2.147483648E9) {
                x0 = -2.147483648E9;
            } else if (x0 > 2.147483647E9) {
                x0 = 2.147483647E9;
            }
        } else {
            if (x0 < -2.147483648E9) {
                x0 = -2.147483648E9;
            } else if (x0 > 2.147483647E9) {
                x0 = 2.147483647E9;
            }
            x1 -= x0;
            if (x1 < -2.147483648E9) {
                x1 = -2.147483648E9;
            } else if (x1 > 2.147483647E9) {
                x1 = 2.147483647E9;
            }
        }
        if (y1 < y0) {
            if ((y1 -= y0) < -2.147483648E9) {
                y1 = -2.147483648E9;
            }
            if (y0 < -2.147483648E9) {
                y0 = -2.147483648E9;
            } else if (y0 > 2.147483647E9) {
                y0 = 2.147483647E9;
            }
        } else {
            if (y0 < -2.147483648E9) {
                y0 = -2.147483648E9;
            } else if (y0 > 2.147483647E9) {
                y0 = 2.147483647E9;
            }
            y1 -= y0;
            if (y1 < -2.147483648E9) {
                y1 = -2.147483648E9;
            } else if (y1 > 2.147483647E9) {
                y1 = 2.147483647E9;
            }
        }
        this.reshape((int)x0, (int)y0, (int)x1, (int)y1);
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public int outcode(double x, double y) {
        int out = 0;
        if (this.width <= 0.0) {
            out |= 5;
        } else if (x < this.x) {
            out |= 1;
        } else if (x > this.x + this.width) {
            out |= 4;
        }
        if (this.height <= 0.0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 2;
        } else if (y > this.y + this.height) {
            out |= 8;
        }
        return out;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleRectangle) {
            DoubleRectangle r = (DoubleRectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    static {
        new Rectangle(0, 0, 0, 0);
    }
}

