/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ButterflyAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.Bees.TreeAlleleRegistry;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import com.google.common.base.Strings;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterflyGenome;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CustomRecipeList {
    private final DragonAPIMod mod;
    public final String recipeType;
    private LuaBlock.LuaBlockDatabase data = new LuaBlock.LuaBlockDatabase();
    private final HashSet<LuaBlock> entries = new HashSet();
    private final HashMap<String, Class> lookups = new HashMap();
    private static final HashMap<String, DelegateLookup> delegateCalls = new HashMap();
    private static final Pattern STACKSIZE_PATTERN;

    public CustomRecipeList(DragonAPIMod mod, String type) {
        this.mod = mod;
        this.recipeType = type;
    }

    public void addFieldLookup(String key, Class c) {
        this.lookups.put(key, c);
    }

    public final void load() {
        File folder = new File(this.getBaseFilepath());
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        ArrayList<File> files = ReikaFileReader.getAllFilesInFolder(folder, this.getExtension());
        this.load(files);
    }

    public final void load(File f) {
        this.load(ReikaJavaLibrary.makeListFrom((Object)f));
    }

    public final void load(Collection<File> files) {
        this.clear();
        for (File f : files) {
            this.data.loadFromFile(f);
        }
        this.parseLuaBlocks();
    }

    public void clear() {
        this.data = new LuaBlock.LuaBlockDatabase();
        this.entries.clear();
    }

    private void parseLuaBlocks() {
        LuaBlock root = this.data.getRootBlock();
        for (LuaBlock b : root.getChildren()) {
            try {
                this.data.addBlock(b.getString("type"), b);
                this.mod.getModLogger().debug("Loaded recipe prototype:\n" + b.getString("type"));
                this.entries.add(b);
            }
            catch (Exception e) {
                this.mod.getModLogger().logError("Could not parse custom recipe section " + b.getString("type") + ": ");
                e.printStackTrace();
            }
        }
        this.mod.getModLogger().log("All custom " + this.recipeType + " recipe entries parsed.");
    }

    public Collection<LuaBlock> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    private final String getBaseFilepath() {
        return this.mod.getConfigFolder().getAbsolutePath() + "/" + this.mod.getDisplayName() + "_CustomRecipes/";
    }

    private String getExtension() {
        return ".recipes_" + this.recipeType;
    }

    public final Object parseObjectString(String item) {
        if (item.equals("null") || item.equals("empty") || item.equals("~") || item.equals("-")) {
            return null;
        }
        if (item.startsWith("ore:")) {
            return item.substring("ore:".length());
        }
        return this.parseItemString(item, null, true);
    }

    public final Collection<ItemStack> parseItemCollection(Collection<String> in, boolean tolerateNull) {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (String s : in) {
            ItemStack is = this.parseItemString(s, null, tolerateNull);
            if (is != null) {
                c.add(is);
                continue;
            }
            if (tolerateNull) continue;
            throw new IllegalArgumentException("Null stack not permitted!");
        }
        return c;
    }

    public final ItemStack parseItemString(String s, LuaBlock nbt, boolean tolerateNull) {
        String key;
        if (Strings.isNullOrEmpty((String)s)) {
            if (tolerateNull) {
                return null;
            }
            throw new IllegalArgumentException("Null stack not permitted!");
        }
        String lookup = s;
        ItemStack ret = null;
        Matcher m = STACKSIZE_PATTERN.matcher(s);
        int amt = 1;
        if (m.find() && m.group(2) != null) {
            lookup = m.group(1);
            amt = Integer.parseInt(m.group(2));
            if (amt > 64) {
                throw new IllegalArgumentException("Stack size of " + amt + " is too large!");
            }
            if (amt <= 0) {
                throw new IllegalArgumentException("Stack size of " + amt + " is zero!");
            }
        }
        if ((key = s.substring(0, s.indexOf(58))).equals("delegate")) {
            DelegateLookup delegate = delegateCalls.get(lookup = lookup.substring(key.length() + 1));
            if (delegate == null) {
                throw new IllegalArgumentException("No such Delegate Lookup '" + lookup + "'!");
            }
            ItemStack is = delegate.getItem(nbt);
            if (is == null && !tolerateNull) {
                throw new IllegalArgumentException("Delegate Lookup '" + lookup + "' yielded no item!");
            }
            return is;
        }
        if (this.lookups.containsKey(key)) {
            try {
                lookup = lookup.substring(key.length() + 1);
                ret = (ItemStack)this.lookups.get(key).getField(lookup).get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No internal stack '" + lookup + "'");
            }
        } else {
            ret = ReikaItemHelper.lookupItem(lookup);
            if (ret == null) {
                throw new IllegalArgumentException("No such item '" + lookup + "'");
            }
        }
        ret = ReikaItemHelper.getSizedItemStack(ret, amt);
        if (ret != null && nbt != null) {
            ret.field_77990_d = ReikaNBTHelper.constructNBT(nbt);
        }
        if (ret == null && !tolerateNull) {
            throw new IllegalArgumentException("Null stack not permitted!");
        }
        return ret;
    }

    public final IRecipe parseCraftingRecipe(LuaBlock lb, ItemStack output) {
        boolean shaped = lb.getBoolean("shaped");
        if (shaped) {
            String input1 = lb.containsKey("input_top") ? lb.getString("input_top").replaceAll(" ", "") : null;
            String input2 = lb.containsKey("input_middle") ? lb.getString("input_middle").replaceAll(" ", "") : null;
            String input3 = lb.containsKey("input_bottom") ? lb.getString("input_bottom").replaceAll(" ", "") : null;
            String[] top = input1 != null ? input1.split(",") : null;
            String[] middle = input2 != null ? input2.split(",") : null;
            String[] bottom = input3 != null ? input3.split(",") : null;
            int w = 0;
            if (top != null) {
                w = top.length;
            }
            if (middle != null) {
                if (w != 0 && w != middle.length) {
                    throw new IllegalArgumentException("Rows must be of equal length!");
                }
                w = middle.length;
            }
            if (bottom != null) {
                if (w != 0 && w != bottom.length) {
                    throw new IllegalArgumentException("Rows must be of equal length!");
                }
                w = bottom.length;
            }
            if (w > 3) {
                throw new IllegalArgumentException("Rows must be at most three entries long!");
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            if (top != null) {
                rows.add(top);
            }
            if (middle != null) {
                rows.add(middle);
            }
            if (bottom != null) {
                rows.add(bottom);
            }
            Object[][] array = new Object[rows.size()][w];
            for (int i = 0; i < rows.size(); ++i) {
                for (int k = 0; k < w; ++k) {
                    String item = ((String[])rows.get(i))[k];
                    array[i][k] = this.parseObjectString(item);
                }
            }
            return new ShapedOreRecipe(output, ReikaRecipeHelper.decode2DArray(array));
        }
        String input = lb.getString("input").replaceAll(" ", "");
        String[] parts = input.split(",");
        if (parts.length > 9) {
            throw new IllegalArgumentException("You cannot have more than nine items in recipes!");
        }
        Object[] inputs = new Object[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            Object o = this.parseObjectString(s);
            if (o == null) {
                throw new IllegalArgumentException("You cannot have blank spaces in shapeless recipes!");
            }
            inputs[i] = o;
        }
        return new ShapelessOreRecipe(output, inputs);
    }

    static {
        if (ModList.MYSTCRAFT.isLoaded()) {
            delegateCalls.put("myst_page", new MystPageLookup());
        }
        if (ModList.FORESTRY.isLoaded()) {
            delegateCalls.put("forestry_bee", new BeeLookup());
            delegateCalls.put("forestry_tree", new TreeLookup());
            delegateCalls.put("forestry_butterfly", new ButterflyLookup());
        }
        STACKSIZE_PATTERN = Pattern.compile("(.+?)(?:\\*(\\d+))?$");
    }

    private static class ButterflyLookup
    implements DelegateLookup {
        private ButterflyLookup() {
        }

        @Override
        public ItemStack getItem(LuaBlock data) {
            EnumFlutterType type = EnumFlutterType.valueOf((String)data.getString("class").toUpperCase(Locale.ENGLISH));
            ItemStack ret = ReikaBeeHelper.getButterflyItem(data.getString("species"), type);
            for (int i = 0; i < EnumButterflyChromosome.values().length; ++i) {
                String key;
                EnumButterflyChromosome ec = EnumButterflyChromosome.values()[i];
                if (ec == EnumButterflyChromosome.SPECIES || !data.containsKey(key = ec.name().toLowerCase(Locale.ENGLISH))) continue;
                IAlleleBoolean ia = null;
                switch (ec) {
                    case NOCTURNAL: 
                    case TOLERANT_FLYER: 
                    case FIRE_RESIST: {
                        ia = ReikaBeeHelper.getBooleanAllele(data.getBoolean(key));
                        break;
                    }
                    case EFFECT: 
                    case TERRITORY: 
                    case FERTILITY: 
                    case FLOWER_PROVIDER: 
                    case LIFESPAN: 
                    case METABOLISM: 
                    case SIZE: 
                    case SPEED: {
                        String val = data.getString(key);
                        ButterflyAlleleRegistry.ButterflyGene bg = ButterflyAlleleRegistry.getEnum(ec, val);
                        ia = bg.getAllele();
                        break;
                    }
                    case HUMIDITY_TOLERANCE: 
                    case TEMPERATURE_TOLERANCE: {
                        EnumTolerance et = EnumTolerance.valueOf((String)data.getString(key).toUpperCase(Locale.ENGLISH));
                        ia = ReikaBeeHelper.getToleranceGene(et);
                        break;
                    }
                }
                if (ia == null) continue;
                IButterflyGenome ibg = (IButterflyGenome)ReikaBeeHelper.getGenome(ret);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, false);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, true);
            }
            return ret;
        }
    }

    private static class TreeLookup
    implements DelegateLookup {
        private TreeLookup() {
        }

        @Override
        public ItemStack getItem(LuaBlock data) {
            EnumGermlingType type = EnumGermlingType.valueOf((String)data.getString("class").toUpperCase(Locale.ENGLISH));
            ItemStack ret = ReikaBeeHelper.getTreeItem(data.getString("species"), type);
            for (int i = 0; i < EnumTreeChromosome.values().length; ++i) {
                String key;
                EnumTreeChromosome ec = EnumTreeChromosome.values()[i];
                if (ec == EnumTreeChromosome.SPECIES || !data.containsKey(key = ec.name().toLowerCase(Locale.ENGLISH))) continue;
                IAlleleBoolean ia = null;
                switch (ec) {
                    case FIREPROOF: {
                        ia = ReikaBeeHelper.getBooleanAllele(data.getBoolean(key));
                        break;
                    }
                    case EFFECT: 
                    case FERTILITY: 
                    case FRUITS: 
                    case GIRTH: 
                    case HEIGHT: 
                    case MATURATION: 
                    case PLANT: 
                    case SAPPINESS: 
                    case TERRITORY: 
                    case YIELD: 
                    case GROWTH: {
                        String val = data.getString(key);
                        TreeAlleleRegistry.TreeGene bg = TreeAlleleRegistry.getEnum(ec, val);
                        ia = bg.getAllele();
                        break;
                    }
                }
                if (ia == null) continue;
                ITreeGenome ibg = (ITreeGenome)ReikaBeeHelper.getGenome(ret);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, false);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, true);
            }
            return ret;
        }
    }

    private static class BeeLookup
    implements DelegateLookup {
        private BeeLookup() {
        }

        @Override
        public ItemStack getItem(LuaBlock data) {
            EnumBeeType type = EnumBeeType.valueOf((String)data.getString("class").toUpperCase(Locale.ENGLISH));
            ItemStack ret = ReikaBeeHelper.getBeeItem(data.getString("species"), type);
            for (int i = 0; i < EnumBeeChromosome.values().length; ++i) {
                String key;
                EnumBeeChromosome ec = EnumBeeChromosome.values()[i];
                if (ec == EnumBeeChromosome.SPECIES || !data.containsKey(key = ec.name().toLowerCase(Locale.ENGLISH))) continue;
                IAlleleBoolean ia = null;
                switch (ec) {
                    case CAVE_DWELLING: 
                    case NOCTURNAL: 
                    case TOLERANT_FLYER: {
                        ia = ReikaBeeHelper.getBooleanAllele(data.getBoolean(key));
                        break;
                    }
                    case EFFECT: 
                    case FERTILITY: 
                    case FLOWER_PROVIDER: 
                    case FLOWERING: 
                    case LIFESPAN: 
                    case SPEED: 
                    case TERRITORY: {
                        String val = data.getString(key);
                        BeeAlleleRegistry.BeeGene bg = BeeAlleleRegistry.getEnum(ec, val);
                        ia = bg.getAllele();
                        break;
                    }
                    case HUMIDITY_TOLERANCE: 
                    case TEMPERATURE_TOLERANCE: {
                        EnumTolerance et = EnumTolerance.valueOf((String)data.getString(key).toUpperCase(Locale.ENGLISH));
                        ia = ReikaBeeHelper.getToleranceGene(et);
                        break;
                    }
                }
                if (ia == null) continue;
                IBeeGenome ibg = (IBeeGenome)ReikaBeeHelper.getGenome(ret);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, false);
                ReikaBeeHelper.setGene(ret, ibg, ec, (IAllele)ia, true);
            }
            return ret;
        }
    }

    private static class MystPageLookup
    implements DelegateLookup {
        private MystPageLookup() {
        }

        @Override
        public ItemStack getItem(LuaBlock data) {
            return ReikaMystcraftHelper.getSymbolPage(data.getString("symbol"));
        }
    }

    public static interface DelegateLookup {
        public ItemStack getItem(LuaBlock var1);
    }
}

