/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.GUI;

import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class StatusLogger {
    private final ArrayList<String> data = new ArrayList();

    public void addStatus(String sg, boolean state) {
        this.addStatus(sg, state ? State.ACTIVE : State.INACTIVE);
    }

    public void addStatus(String sg, State s) {
        this.data.add(s.color + sg + ": " + s.tag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.data) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void sendToPlayer(EntityPlayer ep) {
        for (String s : this.data) {
            ReikaChatHelper.sendChatToPlayer(ep, s);
        }
    }

    public static enum State {
        ACTIVE(EnumChatFormatting.GREEN, "True"),
        INACTIVE(EnumChatFormatting.RED, "False"),
        CONDITIONAL(EnumChatFormatting.BLUE, "Conditional"),
        WARN(EnumChatFormatting.YELLOW, "Warning"),
        ERROR(EnumChatFormatting.LIGHT_PURPLE, "Error");

        private final EnumChatFormatting color;
        private final String tag;

        private State(EnumChatFormatting c, String s) {
            this.color = c;
            this.tag = s;
        }
    }
}

