/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Maps;

import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NestedMap<K, M, V> {
    private final HashMap<K, HashMap<M, V>> data = new HashMap();
    private final MultiMap<M, K> innerSet = new MultiMap(new MultiMap.HashSetFactory());
    private final HashSet<V> valueSet = new HashSet();

    public V put(K key, M inner, V value) {
        HashMap<Object, V> map = this.data.get(key);
        if (map == null) {
            map = new HashMap();
            this.data.put(key, map);
        }
        this.innerSet.addValue(inner, key);
        this.valueSet.add(value);
        return map.put(inner, value);
    }

    public V get(K key, M inner) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? (V)map.get(inner) : null;
    }

    public V remove(K key, M inner) {
        HashMap<M, V> map = this.data.get(key);
        if (map != null) {
            if (map.containsKey(inner)) {
                this.innerSet.remove(inner, key);
                this.rebuildValues();
            }
            return map.remove(inner);
        }
        return null;
    }

    private void rebuildValues() {
        this.valueSet.clear();
        for (HashMap<M, V> map : this.data.values()) {
            this.valueSet.addAll(map.values());
        }
    }

    public void removeAll(M inner) {
        Collection<K> keys = this.innerSet.get(inner);
        for (K key : keys) {
            this.remove(key, inner);
        }
    }

    public int size() {
        return this.valueSet.size();
    }

    public void putAll(NestedMap map) {
        this.data.putAll(map.data);
        this.innerSet.putAll(map.innerSet);
        this.valueSet.addAll(map.valueSet);
    }

    public void clear() {
        this.data.clear();
        this.innerSet.clear();
        this.valueSet.clear();
    }

    public Set<K> keySet() {
        return this.data.keySet();
    }

    public Collection<M> innerSet() {
        return this.innerSet.keySet();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.valueSet);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean containsValue(V value) {
        return this.valueSet.contains(value);
    }

    public boolean containsKey(K key) {
        return this.data.containsKey(key);
    }

    public boolean containsInnerKey(M inner) {
        return this.innerSet.containsKey(inner);
    }

    public Collection<M> getAllKeysIn(K key) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? map.keySet() : null;
    }

    public Map<M, V> getMap(K key) {
        HashMap<M, V> map = this.data.get(key);
        return map != null ? Collections.unmodifiableMap(map) : null;
    }
}

