/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.Collections;

import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public final class ChancedOutputList {
    private final ItemHashMap<Float> data = new ItemHashMap();
    private boolean modifiable = true;
    private final boolean allowOverflow;

    public ChancedOutputList(boolean allowOver100) {
        this.allowOverflow = false;
    }

    public ChancedOutputList(boolean allowOver100, ItemHashMap<Float> output) {
        this(allowOver100);
        for (ItemStack is : output.keySet()) {
            this.data.put(is.func_77946_l(), output.get(is));
        }
    }

    public ChancedOutputList(boolean allowOver100, ItemStack[] items, float ... chances) {
        this(allowOver100);
        for (int i = 0; i < items.length; ++i) {
            this.data.put(items[i].func_77946_l(), Float.valueOf(chances[i]));
        }
    }

    public ChancedOutputList addItem(ItemStack is, float chance) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        this.data.put(is, Float.valueOf(chance));
        return this;
    }

    public Float removeItem(ItemStack is) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        return this.data.remove(is);
    }

    public ChancedOutputList addItems(ArrayList<ItemStack> li, float chance) {
        for (ItemStack is : li) {
            this.addItem(is, chance);
        }
        return this;
    }

    public Collection<ItemStack> keySet() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        for (ItemStack is : this.data.keySet()) {
            c.add(is.func_77946_l());
        }
        return c;
    }

    public float getItemChance(ItemStack is) {
        Float get = this.data.get(is);
        return get != null ? (this.allowOverflow ? get.floatValue() : MathHelper.func_76131_a((float)get.floatValue(), (float)0.0f, (float)100.0f)) : 0.0f;
    }

    public float getNormalizedItemChance(ItemStack is) {
        float f = this.getItemChance(is);
        return Math.min(1.0f, f / 100.0f);
    }

    public ArrayList<ItemStack> getAllWithChance(float chance) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack key : this.data.keySet()) {
            float c = this.data.get(key).floatValue();
            if (c != chance) continue;
            li.add(key.func_77946_l());
        }
        return li;
    }

    public ArrayList<ItemStack> getAllWithAtLeastChance(float chance) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack key : this.data.keySet()) {
            float c = this.data.get(key).floatValue();
            if (!(c >= chance)) continue;
            li.add(key.func_77946_l());
        }
        return li;
    }

    public ArrayList<ItemStack> calculate() {
        return this.calculate(1.0);
    }

    public ArrayList<ItemStack> calculate(double factor) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack key : this.data.keySet()) {
            double ch;
            float c = this.data.get(key).floatValue();
            if (this.allowOverflow) {
                for (ch = factor * (double)c / 100.0; ch >= 1.0; ch -= 1.0) {
                    li.add(key.func_77946_l());
                }
            }
            if (!(ch >= 1.0) && !ReikaRandomHelper.doWithChance(ch)) continue;
            li.add(key.func_77946_l());
        }
        return li;
    }

    public ChancedOutputList copy() {
        return new ChancedOutputList(this.allowOverflow, this.data);
    }

    public ChancedOutputList lock() {
        this.modifiable = false;
        return this;
    }

    public String toString() {
        return this.data.toString();
    }

    public void manipulateChances(ChanceManipulator cm) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This ChancedOutputList is locked!");
        }
        for (ItemStack is : this.data.keySet()) {
            float c = cm.getChance(this.data.get(is).floatValue());
            if (!this.allowOverflow) {
                c = MathHelper.func_76131_a((float)c, (float)0.0f, (float)100.0f);
            }
            this.data.put(is, Float.valueOf(c));
        }
    }

    public static ChancedOutputList parseFromArray(boolean allowOver100, Object[] arr) {
        if (arr.length % 2 != 0) {
            throw new MisuseException("Every item must have a specified chance!");
        }
        ChancedOutputList c = new ChancedOutputList(allowOver100);
        for (int i = 0; i < arr.length; i += 2) {
            ItemStack is = ReikaItemHelper.parseItem(arr[i]);
            if (is == null) continue;
            Object chance = arr[i + 1];
            if (chance instanceof Integer) {
                chance = new Float(((Integer)chance).intValue());
            }
            c.addItem(is, ((Float)chance).floatValue());
        }
        return c;
    }

    public static class ChanceExponentiator
    implements ChanceManipulator {
        private final double power;

        public ChanceExponentiator(double power) {
            this.power = power;
        }

        @Override
        public float getChance(float original) {
            double p = (double)original / 100.0;
            double num = Math.pow(p, 1.0 / this.power);
            return (float)(100.0 * num);
        }
    }

    public static class ChanceMultiplier
    implements ChanceManipulator {
        private final float factor;

        public ChanceMultiplier(float factor) {
            this.factor = factor;
        }

        @Override
        public float getChance(float original) {
            return original * this.factor;
        }
    }

    public static interface ChanceManipulator {
        public float getChance(float var1);
    }
}

