/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Java.SemanticVersionParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipFile;

public class ModVersion
implements Comparable<ModVersion> {
    public static final ModVersion source = new ModVersion(0){

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public String toString() {
            return "Source Code";
        }

        @Override
        public boolean isCompiled() {
            return false;
        }

        @Override
        public boolean verify() {
            return false;
        }
    };
    private static final ModVersion error = new ModVersion(0){

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public String toString() {
            return "[NO FILE]";
        }

        @Override
        public boolean verify() {
            return false;
        }
    };
    public static final ModVersion timeout = new ModVersion(0){

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public String toString() {
            return "[URL TIMEOUT]";
        }

        @Override
        public boolean verify() {
            return false;
        }
    };
    public final int majorVersion;
    public final String subVersion;

    private ModVersion(int major) {
        this(major, '\u0000');
    }

    private ModVersion(int major, char minor) {
        this.majorVersion = major;
        this.subVersion = minor == '\u0000' ? "" : Character.toString(minor).toLowerCase(Locale.ENGLISH);
    }

    public boolean equals(Object o) {
        if (o instanceof ModVersion) {
            ModVersion m = (ModVersion)o;
            return m.majorVersion == this.majorVersion && m.subVersion.equals(this.subVersion);
        }
        return false;
    }

    public boolean isCompiled() {
        return true;
    }

    public boolean verify() {
        return true;
    }

    public String toString() {
        return "v" + this.majorVersion + this.subVersion;
    }

    public static ModVersion getFromString(String s) {
        char c;
        if (s.startsWith("$") || s.startsWith("@")) {
            return source;
        }
        if (s.contains("URL TIMEOUT")) {
            return timeout;
        }
        if (s.startsWith("v") || s.startsWith("V")) {
            s = s.substring(1);
        }
        if (Character.isDigit(c = s.charAt(s.length() - 1))) {
            return new ModVersion(Integer.parseInt(s));
        }
        String major = s.substring(0, s.length() - 1);
        return new ModVersion(Integer.parseInt(major), c);
    }

    private int getSubVersionIndex() {
        return this.subVersion == null || this.subVersion.isEmpty() ? 0 : this.subVersion.charAt(0) - 97;
    }

    @Override
    public int compareTo(ModVersion v) {
        return 32 * (this.majorVersion - v.majorVersion) + (this.getSubVersionIndex() - v.getSubVersionIndex());
    }

    public boolean isNewerMinorVersion(ModVersion v) {
        return v.majorVersion == this.majorVersion && v.getSubVersionIndex() < this.getSubVersionIndex();
    }

    public static ModVersion readFromJar(ZipFile jar, String innerName) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return source;
        }
        Properties p = new Properties();
        String path = ReikaStringParser.stripSpaces("version_" + ReikaStringParser.stripSpaces(innerName + ".properties"));
        try {
            InputStream stream = ModVersion.class.getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                return error;
            }
            p.load(stream);
            String mj = p.getProperty("Major");
            String mn = p.getProperty("Minor");
            if (mj == null || mn == null || mj.equals("null") || mn.equals("null") || mj.isEmpty() || mn.isEmpty()) {
                return error;
            }
            return ModVersion.getFromString(mj + mn);
        }
        catch (IOException e) {
            e.printStackTrace();
            return error;
        }
    }

    public static ModVersion readFromFile(DragonAPIMod mod) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            return source;
        }
        Properties p = new Properties();
        String path = ReikaStringParser.stripSpaces("version_" + ReikaStringParser.stripSpaces(mod.getTechnicalName().toLowerCase(Locale.ENGLISH)) + ".properties");
        try {
            InputStream stream = ModVersion.class.getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                throw new FileNotFoundException("Version file for " + mod.getDisplayName() + " is missing!");
            }
            p.load(stream);
            String mj = p.getProperty("Major");
            String mn = p.getProperty("Minor");
            if (mj == null || mn == null || mj.equals("null") || mn.equals("null") || mj.isEmpty() || mn.isEmpty()) {
                throw new InstallationException(mod, "The version file was either damaged, overwritten, or is missing!");
            }
            return ModVersion.getFromString(mj + mn);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InstallationException(mod, "The version file was either damaged, overwritten, or is missing!");
        }
    }

    public String toSemanticVersion() {
        return String.format("%d.%d", this.majorVersion, '\u0001' + this.subVersion.charAt(0) - 97);
    }

    public static ModVersion fromSemanticVersion(String s) {
        SemanticVersionParser.SemanticVersion sm = SemanticVersionParser.getVersion(s);
        int[] ver = sm.getVersions();
        int major = ver.length > 0 ? ver[0] : 1;
        int minor = ver.length > 1 ? ver[1] : 1;
        return new ModVersion(major, Character.toChars(96 + minor)[0]);
    }
}

