/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.Auxiliary.Trackers.CommandableUpdateChecker;
import Reika.DragonAPI.Auxiliary.Trackers.ModFileVersionChecker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.InstallationException;
import Reika.DragonAPI.Exception.InvalidBuildException;
import Reika.DragonAPI.Exception.JarZipException;
import Reika.DragonAPI.Exception.MissingASMException;
import Reika.DragonAPI.Exception.MissingDependencyException;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Exception.VersionMismatchException;
import Reika.DragonAPI.Extras.ModVersion;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.IO.ModLogger;
import Reika.DragonAPI.Libraries.IO.ReikaFormatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;

public abstract class DragonAPIMod {
    protected final boolean isDeObf;
    private final ModVersion version;
    private static ModVersion apiVersion;
    private static final HashMap<String, ModVersion> modVersions;
    private static final HashMap<String, DragonAPIMod> mods;
    private static final HashSet<DragonAPIMod> preInitSet;
    public static final EventBus DEDICATED_BUS;
    private static final EventBus EARLY_BUS;
    private final LoadProfiler profiler = new LoadProfiler(this);
    private String fileHash;

    @Mod.EventHandler
    public final void invalidFingerprint(FMLFingerprintViolationEvent event) {
    }

    protected DragonAPIMod() {
        this.profiler.startTiming(LoadProfiler.LoadPhase.CONSTRUCT);
        this.isDeObf = ReikaObfuscationHelper.isDeObfEnvironment();
        if (this.isDeObf) {
            ReikaJavaLibrary.pConsole(this.getDisplayName() + " is running in a deobfuscated environment!");
        } else {
            ReikaJavaLibrary.pConsole(this.getDisplayName() + " is not running in a deobfuscated environment.");
        }
        this.version = ModVersion.readFromFile(this);
        modVersions.put(this.getClass().getSimpleName(), this.version);
        mods.put(this.getTechnicalName(), this);
        ReikaJavaLibrary.pConsole("Registered " + this + " as version " + this.version);
        if (this.getClass() == DragonAPIInit.class) {
            apiVersion = this.version;
        }
        DEDICATED_BUS.register((Object)this);
        EARLY_BUS.register((Object)this);
        ReikaJavaLibrary.pConsole(this.getTechnicalName() + ": Constructed; Active Classloader is: " + this.getClass().getClassLoader());
        this.profiler.finishTiming();
    }

    protected boolean requireSameFilesOnClientAndServer() {
        return true;
    }

    public static DragonAPIMod getByName(String name) {
        return mods.get(name);
    }

    @Mod.EventHandler
    public abstract void preload(FMLPreInitializationEvent var1);

    @Mod.EventHandler
    public abstract void load(FMLInitializationEvent var1);

    @Mod.EventHandler
    public abstract void postload(FMLPostInitializationEvent var1);

    protected void postPreLoad() {
    }

    public final String getFileHash() {
        return this.fileHash;
    }

    public final boolean isSource() {
        return this.version == ModVersion.source;
    }

    protected final void basicSetup(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DragonAPIMod.checkFinalPreload(this);
        EARLY_BUS.unregister((Object)this);
        ReikaRegistryHelper.setupModData(this, evt);
        CommandableUpdateChecker.instance.registerMod(this);
        String string = this.fileHash = this.isSource() ? "Source" : ReikaFileReader.getHash(this.getModFile(), ReikaFileReader.HashType.SHA256);
        if (this.requireSameFilesOnClientAndServer() && DragonOptions.FILEHASH.getState()) {
            ModFileVersionChecker.instance.addMod(this);
        }
    }

    private static void checkFinalPreload(DragonAPIMod mod) {
        preInitSet.add(mod);
        DragonAPICore.log("Pre-initialized " + mod.getTechnicalName() + "; preloaded " + preInitSet.size() + "/" + mods.size() + " mods.");
        if (preInitSet.size() == mods.size()) {
            DragonAPICore.log("Finished all main preinit phases. Running post-pre init phase on " + preInitSet.size() + " mods.");
            for (DragonAPIMod mod2 : mods.values()) {
                mod2.postPreLoad();
            }
        }
    }

    protected final void verifyInstallation() {
        this.verifyVersions();
        if (this.getModFile().getName().endsWith(".jar.zip")) {
            throw new JarZipException(this);
        }
        this.verifyHash();
        Class<? extends IClassTransformer> asm = this.getASMClass();
        if (asm != null) {
            this.verifyASMLoaded(asm);
        }
    }

    protected Class<? extends IClassTransformer> getASMClass() {
        return null;
    }

    private void verifyASMLoaded(Class c) {
        for (IClassTransformer ic : Launch.classLoader.getTransformers()) {
            if (!c.isAssignableFrom(ic.getClass())) continue;
            return;
        }
        throw new MissingASMException(this);
    }

    private void verifyHash() {
        if (this.getModVersion().isCompiled()) {
            try {
                JarFile jf = new JarFile(this.getModFile());
                InputStream folder = ReikaFileReader.getFileInsideJar(jf, ReikaJavaLibrary.getTopLevelPackage(this.getClass()) + "/");
                String hash = "mchQtlxAlQLD4wrtfDwF-1GvsMvpXxDYzDFKIFiMf-AlGTm0y03wrdZBPy9OBV-KKqsAKnN6H72DZ0Q2wEg-kocPIyqjOYbJyScnnMR4-TlJWsS8CPkx4MO2xvj9O-XXUWSTa8SYbvJc2zx1X7-aD83HJXUnkItOsnlnB00-BDBnhO7eDi3SbTwEESM0-JFFuHyM3GLg7GopiCp5m";
                Manifest mf = jf.getManifest();
                if (mf == null) {
                    throw new InvalidBuildException(this, this.getModFile());
                }
                String attr = mf.getMainAttributes().getValue("ModHash");
                if (attr == null || hash == null || !hash.equals(attr)) {
                    throw new InvalidBuildException(this, this.getModFile());
                }
            }
            catch (IOException e) {
                throw new InvalidBuildException(this, this.getModFile());
            }
        }
    }

    protected final URL getClassFile() {
        return this.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    public final ModContainer getModContainer() {
        return (ModContainer)Loader.instance().getModObjectList().inverse().get((Object)this);
    }

    protected File getModFile() {
        return this.getModContainer().getSource();
    }

    private final void verifyVersions() {
        ModVersion mod = this.getModVersion();
        if (mod.verify()) {
            if (mod.majorVersion != DragonAPIMod.apiVersion.majorVersion || mod.isNewerMinorVersion(apiVersion)) {
                throw new VersionMismatchException.APIMismatchException(this, mod, apiVersion, "@MAJOR_VERSION@@MINOR_VERSION@");
            }
            HashMap<String, String> map = this.getDependencies();
            if (map != null) {
                for (String key : map.keySet()) {
                    String req = map.get(key);
                    ModVersion has = modVersions.get(key);
                    if (has == null) {
                        throw new MissingDependencyException(this, key);
                    }
                    if (!has.isCompiled() || req.equals(has.toString())) continue;
                    throw new VersionMismatchException(this, mod, key, has, req);
                }
            }
        }
    }

    protected HashMap<String, String> getDependencies() {
        return null;
    }

    protected final void onInit(FMLInitializationEvent event) {
    }

    protected final void onPostInit(FMLPostInitializationEvent evt) {
    }

    public abstract String getUpdateCheckURL();

    public abstract String getDisplayName();

    public abstract String getModAuthorName();

    public abstract URL getDocumentationSite();

    public abstract String getWiki();

    public abstract File getConfigFolder();

    public final URL getWikiLink() {
        try {
            return new URL(this.getWiki());
        }
        catch (MalformedURLException e) {
            throw new RegistrationException(this, "The mod provided a malformed URL for its documentation site!");
        }
    }

    public final String getTechnicalName() {
        return this.getDisplayName().toUpperCase();
    }

    protected void hasNoDragonAPI() {
        throw new InstallationException(this, "This mod needs DragonAPI to function correctly!");
    }

    public abstract ModLogger getModLogger();

    public final String toString() {
        return this.getTechnicalName();
    }

    public final ModVersion getModVersion() {
        return this.version;
    }

    protected final void startTiming(LoadProfiler.LoadPhase p) {
        this.profiler.startTiming(p);
    }

    protected final void finishTiming() {
        this.profiler.finishTiming();
    }

    public final boolean equals(Object o) {
        return o.getClass() == this.getClass() && ((DragonAPIMod)o).getTechnicalName().equalsIgnoreCase(this.getTechnicalName());
    }

    public final int hashCode() {
        return ~this.getClass().hashCode() ^ this.getTechnicalName().hashCode();
    }

    public final boolean isReikasMod() {
        return this.getClass().getName().startsWith("Reika.");
    }

    static {
        modVersions = new HashMap();
        mods = new HashMap();
        preInitSet = new HashSet();
        DEDICATED_BUS = new EventBus();
        EARLY_BUS = new EventBus();
    }

    public static final class LoadProfiler {
        private long time = -1L;
        private long total;
        private LoadPhase phase = null;
        private final DragonAPIMod mod;
        private final EnumMap<LoadPhase, Boolean> loaded = new EnumMap(LoadPhase.class);

        private LoadProfiler(DragonAPIMod mod) {
            this.mod = mod;
        }

        private void startTiming(LoadPhase p) {
            if (this.time != -1L) {
                throw new IllegalStateException(this.mod.getTechnicalName() + " is already profiling phase " + (Object)((Object)this.phase) + "!");
            }
            if (this.loaded.containsKey((Object)p) && this.loaded.get((Object)p).booleanValue()) {
                throw new IllegalStateException(this.mod.getTechnicalName() + " already finished profiling phase " + (Object)((Object)this.phase) + "!");
            }
            this.phase = p;
            this.time = System.currentTimeMillis();
        }

        protected void finishTiming() {
            long duration = System.currentTimeMillis() - this.time;
            if (this.time == -1L) {
                throw new IllegalStateException(this.mod.getTechnicalName() + " cannot stop profiling before it starts!");
            }
            this.time = -1L;
            String s = ReikaFormatHelper.millisToHMSms(duration);
            ReikaJavaLibrary.pConsole(this.mod.getTechnicalName() + ": Completed loading phase " + (Object)((Object)this.phase) + " in " + duration + " ms (" + s + ").");
            if (duration > 1800000L) {
                ReikaJavaLibrary.pConsole("Loading time exceeded thirty minutes, indicating very weak hardware. Beware of low framerates.");
            } else if (duration > 300000L) {
                ReikaJavaLibrary.pConsole("Loading time exceeded five minutes, indicating weaker hardware. Consider reducing settings.");
            }
            this.total += duration;
            if (this.phase == LoadPhase.POSTLOAD) {
                ReikaJavaLibrary.pConsole("Total mod loading time: " + this.total + " ms (" + ReikaFormatHelper.millisToHMSms(this.total) + ").");
            }
            this.phase = null;
        }

        public static enum LoadPhase {
            CONSTRUCT,
            PRELOAD,
            LOAD,
            POSTLOAD,
            LOADCOMPLETE;

        }
    }
}

