/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryCrafterAux;
import com.cout970.magneticraft.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileCrafter
extends TileBase
implements IInventoryManaged,
IGuiSync,
IGuiListener {
    private InventoryComponent inv = new InventoryComponent(this, 16, "Crafter"){

        @Override
        public void func_70299_a(int slot, ItemStack itemStack) {
            super.func_70299_a(slot, itemStack);
            if (TileCrafter.this.field_145850_b == null || ((TileCrafter)TileCrafter.this).field_145850_b.field_72995_K) {
                return;
            }
            TileCrafter.this.itemMatches = -1;
        }
    };
    private InventoryComponent invResult = new InventoryComponent(this, 1, "Result");
    private InventoryCrafting recipe = new InventoryCrafterAux(this, 3, 3);
    private List<InvSlot> checkedInvs = new ArrayList<InvSlot>();
    private List<TankInfo> checkedTanks = new ArrayList<TankInfo>();
    private int itemMatches = -1;
    private IRecipe craftRecipe;
    private int craftState = 0;
    public RedstoneState state = RedstoneState.NORMAL;

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        if (this.isPowered() && this.craftState == 0) {
            this.craftState = 1;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isPowered()) {
            if (this.craftState == 0) {
                this.craftState = 1;
            }
        } else if (this.craftState == 2) {
            this.craftState = 0;
        }
        if (this.itemMatches == -1) {
            this.refreshItemMatches();
        }
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.refreshItemMatches();
        }
        if (this.isControlled()) {
            if (this.craft()) {
                this.refreshItemMatches();
            }
            this.craftState = 2;
        }
    }

    @Override
    public boolean isControlled() {
        if (this.state == RedstoneState.NORMAL) {
            return !this.powered;
        }
        if (this.state == RedstoneState.INVERTED) {
            return this.powered;
        }
        return this.craftState == 1;
    }

    public void refreshRecipe() {
        this.craftRecipe = null;
        for (Object rec : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(rec instanceof IRecipe) || !((IRecipe)rec).func_77569_a(this.recipe, this.field_145850_b)) continue;
            this.craftRecipe = (IRecipe)rec;
            break;
        }
        if (this.craftRecipe != null) {
            ItemStack result = this.craftRecipe.func_77572_b(this.recipe);
            if (result == null) {
                this.craftRecipe = null;
            } else {
                this.invResult.func_70299_a(0, result);
            }
        } else {
            this.invResult.func_70299_a(0, null);
        }
    }

    public void refreshItemMatches() {
        this.itemMatches = 0;
        this.checkedInvs.clear();
        this.checkedTanks.clear();
        if (this.craftRecipe == null) {
            this.refreshRecipe();
            if (this.craftRecipe == null) {
                return;
            }
        }
        ItemStack result = this.craftRecipe.func_77572_b(this.recipe);
        block0: for (int slot = 0; slot < 9; ++slot) {
            if (this.recipe.func_70301_a(slot) == null) {
                this.itemMatches |= 1 << slot;
                continue;
            }
            if (this.findItemsFromInventory(slot, this, this.checkedInvs, result, MgDirection.UP)) {
                this.itemMatches |= 1 << slot;
                continue;
            }
            for (MgDirection dir : MgDirection.values()) {
                IInventory side;
                TileEntity t = MgUtils.getTileEntity((TileEntity)this, dir);
                if (t instanceof IInventory && this.findItemsFromInventory(slot, side = (IInventory)t, this.checkedInvs, result, dir)) {
                    this.itemMatches |= 1 << slot;
                    continue block0;
                }
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.recipe.func_70301_a(slot));
                if (fluid == null || !(t instanceof IFluidHandler)) continue;
                IFluidHandler tank = (IFluidHandler)t;
                boolean breaked = false;
                for (MgDirection d : MgDirection.values()) {
                    FluidStack f = tank.drain(d.toForgeDir(), 1000, false);
                    if (f == null || !MgUtils.areEqual(fluid, f)) continue;
                    TankInfo comp = new TankInfo(tank, dir);
                    if (this.checkedTanks.contains(comp)) {
                        TankInfo comp2 = this.checkedTanks.get(this.checkedTanks.indexOf(comp));
                        FluidStack f2 = tank.drain(d.toForgeDir(), comp2.amount + FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot)), false);
                        if (f2 == null || f2.amount != comp2.amount + FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot))) continue;
                        comp2.amount += FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot));
                        this.checkedTanks.add(comp);
                        this.itemMatches |= 1 << slot;
                        breaked = true;
                        break;
                    }
                    FluidStack f2 = tank.drain(d.toForgeDir(), FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot)), false);
                    if (f2 == null || f2.amount != FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot))) continue;
                    comp.amount = FluidContainerRegistry.getContainerCapacity((ItemStack)this.recipe.func_70301_a(slot));
                    this.checkedTanks.add(comp);
                    this.itemMatches |= 1 << slot;
                    breaked = true;
                    break;
                }
                if (breaked) continue block0;
            }
        }
    }

    public boolean craft() {
        int slot;
        ItemStack item;
        if (this.itemMatches == 511 && this.craftRecipe != null && (item = this.craftRecipe.func_77572_b(this.recipe)) != null && (slot = InventoryUtils.getSlotForStack(this.getInv(), item)) != -1) {
            for (InvSlot invSlot : this.checkedInvs) {
                InventoryUtils.remove(invSlot.inv, invSlot.slot, invSlot.amount, this.getInv());
            }
            for (TankInfo tankInfo : this.checkedTanks) {
                tankInfo.handler.drain(tankInfo.dir.toForgeDir(), tankInfo.amount, true);
            }
            if (InventoryUtils.canCombine(this.getInv().func_70301_a(slot), item, 64)) {
                ItemStack result = InventoryUtils.addition(this.getInv().func_70301_a(slot), item);
                this.getInv().func_70299_a(slot, result);
            } else if (!InventoryUtils.dropIntoInventory(item, this.getInv())) {
                BlockMg.dropItem(item, this.func_145831_w().field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145831_w());
            }
            this.checkedInvs.clear();
            return true;
        }
        return false;
    }

    private boolean findItemsFromInventory(int slot, IInventory inv, List<InvSlot> visited, ItemStack result, MgDirection dir) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack content = inv.func_70301_a(i);
            if (content == null || content.field_77994_a <= 0 || !this.canAccess(inv, i, dir) || !this.replaceMatrix(this.recipe, result, content, slot)) continue;
            InvSlot pos = new InvSlot(i, inv);
            if (!visited.contains(pos)) {
                visited.add(pos);
                return true;
            }
            InvSlot ex = visited.get(visited.indexOf(pos));
            if (content.field_77994_a <= ex.amount) continue;
            ++ex.amount;
            return true;
        }
        return false;
    }

    private boolean canAccess(IInventory inv, int slot, MgDirection dir) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            for (int i : sided.func_94128_d(dir.ordinal())) {
                if (i != slot) continue;
                if (!sided.func_102008_b(slot, sided.func_70301_a(slot), dir.ordinal())) break;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean replaceMatrix(InventoryCrafting craft, ItemStack result, ItemStack stack, int slot) {
        ItemStack item = craft.func_70301_a(slot);
        craft.func_70299_a(slot, stack);
        boolean ret = false;
        if (this.craftRecipe.func_77569_a(craft, this.field_145850_b)) {
            ItemStack newResult = this.craftRecipe.func_77572_b(craft);
            if (result == null || result.func_77973_b() == null) {
                return false;
            }
            ret = OreDictionary.itemMatches((ItemStack)result, (ItemStack)newResult, (boolean)true);
        }
        craft.func_70299_a(slot, item);
        return ret;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    public InventoryCrafting getRecipe() {
        return this.recipe;
    }

    public InventoryComponent getResult() {
        return this.invResult;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "Inv_1");
        InventoryUtils.loadInventory((IInventory)this.recipe, nbt, "Inv_2");
        this.invResult.readFromNBT(nbt, "Inv_3");
        this.itemMatches = nbt.func_74762_e("Matches");
        this.state = RedstoneState.values()[nbt.func_74771_c("State")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "Inv_1");
        InventoryUtils.saveInventory((IInventory)this.recipe, nbt, "Inv_2");
        this.invResult.writeToNBT(nbt, "Inv_3");
        nbt.func_74768_a("Matches", this.itemMatches);
        nbt.func_74774_a("State", (byte)this.state.ordinal());
    }

    public static RedstoneState step(RedstoneState state) {
        return state == RedstoneState.NORMAL ? RedstoneState.INVERTED : (state == RedstoneState.INVERTED ? RedstoneState.PULSE : RedstoneState.NORMAL);
    }

    public void setRedstoneState(RedstoneState e) {
        this.state = e;
        this.sendUpdateToClient();
    }

    public boolean found(int j) {
        return this.itemMatches != -1 && (this.craftRecipe == null || (this.itemMatches & 1 << j) > 0);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, this.itemMatches);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.itemMatches = value;
        }
    }

    @Override
    public void onMessageReceive(int id, int data) {
        if (id == 0) {
            if (data == 1) {
                for (int i = 0; i < 9; ++i) {
                    this.getRecipe().func_70299_a(i, null);
                }
                this.refreshRecipe();
            } else if (data == 0 && this.state == RedstoneState.PULSE) {
                this.craftState = 1;
            }
        }
    }

    public static enum RedstoneState {
        NORMAL,
        INVERTED,
        PULSE;

    }

    public class TankInfo {
        public MgDirection dir;
        public IFluidHandler handler;
        public int amount;

        public TankInfo(IFluidHandler f, MgDirection dir) {
            this.dir = dir;
            this.handler = f;
        }

        public boolean equals(Object o) {
            return o instanceof TankInfo && ((TankInfo)o).dir == this.dir && ((TankInfo)o).handler == this.handler;
        }
    }

    public class InvSlot {
        public ItemStack content;
        public int amount;
        public int slot;
        public IInventory inv;

        public InvSlot(int slot, IInventory inv) {
            this.inv = inv;
            this.slot = slot;
            this.inv = inv;
            this.amount = 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InvSlot) {
                InvSlot pos = (InvSlot)obj;
                return pos.slot == this.slot && pos.inv == this.inv && InventoryUtils.areExactlyEqual(this.content, pos.content);
            }
            return false;
        }
    }
}

