/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.tileentity;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.tileentity.MigrationHelper;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.protection.IProtected;
import com.carpentersblocks.util.protection.ProtectedObject;
import com.carpentersblocks.util.registry.FeatureRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TEBase
extends TileEntity
implements IProtected {
    protected static final String TAG_ATTR = "cbAttribute";
    protected static final String TAG_ATTR_LIST = "cbAttrList";
    protected static final String TAG_METADATA = "cbMetadata";
    protected static final String TAG_OWNER = "cbOwner";
    protected static final String TAG_CHISEL_DESIGN = "cbChiselDesign";
    protected static final String TAG_DESIGN = "cbDesign";
    public static final byte[] ATTR_COVER = new byte[]{0, 1, 2, 3, 4, 5, 6};
    public static final byte[] ATTR_DYE = new byte[]{7, 8, 9, 10, 11, 12, 13};
    public static final byte[] ATTR_OVERLAY = new byte[]{14, 15, 16, 17, 18, 19, 20};
    public static final byte ATTR_ILLUMINATOR = 21;
    public static final byte ATTR_PLANT = 22;
    public static final byte ATTR_SOIL = 23;
    public static final byte ATTR_FERTILIZER = 24;
    public static final byte ATTR_UPGRADE = 25;
    private static Map<Integer, Integer> cache = new HashMap<Integer, Integer>();
    protected Map<Byte, ItemStack> cbAttrMap = new HashMap<Byte, ItemStack>();
    protected String[] cbChiselDesign = new String[]{"", "", "", "", "", "", ""};
    protected int cbMetadata;
    protected String cbDesign = "";
    protected String cbOwner = "";
    protected static boolean calcLighting = false;
    private int tempMetadata;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cbAttrMap.clear();
        if (nbt.func_74764_b("owner")) {
            MigrationHelper.updateMappingsOnRead(this, nbt);
        } else {
            int idx;
            NBTTagList nbttaglist = nbt.func_150295_c(TAG_ATTR_LIST, 10);
            for (idx = 0; idx < nbttaglist.func_74745_c(); ++idx) {
                NBTTagCompound nbt1 = nbttaglist.func_150305_b(idx);
                ItemStack tempStack = ItemStack.func_77949_a((NBTTagCompound)nbt1);
                tempStack.field_77994_a = 1;
                byte attrId = (byte)(nbt1.func_74771_c(TAG_ATTR) & 0xFF);
                this.cbAttrMap.put(attrId, tempStack);
            }
            for (idx = 0; idx < 7; ++idx) {
                this.cbChiselDesign[idx] = nbt.func_74779_i("cbChiselDesign_" + idx);
            }
            this.convertDataToInt(nbt);
            this.cbDesign = nbt.func_74779_i(TAG_DESIGN);
            this.cbOwner = nbt.func_74779_i(TAG_OWNER);
        }
        this.updateWorld();
    }

    private boolean convertDataToInt(NBTTagCompound nbt) {
        if (nbt.func_74781_a(TAG_METADATA) instanceof NBTTagShort) {
            this.cbMetadata = nbt.func_74765_d(TAG_METADATA);
            return true;
        }
        this.cbMetadata = nbt.func_74762_e(TAG_METADATA);
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList itemstack_list = new NBTTagList();
        for (Map.Entry<Byte, ItemStack> entry : this.cbAttrMap.entrySet()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a(TAG_ATTR, entry.getKey().byteValue());
            entry.getValue().func_77955_b(nbt1);
            itemstack_list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a(TAG_ATTR_LIST, (NBTBase)itemstack_list);
        for (int idx = 0; idx < 7; ++idx) {
            nbt.func_74778_a("cbChiselDesign_" + idx, this.cbChiselDesign[idx]);
        }
        nbt.func_74768_a(TAG_METADATA, this.cbMetadata);
        nbt.func_74778_a(TAG_DESIGN, this.cbDesign);
        nbt.func_74778_a(TAG_OWNER, this.cbOwner);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public void copyOwner(TEBase TE) {
        this.cbOwner = TE.getOwner();
        this.func_70296_d();
    }

    @Override
    public void setOwner(ProtectedObject obj) {
        this.cbOwner = obj.toString();
        this.func_70296_d();
    }

    @Override
    public String getOwner() {
        return this.cbOwner;
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean hasAttribute(byte attrId) {
        return this.cbAttrMap.containsKey(attrId);
    }

    public ItemStack getAttribute(byte attrId) {
        return this.cbAttrMap.get(attrId);
    }

    public ItemStack getAttributeForDrop(byte attrId) {
        ItemStack itemStack = this.cbAttrMap.get(attrId);
        if (attrId <= ATTR_COVER[6]) {
            this.setDefaultMetadata(itemStack);
        }
        return itemStack;
    }

    private ItemStack setDefaultMetadata(ItemStack itemStack) {
        Block block = BlockProperties.toBlock(itemStack);
        if (BlockProperties.blockRotates(itemStack) || block instanceof BlockDirectional) {
            int dmgDrop = block.func_149692_a(itemStack.func_77960_j());
            Item itemDrop = block.func_149650_a(itemStack.func_77960_j(), this.func_145831_w().field_73012_v, 0);
            if (itemDrop != null && itemDrop.equals(itemStack.func_77973_b()) && dmgDrop != itemStack.func_77960_j()) {
                itemStack.func_77964_b(dmgDrop);
            }
        }
        return itemStack;
    }

    public void addAttribute(byte attrId, ItemStack itemStack) {
        if (this.hasAttribute(attrId) || itemStack == null) {
            return;
        }
        ItemStack reducedStack = ItemStack.func_77944_b((ItemStack)itemStack);
        reducedStack.field_77994_a = 1;
        this.cbAttrMap.put(attrId, reducedStack);
        World world = this.func_145831_w();
        Block block = BlockProperties.toBlock(itemStack);
        if (attrId < 7) {
            if (attrId == ATTR_COVER[6]) {
                int metadata = itemStack.func_77960_j();
                world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            }
            world.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, block);
        } else if (attrId == 22 | attrId == 23) {
            world.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, block);
        }
        if (attrId == 24) {
            this.func_145831_w().func_72926_e(2005, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        }
        this.updateWorld();
        this.func_70296_d();
    }

    public void onAttrDropped(byte attrId) {
        this.cbAttrMap.remove(attrId);
        this.updateWorld();
        this.func_70296_d();
    }

    public void createBlockDropEvent(byte attrId) {
        this.func_145831_w().func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), BlockCoverable.EVENT_ID_DROP_ATTR, (int)attrId);
    }

    public void removeAttributes(int side) {
        this.createBlockDropEvent(ATTR_COVER[side]);
        this.createBlockDropEvent(ATTR_DYE[side]);
        this.createBlockDropEvent(ATTR_OVERLAY[side]);
        if (side == 6) {
            this.createBlockDropEvent((byte)21);
        }
    }

    public boolean hasChiselDesign(int side) {
        return DesignHandler.listChisel.contains(this.getChiselDesign(side));
    }

    public String getChiselDesign(int side) {
        return this.cbChiselDesign[side];
    }

    public boolean setChiselDesign(int side, String iconName) {
        if (!this.cbChiselDesign.equals(iconName)) {
            this.cbChiselDesign[side] = iconName;
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void removeChiselDesign(int side) {
        if (!this.cbChiselDesign.equals("")) {
            this.cbChiselDesign[side] = "";
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    public int getData() {
        return this.cbMetadata;
    }

    public boolean setData(int data) {
        if (data != this.getData()) {
            this.cbMetadata = data;
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean hasDesign() {
        return DesignHandler.getListForType(this.getBlockDesignType()).contains(this.cbDesign);
    }

    public String getDesign() {
        return this.cbDesign;
    }

    public boolean setDesign(String name) {
        if (!this.cbDesign.equals(name)) {
            this.cbDesign = name;
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean removeDesign() {
        return this.setDesign("");
    }

    public String getBlockDesignType() {
        String name = this.func_145838_q().func_149739_a();
        return name.substring(new String("tile.blockCarpenters").length()).toLowerCase();
    }

    public boolean setNextDesign() {
        return this.setDesign(DesignHandler.getNext(this.getBlockDesignType(), this.cbDesign));
    }

    public boolean setPrevDesign() {
        return this.setDesign(DesignHandler.getPrev(this.getBlockDesignType(), this.cbDesign));
    }

    public void setMetadata(int metadata) {
        this.tempMetadata = this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 4);
    }

    public void restoreMetadata() {
        this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.tempMetadata, 4);
    }

    public void func_145843_s() {
        super.func_145843_s();
        int hash = BlockProperties.hashCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        cache.remove(hash);
    }

    public static int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        if (calcLighting) {
            return 0;
        }
        int hash = BlockProperties.hashCoords(x, y, z);
        Integer lookup = cache.get(hash);
        int value = 0;
        if (lookup == null) {
            TileEntity tileEntity = blockAccess.func_147438_o(x, y, z);
            if (tileEntity != null && tileEntity instanceof TEBase) {
                value = ((TEBase)tileEntity).getDynamicLightValue();
                cache.put(hash, value);
            }
        } else {
            value = lookup;
        }
        return value;
    }

    protected int getDynamicLightValue() {
        int value = 0;
        if (FeatureRegistry.enableIllumination && this.hasAttribute((byte)21)) {
            return 15;
        }
        calcLighting = true;
        for (Map.Entry<Byte, ItemStack> pair : this.cbAttrMap.entrySet()) {
            ItemStack itemStack = BlockProperties.getCallableItemStack(pair.getValue());
            Block block = BlockProperties.toBlock(itemStack);
            if (block == Blocks.field_150350_a) continue;
            this.setMetadata(itemStack.func_77960_j());
            value = Math.max(value, block.getLightValue((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e));
            if (value == 15) {
                return 15;
            }
            this.restoreMetadata();
        }
        calcLighting = false;
        return value;
    }

    private void updateWorld() {
        World world = this.func_145831_w();
        if (world != null) {
            int temp = this.getDynamicLightValue();
            int hash = BlockProperties.hashCoords(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            cache.put(hash, temp);
            world.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            world.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

