/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.data.ISided;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.collapsible.CollapsibleUtil;
import net.minecraftforge.common.util.ForgeDirection;

public class Collapsible
implements ISided {
    public static final Collapsible INSTANCE = new Collapsible();
    public static final int QUAD_XZNN = 0;
    public static final int QUAD_XZNP = 1;
    public static final int QUAD_XZPN = 2;
    public static final int QUAD_XZPP = 3;

    public static int getQuad(double hitX, double hitZ) {
        int xOffset = (int)Math.round(hitX);
        int zOffset = (int)Math.round(hitZ);
        if (xOffset == 0) {
            if (zOffset == 0) {
                return 0;
            }
            return 1;
        }
        if (zOffset == 0) {
            return 2;
        }
        return 3;
    }

    public static void setQuadDepth(TEBase TE, int quad, int depth, boolean markDirty) {
        if (depth < 0 || depth > 16) {
            return;
        }
        int data = TE.getData();
        switch (quad) {
            case 0: {
                data &= 0xFF83FFFF;
                data |= depth << 18;
                break;
            }
            case 1: {
                data &= 0xFFFC1FFF;
                data |= depth << 13;
                break;
            }
            case 2: {
                data &= 0xFFFFE0FF;
                data |= depth << 8;
                break;
            }
            case 3: {
                data &= 0xFFFFFF07;
                data |= depth << 3;
            }
        }
        if (TE.getData() != data) {
            TE.setData(data);
            if (markDirty) {
                TE.func_70296_d();
            }
        }
    }

    public static int getQuadDepth(TEBase TE, int quad) {
        int steps = 0;
        int data = TE.getData();
        switch (quad) {
            case 0: {
                steps = (data &= 0x7C0000) >> 18;
                break;
            }
            case 1: {
                steps = (data &= 0x3E000) >> 13;
                break;
            }
            case 2: {
                steps = (data &= 0x1F00) >> 8;
                break;
            }
            case 3: {
                steps = (data &= 0xF8) >> 3;
            }
        }
        return steps > 16 ? 16 : steps;
    }

    public static boolean isSideSolid(TEBase TE, ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return true;
            }
            case UP: {
                return CollapsibleUtil.isMax(TE);
            }
            case NORTH: {
                return Collapsible.getQuadDepth(TE, 0) + Collapsible.getQuadDepth(TE, 2) == 32;
            }
            case SOUTH: {
                return Collapsible.getQuadDepth(TE, 1) + Collapsible.getQuadDepth(TE, 3) == 32;
            }
            case WEST: {
                return Collapsible.getQuadDepth(TE, 1) + Collapsible.getQuadDepth(TE, 0) == 32;
            }
            case EAST: {
                return Collapsible.getQuadDepth(TE, 2) + Collapsible.getQuadDepth(TE, 3) == 32;
            }
        }
        return true;
    }

    public boolean match(TEBase TE_1, TEBase TE_2) {
        return this.isPositive(TE_1) == this.isPositive(TE_2);
    }

    @Override
    public void setDirection(TEBase TE, ForgeDirection dir) {
        int temp = TE.getData() & 0xFFFFFFF8 | dir.ordinal();
        TE.setData(temp);
    }

    @Override
    public ForgeDirection getDirection(TEBase TE) {
        return ForgeDirection.getOrientation((int)(TE.getData() & 7));
    }

    public boolean isPositive(TEBase TE) {
        return this.getDirection(TE).equals((Object)ForgeDirection.UP);
    }
}

