/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils;

import cofh.api.energy.IEnergyHandler;
import com.bymarcin.zettaindustries.ZettaIndustries;
import net.minecraft.block.Block;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldUtils {
    public static final ForgeDirection[] flatDirections = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST};

    public static TileEntity getTileEntity(int dimensionId, int x, int y, int z) {
        World world = ZettaIndustries.proxy.getWorld(dimensionId);
        if (world == null) {
            return null;
        }
        return world.func_147438_o(x, y, z);
    }

    public static TileEntity getTileEntityServer(int dimensionId, int x, int y, int z) {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimensionId);
        if (world == null) {
            return null;
        }
        return world.func_147438_o(x, y, z);
    }

    public static boolean isClientWorld(World paramWorld) {
        return paramWorld.field_72995_K;
    }

    public static boolean isServerWorld(World paramWorld) {
        return !paramWorld.field_72995_K;
    }

    public static TileEntity getAdjacentTileEntity(World paramWorld, int paramInt1, int paramInt2, int paramInt3, ForgeDirection paramForgeDirection) {
        return paramWorld == null ? null : paramWorld.func_147438_o(paramInt1 + paramForgeDirection.offsetX, paramInt2 + paramForgeDirection.offsetY, paramInt3 + paramForgeDirection.offsetZ);
    }

    public static TileEntity getAdjacentTileEntity(World paramWorld, int paramInt1, int paramInt2, int paramInt3, int paramInt4) {
        return paramWorld == null ? null : WorldUtils.getAdjacentTileEntity(paramWorld, paramInt1, paramInt2, paramInt3, ForgeDirection.values()[paramInt4]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity paramTileEntity, ForgeDirection paramForgeDirection) {
        return paramTileEntity == null ? null : WorldUtils.getAdjacentTileEntity(paramTileEntity.func_145831_w(), paramTileEntity.field_145851_c, paramTileEntity.field_145848_d, paramTileEntity.field_145849_e, paramForgeDirection);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity paramTileEntity, int paramInt) {
        return paramTileEntity == null ? null : WorldUtils.getAdjacentTileEntity(paramTileEntity.func_145831_w(), paramTileEntity.field_145851_c, paramTileEntity.field_145848_d, paramTileEntity.field_145849_e, ForgeDirection.values()[paramInt]);
    }

    public static boolean isEnergyHandlerFromSide(TileEntity paramTileEntity, ForgeDirection paramForgeDirection) {
        return paramTileEntity instanceof IEnergyHandler && ((IEnergyHandler)paramTileEntity).canConnectEnergy(paramForgeDirection);
    }

    public static Block getAdjencetBlock(TileEntity tile, ForgeDirection offset) {
        return tile.func_145831_w().func_147439_a(tile.field_145851_c + offset.offsetX, tile.field_145848_d + offset.offsetY, tile.field_145849_e + offset.offsetZ);
    }
}

