/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;

public class MathUtils {
    public static String addSI(long value, String postunit) {
        int unit = 1000;
        if (value < (long)unit) {
            return value + " " + postunit;
        }
        int exp = (int)(Math.log(value) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.2f %s%s", (double)value / Math.pow(unit, exp), Character.valueOf(pre), postunit);
    }

    public static String encryptPassword(String password) {
        String sha1 = "";
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(password.getBytes("UTF-8"));
            sha1 = MathUtils.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sha1;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }
}

