/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.ocwires.tileentity;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.bymarcin.zettaindustries.ZettaIndustries;
import com.bymarcin.zettaindustries.mods.ocwires.TelecommunicationWireType;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTelecomunicationConnector
extends TileEntity
implements IImmersiveConnectable,
Environment,
SidedEnvironment {
    protected Node node = Network.newNode((Environment)this, (Visibility)Visibility.None).create();
    protected boolean addedToNetwork = false;
    private int facing;
    private boolean needUpdate = false;

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }

    public boolean canConnectCable(WireType wiretype, TargetingInfo target) {
        return TelecommunicationWireType.TELECOMMUNICATION.getUniqueName() == wiretype.getUniqueName();
    }

    public void connectCable(WireType wiretype, TargetingInfo target) {
        this.checkConnections();
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == -1) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void removeCable(ImmersiveNetHandler.Connection con) {
        if (con == null) {
            ZettaIndustries.logger.warn("Try to removed empty connection.");
            return;
        }
        if (con.start.equals((Object)Utils.toCC((Object)((Object)this))) && this.CCToTileEntity(con.end) != null && this.node != null) {
            this.node.disconnect(this.CCToTileEntity(con.end).node());
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void checkConnections() {
        Set a = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)((Object)this)));
        if (a == null) {
            return;
        }
        for (ImmersiveNetHandler.Connection s : a) {
            Node n;
            if (!s.start.equals((Object)Utils.toCC((Object)((Object)this))) || this.CCToTileEntity(s.end) == null || this.node.isNeighborOf(n = this.CCToTileEntity(s.end).node())) continue;
            this.node.connect(n);
        }
    }

    public TileEntityTelecomunicationConnector CCToTileEntity(ChunkCoordinates cc) {
        TileEntity te = this.field_145850_b.func_147438_o(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
        if (te instanceof TileEntityTelecomunicationConnector) {
            return (TileEntityTelecomunicationConnector)te;
        }
        return null;
    }

    public Vec3 getRaytraceOffset(IImmersiveConnectable arg0) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return Vec3.func_72443_a((double)(0.5 + (double)fd.offsetX * 0.0625), (double)(0.5 + (double)fd.offsetY * 0.0625), (double)(0.5 + (double)fd.offsetZ * 0.0625));
    }

    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        double conRadius = 0.03125;
        return Vec3.func_72443_a((double)(0.5 - conRadius * (double)fd.offsetX), (double)(0.5 - conRadius * (double)fd.offsetY), (double)(0.5 - conRadius * (double)fd.offsetZ));
    }

    public WireType getCableLimiter(TargetingInfo arg0) {
        return TelecommunicationWireType.TELECOMMUNICATION;
    }

    public boolean isEnergyOutput() {
        return false;
    }

    public int outputEnergy(int arg0, boolean arg1, int arg2) {
        return 0;
    }

    public boolean canConnect() {
        return true;
    }

    public Node node() {
        return this.node;
    }

    public void onConnect(Node node) {
        if (node == this.node()) {
            this.needUpdate = true;
        }
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message message) {
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.addedToNetwork) {
            this.addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
        if (this.needUpdate) {
            this.checkConnections();
            this.needUpdate = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC((Object)((Object)this)), this.field_145850_b);
        }
        if (this.node != null) {
            this.node.remove();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NBTTagList connectionList = new NBTTagList();
            Set conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC((Object)((Object)this)));
            if (conL != null) {
                for (ImmersiveNetHandler.Connection con : conL) {
                    connectionList.func_74742_a((NBTBase)con.writeToNBT());
                }
            }
            nbttagcompound.func_74782_a("connectionList", (NBTBase)connectionList);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && !Minecraft.func_71410_x().func_71356_B()) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC((Object)((Object)this)), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC((Object)((Object)this)), con);
                    continue;
                }
                IELogger.error((Object)"CLIENT read connection as null");
            }
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.func_145842_c(-1, 0);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("facing")) {
            this.facing = nbt.func_74762_e("facing");
        }
        if (this.node != null && this.node.host() == this) {
            this.node.load(nbt.func_74775_l("oc:node"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("facing", this.facing);
        if (this.node != null && this.node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node.save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    public Node sidedNode(ForgeDirection side) {
        return this.node();
    }

    public boolean canConnect(ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection arg0) {
        return false;
    }
}

