/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IFactoryLaserSource;
import powercrystals.minefactoryreloaded.api.IFactoryLaserTarget;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryPowered;
import powercrystals.minefactoryreloaded.gui.container.ContainerFactoryPowered;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;
import powercrystals.minefactoryreloaded.tile.machine.TileEntityLaserDrill;

public class TileEntityLaserDrillPrecharger
extends TileEntityFactoryPowered
implements IFactoryLaserSource {
    private int stripTick = 0;

    public TileEntityLaserDrillPrecharger() {
        super(Machine.LaserDrillPrecharger);
        this.setCanRotate(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiFactoryPowered(this.getContainer(inventoryPlayer), this);
    }

    @Override
    public ContainerFactoryPowered getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerFactoryPowered(this, inventoryPlayer);
    }

    public int func_70302_i_() {
        return 0;
    }

    @Override
    protected boolean activateMachine() {
        IFactoryLaserTarget iFactoryLaserTarget = this.getDrill();
        if (iFactoryLaserTarget == null) {
            this.setIdleTicks(this.getIdleTicksMax());
        } else {
            int n = this.getActivationEnergy();
            ForgeDirection forgeDirection = this.getDirectionFacing().getOpposite();
            if (iFactoryLaserTarget.canFormBeamWith(forgeDirection)) {
                this.stripBlock(false);
                int n2 = iFactoryLaserTarget.addEnergy(forgeDirection, n, true);
                if (n2 == 0) {
                    iFactoryLaserTarget.addEnergy(forgeDirection, n, false);
                    return true;
                }
                n2 = iFactoryLaserTarget.addEnergy(forgeDirection, n, false);
                this.drainEnergy(n - n2);
                return false;
            }
            this.stripBlock(true);
        }
        return false;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 200;
    }

    public boolean shouldDrawBeam() {
        IFactoryLaserTarget iFactoryLaserTarget = this.getDrill();
        return iFactoryLaserTarget != null && iFactoryLaserTarget.canFormBeamWith(this.getDirectionFacing().getOpposite());
    }

    protected IFactoryLaserTarget getDrill() {
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = this.getDirectionFacing();
        blockPosition.moveForwards(1);
        if (!this.field_145850_b.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            return null;
        }
        if (!TileEntityLaserDrill.canReplaceBlock(this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z), this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z)) {
            return null;
        }
        blockPosition.moveForwards(1);
        TileEntity tileEntity = this.field_145850_b.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
        if (tileEntity instanceof IFactoryLaserTarget) {
            return (IFactoryLaserTarget)tileEntity;
        }
        return null;
    }

    protected void stripBlock(boolean bl) {
        if (this.stripTick > 0) {
            --this.stripTick;
            return;
        }
        this.stripTick = 20;
        BlockPosition blockPosition = new BlockPosition((TileEntity)this);
        blockPosition.orientation = this.getDirectionFacing();
        blockPosition.moveForwards(1);
        if (bl == this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z).equals(MFRThings.fakeLaserBlock)) {
            this.field_145850_b.func_147465_d(blockPosition.x, blockPosition.y, blockPosition.z, MFRThings.fakeLaserBlock, blockPosition.orientation.getOpposite().ordinal() + 1, 3);
        } else if (bl) {
            this.field_145850_b.func_147464_a(blockPosition.x, blockPosition.y, blockPosition.z, MFRThings.fakeLaserBlock, 1);
        }
    }

    @Override
    public boolean canFormBeamFrom(ForgeDirection forgeDirection) {
        if (forgeDirection != this.getDirectionFacing().getOpposite()) {
            return false;
        }
        IFactoryLaserTarget iFactoryLaserTarget = this.getDrill();
        return iFactoryLaserTarget != null && iFactoryLaserTarget.canFormBeamWith(this.getDirectionFacing().getOpposite());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

