/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.FertilizerType;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUpgradeable;
import powercrystals.minefactoryreloaded.gui.container.ContainerUpgradeable;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFertilizer
extends TileEntityFactoryPowered {
    private Random _rand = new Random();

    public TileEntityFertilizer() {
        super(Machine.Fertilizer);
        TileEntityFertilizer.createHAM(this, 1);
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUpgradeable(this.getContainer(inventoryPlayer), (TileEntityFactoryPowered)this);
    }

    @Override
    public ContainerUpgradeable getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUpgradeable(this, inventoryPlayer);
    }

    @Override
    public boolean activateMachine() {
        Block block;
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        if (!this.field_145850_b.func_72899_e(blockPosition.x, blockPosition.y, blockPosition.z)) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        Map<Block, IFactoryFertilizable> map = MFRRegistry.getFertilizables();
        if (!map.containsKey(block = this.field_145850_b.func_147439_a(blockPosition.x, blockPosition.y, blockPosition.z))) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        IFactoryFertilizable iFactoryFertilizable = map.get(block);
        Map<Item, IFactoryFertilizer> map2 = MFRRegistry.getFertilizers();
        int n = this.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            IFactoryFertilizer iFactoryFertilizer;
            FertilizerType fertilizerType;
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !map2.containsKey(itemStack.func_77973_b()) || (fertilizerType = (iFactoryFertilizer = map2.get(itemStack.func_77973_b())).getFertilizerType(itemStack)) == FertilizerType.None || !iFactoryFertilizable.canFertilize(this.field_145850_b, blockPosition.x, blockPosition.y, blockPosition.z, fertilizerType) || !iFactoryFertilizable.fertilize(this.field_145850_b, this._rand, blockPosition.x, blockPosition.y, blockPosition.z, fertilizerType)) continue;
            iFactoryFertilizer.consume(itemStack);
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_145850_b.func_72889_a(null, 2005, blockPosition.x, blockPosition.y, blockPosition.z, this._rand.nextInt(10) + 5);
            }
            if (itemStack.field_77994_a <= 0) {
                this.func_70299_a(i, null);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    public int func_70302_i_() {
        return 10;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 20;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public int getUpgradeSlot() {
        return 9;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null) {
            if (n < 9) {
                return MFRRegistry.getFertilizers().containsKey(itemStack.func_77973_b());
            }
            if (n == 9) {
                return this.isUsableAugment(itemStack);
            }
        }
        return false;
    }
}

