/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block.transport;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.position.IRotateableTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetInputNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;
import powercrystals.minefactoryreloaded.block.BlockFactory;
import powercrystals.minefactoryreloaded.core.IEntityCollidable;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.gui.MFRCreativeTab;
import powercrystals.minefactoryreloaded.item.ItemPlasticBoots;
import powercrystals.minefactoryreloaded.setup.MFRThings;
import powercrystals.minefactoryreloaded.tile.transport.TileEntityConveyor;

public class BlockConveyor
extends BlockFactory
implements IRedNetInputNode,
ITileEntityProvider {
    public static final String[] _names = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black", "default"};
    private static final int[] colors = new int[17];
    @SideOnly(value=Side.CLIENT)
    private IIcon base;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayFast;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayStopped;
    private int renderPass;

    public BlockConveyor() {
        super(Material.field_151594_q);
        this.func_149711_c(0.5f);
        this.func_149663_c("mfr.conveyor");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.1f, 0.01f, 0.1f);
        this.func_149647_a(MFRCreativeTab.tab);
    }

    @Override
    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return false;
    }

    public boolean canRenderInPass(int n) {
        this.renderPass = n;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.base = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a() + ".base");
        this.overlay = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a() + ".overlay");
        this.overlayFast = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a() + ".overlay.fast");
        this.overlayStopped = iIconRegister.func_94245_a("minefactoryreloaded:" + this.func_149739_a() + ".overlay.stopped");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition movingObjectPosition, EffectRenderer effectRenderer) {
        int n = movingObjectPosition.field_72311_b;
        int n2 = movingObjectPosition.field_72312_c;
        int n3 = movingObjectPosition.field_72309_d;
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            float f = 0.1f;
            Random random = new Random();
            double d = (double)n + random.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
            double d2 = (double)n2 + random.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
            double d3 = (double)n3 + random.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
            switch (movingObjectPosition.field_72310_e) {
                case 0: {
                    d2 = (double)n2 + this.func_149665_z() - (double)f;
                    break;
                }
                case 1: {
                    d2 = (double)n2 + this.func_149669_A() + (double)f;
                    break;
                }
                case 2: {
                    d3 = (double)n3 + this.func_149706_B() - (double)f;
                    break;
                }
                case 3: {
                    d3 = (double)n3 + this.func_149693_C() + (double)f;
                    break;
                }
                case 4: {
                    d = (double)n + this.func_149704_x() - (double)f;
                    break;
                }
                case 5: {
                    d = (double)n + this.func_149753_y() + (double)f;
                }
            }
            effectRenderer.func_78873_a(new EntityDiggingFX(world, d, d2, d3, 0.0, 0.0, 0.0, (Block)this, this.func_149643_k(world, n, n2, n3)).func_70596_a(n, n2, n3).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int n, int n2, int n3, int n4, EffectRenderer effectRenderer) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = 4 - Minecraft.func_71410_x().field_71474_y.field_74362_aa * 2;
            n5 &= ~n5 >> 31;
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n5; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        double d = (double)n + ((double)i + 0.5) / (double)n5;
                        double d2 = (double)n2 + ((double)j + 0.5) / (double)n5;
                        double d3 = (double)n3 + ((double)k + 0.5) / (double)n5;
                        effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, d, d2, d3, d - (double)n - 0.5, d2 - (double)n2 - 0.5, d3 - (double)n3 - 0.5, (Block)this, this.func_149643_k(world, n, n2, n3)).func_70596_a(n, n2, n3));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean recolourBlock(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            int n5 = ((TileEntityConveyor)tileEntity).getDyeColor();
            ((TileEntityConveyor)tileEntity).setDyeColor(n4);
            return n5 != ((TileEntityConveyor)tileEntity).getDyeColor();
        }
        return false;
    }

    public int func_149741_i(int n) {
        if (this.renderPass == 0) {
            return colors[n];
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        TileEntity tileEntity = iBlockAccess.func_147438_o(n, n2, n3);
        int n4 = 16;
        if (tileEntity instanceof TileEntityConveyor && (n4 = ((TileEntityConveyor)tileEntity).getDyeColor()) == -1) {
            n4 = 16;
        }
        return this.func_149741_i(n4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int n, int n2) {
        if (this.renderPass == 1) {
            switch (n2) {
                case 0: {
                    return this.overlayStopped;
                }
                case 1: {
                    return this.overlay;
                }
                case 2: {
                    return this.overlayFast;
                }
            }
        }
        return this.base;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        TileEntity tileEntity;
        int n5 = 0;
        if (this.renderPass == 1 && (tileEntity = iBlockAccess.func_147438_o(n, n2, n3)) instanceof TileEntityConveyor) {
            TileEntityConveyor tileEntityConveyor = (TileEntityConveyor)tileEntity;
            int n6 = n5 = tileEntityConveyor.isFast() ? 2 : 1;
            if (!tileEntityConveyor.getConveyorActive()) {
                n5 = 0;
            }
        }
        return this.func_149691_a(n4, n5);
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
        if (entityLivingBase == null) {
            return;
        }
        int n4 = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(n, n2, n3, n4 + 1 & 3, 2);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).setDyeColor(itemStack.func_77960_j() == 16 ? -1 : itemStack.func_77960_j());
        }
    }

    @Override
    public void func_149726_b(World world, int n, int n2, int n3) {
        this.func_149695_a(world, n, n2, n3, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_149670_a(World world, int n, int n2, int n3, Entity entity) {
        block38: {
            double d;
            ForgeDirection forgeDirection;
            boolean bl;
            boolean bl2;
            double d2;
            double d3;
            double d4;
            block37: {
                int n4;
                block36: {
                    ItemStack itemStack;
                    boolean bl3;
                    boolean bl4 = bl3 = entity instanceof EntityItem || entity instanceof EntityXPOrb;
                    if (!bl3) {
                        for (Class<? extends Entity> clazz : MFRRegistry.getConveyerBlacklist()) {
                            if (!clazz.isInstance(entity)) continue;
                            return;
                        }
                    }
                    if (!(bl3 || entity instanceof EntityLivingBase || entity instanceof EntityTNTPrimed)) {
                        return;
                    }
                    TileEntity tileEntity = world.func_147438_o(n, n2, n3);
                    if (!(tileEntity instanceof TileEntityConveyor) || !((TileEntityConveyor)tileEntity).getConveyorActive()) {
                        return;
                    }
                    if (!world.field_72995_K) {
                        if (entity instanceof EntityItem) {
                            this.specialRoute(world, n, n2, n3, (EntityItem)entity);
                        } else if (entity instanceof EntityPlayer) {
                            return;
                        }
                    }
                    if (entity instanceof EntityLivingBase && (itemStack = ((EntityLivingBase)entity).func_71124_b(1)) != null && itemStack.func_77973_b() instanceof ItemPlasticBoots) {
                        return;
                    }
                    if (entity.getEntityData().func_74763_f("mfr:conveyor") == world.func_82737_E()) {
                        return;
                    }
                    entity.getEntityData().func_74772_a("mfr:conveyor", world.func_82737_E());
                    double d5 = ((TileEntityConveyor)tileEntity).isFast() ? 2.1 : 1.05;
                    d5 *= (double)world.func_147439_a((int)n, (int)(n2 - 1), (int)n3).field_149765_K;
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    int n5 = world.func_72805_g(n, n2, n3);
                    n4 = n5 & 3;
                    bl2 = (n5 & 4) != 0;
                    bl = (n5 & 8) != 0;
                    forgeDirection = null;
                    switch (n4) {
                        case 0: {
                            d4 = 0.1 * d5;
                            forgeDirection = ForgeDirection.EAST;
                            break;
                        }
                        case 1: {
                            d2 = 0.1 * d5;
                            forgeDirection = ForgeDirection.SOUTH;
                            break;
                        }
                        case 2: {
                            d4 = -0.1 * d5;
                            forgeDirection = ForgeDirection.WEST;
                            break;
                        }
                        case 3: {
                            d2 = -0.1 * d5;
                            forgeDirection = ForgeDirection.NORTH;
                            break;
                        }
                    }
                    if (bl2) {
                        d3 = 0.152 * d5;
                        if (d4 != 0.0) {
                            d = Math.abs(entity.field_70121_D.field_72336_d - entity.field_70121_D.field_72340_a) / 2.0;
                            d = MathHelper.func_151237_a((double)(Math.abs(entity.field_70165_t - (double)n) + Math.abs(d4) - d), (double)0.0, (double)1.0);
                        } else {
                            d = Math.abs(entity.field_70121_D.field_72334_f - entity.field_70121_D.field_72339_c) / 2.0;
                            d = MathHelper.func_151237_a((double)(entity.field_70161_v - (double)n3 + Math.abs(d2) + d), (double)0.0, (double)1.0);
                        }
                        if ((forgeDirection.ordinal() & 1) == 0) {
                            d = 1.0 - d;
                        }
                        this.setYPos(entity, (double)n2 + d + 0.1);
                    } else if (entity.field_70163_u - (double)n2 - (double)entity.field_70129_M < 0.1 && entity.field_70163_u - (double)n2 - (double)entity.field_70129_M > -0.1) {
                        this.setYPos(entity, (double)n2 + 0.1);
                    } else if (bl) {
                        d3 = -0.11 * d5;
                        entity.field_70143_R = (float)((double)entity.field_70143_R - 0.13);
                    }
                    if (bl2 | bl) {
                        entity.field_70122_E = false;
                        entity.field_70181_x = d3 / 2.0;
                    }
                    this.repositionEntity(world, n, n2, n3, entity, d4, d3, d2);
                    if (!bl2) break block36;
                    if (!(entity.field_70163_u - (double)entity.field_70129_M < (double)(n2 + 1))) break block37;
                    break block38;
                }
                switch (n4) {
                    case 0: {
                        if (!(entity.field_70165_t < (double)(n + 1))) break;
                        break block38;
                    }
                    case 2: {
                        if (!(entity.field_70165_t > (double)n)) break;
                        break block38;
                    }
                    case 1: {
                        if (!(entity.field_70161_v < (double)(n3 + 1))) break;
                        break block38;
                    }
                    case 3: {
                        if (entity.field_70161_v > (double)n3) break block38;
                    }
                }
            }
            if (!BlockHelper.getAdjacentBlock((World)world, (int)n, (int)n2, (int)n3, (ForgeDirection)forgeDirection).equals(MFRThings.conveyorBlock)) {
                if (bl2 | bl) {
                    d = 0.25;
                    if (!BlockHelper.getAdjacentBlock((World)world, (int)n, (int)(n2 + (bl2 ? 1 : -1)), (int)n3, (ForgeDirection)forgeDirection).equals(MFRThings.conveyorBlock)) {
                        d = 1.0;
                    }
                    entity.field_70181_x = d3 * d;
                    entity.field_70159_w = d4 * d;
                    entity.field_70179_y = d2 * d;
                } else {
                    entity.field_70159_w = d4;
                    entity.field_70179_y = d2;
                }
            }
        }
        entity.field_70143_R = (float)((double)entity.field_70143_R * 0.9);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).field_145804_b = 40;
        }
    }

    private void setYPos(Entity entity, double d) {
        double d2 = entity.field_70142_S;
        double d3 = entity.field_70137_T;
        double d4 = entity.field_70136_U;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70634_a(entity.field_70165_t, d, entity.field_70161_v);
        } else {
            entity.func_70012_b(entity.field_70165_t, d, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        }
        entity.field_70142_S = d2;
        entity.field_70137_T = d3;
        entity.field_70136_U = d4;
    }

    private void repositionEntity(World world, int n, int n2, int n3, Entity entity, double d, double d2, double d3) {
        if (!world.func_147461_a(entity.field_70121_D).isEmpty() || !world.func_147461_a(entity.field_70121_D.func_72325_c(d, d2, d3)).isEmpty()) {
            return;
        }
        if (BlockConveyor.isZero(entity.field_70159_w) && BlockConveyor.isZero(entity.field_70179_y)) {
            if (d == 0.0) {
                d += ((double)n - (entity.field_70165_t - 0.5)) / 20.0;
            }
            if (d3 == 0.0) {
                d3 += ((double)n3 - (entity.field_70161_v - 0.5)) / 20.0;
            }
        } else {
            d += entity.field_70159_w;
            d3 += entity.field_70179_y;
        }
        double d4 = d2 != 0.0 ? entity.field_70167_r : entity.field_70163_u;
        double d5 = entity.field_70142_S;
        double d6 = entity.field_70137_T;
        double d7 = entity.field_70136_U;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70634_a(entity.field_70169_q + d, d4 - (double)entity.field_70129_M + d2, entity.field_70166_s + d3);
        } else {
            entity.func_70012_b(entity.field_70169_q + d, d4 - (double)entity.field_70129_M + d2, entity.field_70166_s + d3, entity.field_70177_z, entity.field_70125_A);
        }
        entity.field_70142_S = d5;
        entity.field_70137_T = d6;
        entity.field_70136_U = d7;
        if (d2 != 0.0) {
            entity.field_70181_x = 0.0;
        }
        entity.field_70159_w *= 0.5;
        entity.field_70179_y *= 0.5;
    }

    public static boolean isZero(double d) {
        return -0.025 <= d & d <= 0.025;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        float f = 0.125f;
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72330_a((double)((float)n + f), (double)n2, (double)((float)n3 + f), (double)((float)(n + 1) - f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - f));
        }
        return AxisAlignedBB.func_72330_a((double)((float)n + f), (double)n2, (double)((float)n3 + f), (double)((float)(n + 1) - f), (double)((float)n2 + 0.01f), (double)((float)(n3 + 1) - f));
    }

    public AxisAlignedBB func_149633_g(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        if ((n4 & 0xC) == 0) {
            return AxisAlignedBB.func_72330_a((double)((float)n + 0.05f), (double)n2, (double)((float)n3 + 0.05f), (double)((float)(n + 1) - 0.05f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.05f));
        }
        return AxisAlignedBB.func_72330_a((double)((float)n + 0.1f), (double)n2, (double)((float)n3 + 0.1f), (double)((float)(n + 1) - 0.1f), (double)((float)n2 + 0.1f), (double)((float)(n3 + 1) - 0.1f));
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149721_r() {
        return false;
    }

    @Override
    public MovingObjectPosition func_149731_a(World world, int n, int n2, int n3, Vec3 vec3, Vec3 vec32) {
        this.func_149719_a((IBlockAccess)world, n, n2, n3);
        return super.func_149731_a(world, n, n2, n3, vec3, vec32);
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.func_72805_g(n, n2, n3);
        if (n4 >= 4 && n4 <= 11) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return MineFactoryReloadedCore.renderIdConveyor;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149742_c(World world, int n, int n2, int n3) {
        return this.func_149718_j(world, n, n2, n3);
    }

    public boolean func_149718_j(World world, int n, int n2, int n3) {
        return world.isSideSolid(n, n2 - 1, n3, ForgeDirection.UP);
    }

    @Override
    protected boolean activated(World world, int n, int n2, int n3, EntityPlayer entityPlayer, int n4) {
        TileEntity tileEntity;
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (MFRUtil.isHoldingUsableTool(entityPlayer, n, n2, n3)) {
            TileEntity tileEntity2 = world.func_147438_o(n, n2, n3);
            if (tileEntity2 instanceof IRotateableTile) {
                ((IRotateableTile)tileEntity2).rotate(ForgeDirection.getOrientation((int)n4));
            }
            MFRUtil.usedWrench(entityPlayer, n, n2, n3);
            return true;
        }
        if (itemStack != null && itemStack.func_77973_b().equals(Items.field_151114_aO) && (tileEntity = world.func_147438_o(n, n2, n3)) instanceof TileEntityConveyor && !((TileEntityConveyor)tileEntity).isFast()) {
            ((TileEntityConveyor)tileEntity).setFast(true);
            world.func_147471_g(n, n2, n3);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_149695_a(World world, int n, int n2, int n3, Block block) {
        if (!this.func_149718_j(world, n, n2, n3)) {
            this.func_149697_b(world, n, n2, n3, world.func_72805_g(n, n2, n3), 0);
            world.func_147468_f(n, n2, n3);
            return;
        }
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).updateConveyorActive();
        }
    }

    public TileEntity func_149915_a(World world, int n) {
        return new TileEntityConveyor();
    }

    public int func_149643_k(World world, int n, int n2, int n3) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        int n4 = 16;
        if (tileEntity instanceof TileEntityConveyor && (n4 = ((TileEntityConveyor)tileEntity).getDyeColor()) == -1) {
            n4 = 16;
        }
        return n4;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int n, int n2, int n3, int n4, int n5) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        if (world.func_147439_a(n, n2, n3).equals(this)) {
            arrayList.add(new ItemStack((Block)this, 1, this.func_149643_k(world, n, n2, n3)));
            if (((TileEntityConveyor)world.func_147438_o(n, n2, n3)).isFast()) {
                arrayList.add(new ItemStack(Items.field_151114_aO, 1));
            }
        }
        return arrayList;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean canSilkHarvest(World world, EntityPlayer entityPlayer, int n, int n2, int n3, int n4) {
        return false;
    }

    @Override
    public boolean func_149744_f() {
        return false;
    }

    @Override
    public RedNetConnectionType getConnectionType(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return RedNetConnectionType.PlateSingle;
    }

    @Override
    public void onInputsChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int[] nArray) {
    }

    @Override
    public void onInputChanged(World world, int n, int n2, int n3, ForgeDirection forgeDirection, int n4) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileEntityConveyor) {
            ((TileEntityConveyor)tileEntity).onRedNetChanged(n4);
        }
    }

    private void specialRoute(World world, int n, int n2, int n3, EntityItem entityItem) {
        TileEntity tileEntity = world.func_147438_o(n, n2 - 1, n3);
        if (tileEntity == null || entityItem.field_70128_L) {
            return;
        }
        if (tileEntity instanceof IEntityCollidable) {
            ((IEntityCollidable)tileEntity).onEntityCollided((Entity)entityItem);
        } else if (tileEntity instanceof TileEntityHopper && !((TileEntityHopper)tileEntity).func_145888_j()) {
            ItemStack itemStack = entityItem.func_92059_d().func_77946_l();
            itemStack.field_77994_a = 1;
            if ((itemStack = TileEntityHopper.func_145889_a((IInventory)((IInventory)tileEntity), (ItemStack)itemStack, (int)ForgeDirection.UP.ordinal())) == null) {
                --entityItem.func_92059_d().field_77994_a;
                ((TileEntityHopper)tileEntity).func_145896_c(8);
            }
        }
        if (entityItem.func_92059_d().field_77994_a <= 0) {
            entityItem.func_70106_y();
        }
    }

    static {
        int n = 16;
        while (n-- > 0) {
            BlockConveyor.colors[n] = MFRUtil.COLORS[n];
        }
        BlockConveyor.colors[16] = 16164908;
    }
}

