/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.lookingglass.network.packet;

import com.xcompwiz.lookingglass.api.event.ClientWorldInfoEvent;
import com.xcompwiz.lookingglass.client.proxyworld.WorldView;
import com.xcompwiz.lookingglass.network.LookingGlassPacketManager;
import com.xcompwiz.lookingglass.network.packet.PacketHandlerBase;
import com.xcompwiz.lookingglass.network.packet.PacketWorldInfo;
import com.xcompwiz.lookingglass.proxyworld.ChunkFinder;
import com.xcompwiz.lookingglass.proxyworld.ChunkFinderManager;
import com.xcompwiz.lookingglass.proxyworld.ModConfigs;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

public class PacketCreateView
extends PacketHandlerBase {
    @SideOnly(value=Side.CLIENT)
    public static FMLProxyPacket createPacket(WorldView worldview) {
        ByteBuf data = PacketHandlerBase.createDataBuffer(new Object(){}.getClass().getEnclosingClass());
        int x = 0;
        int y = -1;
        int z = 0;
        if (worldview.coords != null) {
            x = worldview.coords.field_71574_a >> 4;
            y = worldview.coords.field_71572_b >> 4;
            z = worldview.coords.field_71573_c >> 4;
        }
        data.writeInt(worldview.getWorldObj().field_73011_w.field_76574_g);
        data.writeInt(x);
        data.writeInt(y);
        data.writeInt(z);
        data.writeByte(Math.min(ModConfigs.renderDistance, Minecraft.func_71410_x().field_71474_y.field_151451_c));
        return PacketCreateView.buildPacket(data);
    }

    @Override
    public void handle(ByteBuf data, EntityPlayer player) {
        int z;
        int y;
        int x;
        if (ModConfigs.disabled) {
            return;
        }
        int dim = data.readInt();
        int xPos = data.readInt();
        int yPos = data.readInt();
        int zPos = data.readInt();
        byte renderDistance = data.readByte();
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            return;
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
        if (world == null) {
            return;
        }
        if (yPos < 0) {
            ChunkCoordinates c = world.func_72861_E();
            x = c.field_71574_a >> 4;
            y = c.field_71572_b >> 4;
            z = c.field_71573_c >> 4;
        } else {
            x = xPos;
            y = yPos;
            z = zPos;
        }
        if (renderDistance > ModConfigs.renderDistance) {
            renderDistance = ModConfigs.renderDistance;
        }
        ChunkFinderManager.instance.addFinder(new ChunkFinder(new ChunkCoordinates(x, y, z), dim, world.func_72863_F(), player, renderDistance));
        MinecraftForge.EVENT_BUS.post((Event)new ClientWorldInfoEvent(dim, (EntityPlayerMP)player));
        LookingGlassPacketManager.bus.sendTo(PacketWorldInfo.createPacket(dim), (EntityPlayerMP)player);
    }
}

