/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSmart;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;

public class JurassiCraftAITargetIfHasAgeAndNonTamed
extends EntityAITarget {
    private final Class targetClass;
    private final int targetChance;
    private final Sorter theNearestAttackableTargetSorter;
    private final IEntitySelector targetEntitySelector;
    private EntityJurassiCraftSmart creature;
    private EntityLivingBase target;
    private float minimumCreatureAge;
    private float maximumTargetAge;

    public JurassiCraftAITargetIfHasAgeAndNonTamed(EntityJurassiCraftSmart creature, Class targetClass, int chanceToAttack, float minimumCreatureAge) {
        this(creature, targetClass, chanceToAttack, minimumCreatureAge, 1.0f);
    }

    public JurassiCraftAITargetIfHasAgeAndNonTamed(EntityJurassiCraftSmart creature, Class targetClass, int chanceToAttack, float minimumCreatureAge, float maximumTargetAge) {
        super((EntityCreature)creature, true, false);
        this.creature = creature;
        this.minimumCreatureAge = minimumCreatureAge;
        this.maximumTargetAge = maximumTargetAge;
        this.targetClass = targetClass;
        this.targetChance = chanceToAttack;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity creature) {
                return !(creature instanceof EntityLivingBase) ? false : JurassiCraftAITargetIfHasAgeAndNonTamed.this.func_75296_a((EntityLivingBase)creature, false);
            }
        };
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        Random random = this.field_75299_d.func_70681_au();
        boolean isTamed = this.creature.isTamed();
        boolean isAttacking = this.creature.isAttacking();
        boolean olderThanMinAge = this.creature.isCreatureOlderThan(this.minimumCreatureAge);
        if (this.targetChance > 0) {
            if (random.nextInt(this.targetChance) != 0 || isTamed || isAttacking || !olderThanMinAge) {
                return false;
            }
            double searchDistance = this.func_111175_f();
            List nearby = this.field_75299_d.field_70170_p.func_82733_a(this.targetClass, this.field_75299_d.field_70121_D.func_72314_b(searchDistance, 5.0, searchDistance), this.targetEntitySelector);
            Collections.sort(nearby, this.theNearestAttackableTargetSorter);
            if (nearby.isEmpty()) {
                return false;
            }
            this.target = (EntityLivingBase)nearby.get(0);
            if (this.target instanceof EntityJurassiCraftSmart) {
                return ((EntityJurassiCraftSmart)this.target).isCreatureOlderThan(this.maximumTargetAge) ? this.maximumTargetAge >= 1.0f : true;
            }
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        if (this.creature.isSitting()) {
            this.creature.setSitting(false, null);
        }
        if (this.creature.isSleeping()) {
            this.creature.setSleeping(false);
        }
        if (this.creature.isBreeding()) {
            this.creature.setBreeding(false);
        }
        if (this.creature.isSocializing()) {
            this.creature.setSocializing(false);
        }
        if (this.creature.isStalking()) {
            this.creature.setStalking(false);
        }
        if (this.creature.func_70113_ah()) {
            this.creature.func_70019_c(false);
        }
        if (this.creature.isDrinking()) {
            this.creature.setDrinking(false);
        }
        this.creature.setAttacking(true);
        this.field_75299_d.func_70624_b(this.target);
        super.func_75249_e();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.creature.setAttacking(false);
    }

    public static class Sorter
    implements Comparator {
        private final Entity entity;

        public Sorter(Entity entity) {
            this.entity = entity;
        }

        public int compare(Entity entity1, Entity entity2) {
            double distance2;
            double distance1 = this.entity.func_70068_e(entity1);
            return distance1 < (distance2 = this.entity.func_70068_e(entity2)) ? -1 : (distance1 > distance2 ? 1 : 0);
        }

        public int compare(Object obj1, Object obj2) {
            return this.compare((Entity)obj1, (Entity)obj2);
        }
    }
}

