/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.render.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.common.data.CreatureContainer;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityVelociraptor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderJurassicraftCreature
extends RenderLiving {
    private Map<String, ResourceLocation> textureCache = Maps.newHashMap();
    private CreatureContainer creature;
    private float resizableShadow;
    private String category;
    private String creatureName;

    public RenderJurassicraftCreature(CreatureContainer creature, String creatureName, String category, float shadow) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        super((ModelBase)Class.forName("net.ilexiconn.jurassicraft.client.model.entity.Model" + creatureName).newInstance(), shadow);
        this.setCreature(creature);
        this.setShadow(shadow);
        this.category = category.toLowerCase();
        this.creatureName = creatureName.toLowerCase();
    }

    public float getShadow() {
        return this.resizableShadow;
    }

    private void setShadow(float shadow) {
        this.resizableShadow = shadow;
    }

    public CreatureContainer getCreature() {
        return this.creature;
    }

    private void setCreature(CreatureContainer creature) {
        this.creature = creature;
    }

    public void func_77041_b(EntityLivingBase entity, float side) {
        float scale = ((EntityJurassiCraftCreature)entity).getCreatureScale();
        this.field_76989_e = scale * this.getShadow();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
    }

    public ResourceLocation func_110775_a(Entity entity) {
        String name;
        EntityJurassiCraftCreature dino = (EntityJurassiCraftCreature)entity;
        if (dino instanceof EntityVelociraptor && (name = dino.func_94057_bL()) != null) {
            if (name.equalsIgnoreCase("Blue")) {
                return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/blue.png");
            }
            if (name.equalsIgnoreCase("Charlie")) {
                return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/charlie.png");
            }
            if (name.equalsIgnoreCase("Delta")) {
                return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/delta.png");
            }
            if (name.equalsIgnoreCase("Echo")) {
                return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/echo.png");
            }
            if (name.equalsIgnoreCase("Velocibrine") || name.equalsIgnoreCase("Herobrine")) {
                return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/" + "velocibrine" + dino.getCreatureGenderString() + "1.png");
            }
        }
        return this.getTexture(JurassiCraft.getModId() + "textures/entity/" + this.category + "/" + this.creatureName + "/" + this.creatureName + dino.getCreatureGenderString() + "1.png");
    }

    public ResourceLocation getTexture(String texture) {
        if (this.textureCache.containsKey(texture)) {
            return this.textureCache.get(texture);
        }
        ResourceLocation value = new ResourceLocation(texture);
        this.textureCache.put(texture, value);
        return value;
    }
}

