/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.jurassicraft.client.render.RenderInfo;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    private static ResourceLocation glintTexture = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static Map<Fluid, int[]> renderCache = new HashMap<Fluid, int[]>();
    private static RenderInfo liquidBlock = new RenderInfo();
    private static RenderBlocks renderBlocks = new RenderBlocks();

    private static void renderBlock(RenderInfo info, IBlockAccess blockAccess, int x, int y, int z, boolean doLight) {
        float lightBottom = 0.5f;
        float lightTop = 1.0f;
        float lightEastWest = 0.8f;
        float lightNorthSouth = 0.6f;
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean realDoLight = doLight;
        if (blockAccess == null) {
            realDoLight = false;
        }
        tessellator.func_78382_b();
        float light = 0.0f;
        if (realDoLight) {
            if (info.light < 0.0f) {
                light = info.baseBlock.func_149677_c(blockAccess, x, y, z);
                light += (1.0f - light) * 0.4f;
            } else {
                light = info.light;
            }
            int brightness = info.brightness < 0 ? info.baseBlock.func_149677_c(blockAccess, x, y, z) : info.brightness;
            tessellator.func_78380_c(brightness);
            tessellator.func_78386_a(lightBottom * light, lightBottom * light, lightBottom * light);
        } else if (info.brightness >= 0) {
            tessellator.func_78380_c(info.brightness);
        }
        renderBlocks.func_147782_a(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.renderSide[0]) {
            renderBlocks.func_147768_a(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(0));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightTop * light, lightTop * light, lightTop * light);
        }
        if (info.renderSide[1]) {
            renderBlocks.func_147806_b(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(1));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[2]) {
            renderBlocks.func_147761_c(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(2));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightEastWest * light, lightEastWest * light, lightEastWest * light);
        }
        if (info.renderSide[3]) {
            renderBlocks.func_147734_d(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(3));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[4]) {
            renderBlocks.func_147798_e(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(4));
        }
        if (realDoLight) {
            tessellator.func_78386_a(lightNorthSouth * light, lightNorthSouth * light, lightNorthSouth * light);
        }
        if (info.renderSide[5]) {
            renderBlocks.func_147764_f(info.baseBlock, (double)x, (double)y, (double)z, info.getBlockTextureFromSide(5));
        }
        tessellator.func_78381_a();
    }

    public static int[] getFluidDisplayLists(World world) {
        return RenderHelper.getFluidDisplayLists(world, FluidRegistry.WATER, Blocks.field_150355_j);
    }

    public static int[] getFluidDisplayLists(World world, Fluid fluid, Block blockFluid) {
        if (fluid == null) {
            return null;
        }
        int[] displayLists = renderCache.get(fluid);
        if (displayLists != null) {
            return displayLists;
        }
        displayLists = new int[8];
        RenderHelper.liquidBlock.baseBlock = blockFluid;
        RenderHelper.liquidBlock.texture = fluid.getStillIcon();
        renderCache.put(fluid, displayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < displayLists.length; ++s) {
            displayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayLists[s], (int)4864);
            RenderHelper.liquidBlock.minX = 0.01f;
            RenderHelper.liquidBlock.minY = 0.0;
            RenderHelper.liquidBlock.minZ = 0.01f;
            RenderHelper.liquidBlock.maxX = 0.99f;
            RenderHelper.liquidBlock.maxY = (float)s / (float)displayLists.length;
            RenderHelper.liquidBlock.maxZ = 0.99f;
            RenderHelper.renderBlock(liquidBlock, (IBlockAccess)world, 0, 0, 0, false);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return displayLists;
    }

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (textureManager == null) {
            return;
        }
        Item item = stack.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int passes = item.getRenderPasses(stack.func_77960_j());
        for (int pass = 0; pass < passes; ++pass) {
            textureManager.func_110577_a(stack.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
            IIcon icon = item.getIcon(stack, pass);
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            RenderHelper.setColorFromInt(item.func_82790_a(stack, pass));
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        if (stack.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            textureManager.func_110577_a(glintTexture);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }
}

