/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.guicomponents;

import com.brandon3055.brandonscore.client.gui.guicomponents.ComponentScrollingBase;
import com.brandon3055.brandonscore.client.gui.guicomponents.GUIScrollingBase;
import com.brandon3055.brandonscore.client.utills.GuiHelper;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.client.gui.componentguis.ManualPage;
import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.client.utill.CustomResourceLocation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.opengl.GL11;

public class ComponentManualPage
extends ComponentScrollingBase {
    public ManualPage page;
    public List<ContentComponent> contentList = new ArrayList<ContentComponent>();
    private int pageLength = 0;
    ItemStack stack = null;
    private int slideTick = 0;
    public int scrollOffset = 0;
    public int scrollLimit = 0;

    public ComponentManualPage(int x, int y, GUIScrollingBase gui, ManualPage page) {
        super(x, y, gui);
        this.page = page;
        this.pageLength = 25;
        this.stack = Utills.getStackFromName((String)page.name, (int)page.meta);
        ContentComponent title = new ContentComponent("title." + page.getLocalizedName(), this.pageLength, this);
        this.pageLength += title.getHeight();
        this.contentList.add(title);
        for (String s : page.content) {
            ContentComponent c = new ContentComponent(s, this.pageLength, this);
            this.pageLength += c.getHeight();
            this.contentList.add(c);
        }
        this.pageLength += 25;
        this.scrollLimit = this.pageLength - 325;
    }

    public void handleScrollInput(int direction) {
        this.scrollOffset += direction * (InfoHelper.isShiftKeyDown() ? 30 : 10);
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (this.scrollOffset > this.pageLength - this.getHeight()) {
            this.scrollOffset = this.pageLength - this.getHeight();
        }
        if (this.pageLength <= this.getHeight()) {
            this.scrollOffset = 0;
        }
    }

    public int getWidth() {
        return this.gui.getXSize();
    }

    public int getHeight() {
        return this.gui.getYSize();
    }

    public void renderBackground(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        for (ContentComponent c : this.contentList) {
            c.render(mouseX, mouseY);
        }
    }

    public void renderFinal(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void renderForground(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void updateScreen() {
        super.updateScreen();
        if (!InfoHelper.isShiftKeyDown()) {
            ++this.slideTick;
        }
    }

    private static class ContentComponent {
        private String content;
        private int type;
        public int yPos;
        private ComponentManualPage page;
        private String[] textLines;
        private List<IRecipe> recipes = new ArrayList<IRecipe>();
        private List<ItemStack> smeltingRecipes = new ArrayList<ItemStack>();
        private ItemStack result;
        private boolean isTitle = false;
        private boolean slide = false;
        private List<String> slides = new ArrayList<String>();

        public ContentComponent(String content, int y, ComponentManualPage page) {
            this.content = content;
            this.yPos = y;
            this.page = page;
            this.init();
        }

        public void init() {
            String s;
            boolean bl = this.isTitle = this.content != null && this.content.contains("title.");
            this.type = this.content.contains(".png") ? 1 : (this.content.contains("[c]") ? 2 : 0);
            boolean bl2 = this.slide = this.type == 1 && this.content.contains("[>]");
            if (this.slide) {
                s = this.content;
                while (s.contains("[>]")) {
                    this.slides.add(s.substring(0, s.indexOf("[>]")));
                    s = s.substring(s.indexOf("[>]") + 3);
                }
                this.slides.add(s);
            }
            if (this.type == 0) {
                List l = this.page.fontRendererObj.func_78271_c(this.content, 220);
                ArrayList<String> sl = new ArrayList<String>();
                Iterator i$ = l.iterator();
                while (i$.hasNext()) {
                    String st;
                    String s2 = st = (String)i$.next();
                    while (s2.contains("\\n")) {
                        String s22 = s2.substring(0, s2.indexOf("\\n"));
                        s2 = s2.substring(s2.indexOf("\\n") + 2);
                        sl.add(s22);
                    }
                    sl.add(s2);
                }
                this.textLines = sl.toArray(new String[sl.size()]);
            } else if (this.type == 2) {
                ItemStack stack;
                s = this.content.substring(this.content.indexOf("[c]") + 3);
                String name = s.substring(0, s.lastIndexOf(":"));
                this.result = stack = Utills.getStackFromName((String)name, (int)Integer.parseInt(s.substring(s.lastIndexOf(":") + 1)));
                if (stack != null) {
                    for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                        Object[] input;
                        ItemStack result;
                        if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(stack) || (input = this.getRecipeInput(recipe)) == null) continue;
                        this.recipes.add(recipe);
                    }
                    for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                        if (!(entry.getKey() instanceof ItemStack) || !((ItemStack)entry.getValue()).func_77969_a(stack)) continue;
                        this.smeltingRecipes.add((ItemStack)entry.getKey());
                    }
                }
            } else {
                this.textLines = null;
            }
        }

        public int getHeight() {
            if (this.type == 1 && (ResourceHandler.downloadedImages.containsKey(FilenameUtils.getName((String)this.content)) || this.slide && ResourceHandler.downloadedImages.containsKey(FilenameUtils.getName((String)this.content)))) {
                CustomResourceLocation texture = this.slide ? ResourceHandler.downloadedImages.get(FilenameUtils.getName((String)this.content)) : ResourceHandler.downloadedImages.get(FilenameUtils.getName((String)this.content));
                return (int)((double)texture.getHeight() / (double)texture.getWidth() * 220.0) + 5;
            }
            if (this.type == 2) {
                return (this.recipes.size() + this.smeltingRecipes.size()) * 57;
            }
            return (this.textLines != null ? this.textLines.length * 10 : 10) + 5 + (this.isTitle && (this.page.page.name.contains("tile.") || this.page.page.name.contains("item.")) ? 18 : 0);
        }

        public void render(int mouseX, int mouseY) {
            if (this.type == 1) {
                this.renderImage();
                return;
            }
            if (this.type == 2) {
                this.renderCrafting(mouseX, mouseY);
                return;
            }
            if (this.isTitle) {
                int y = this.yPos - this.page.scrollOffset;
                if (y > 310 || y < 5) {
                    return;
                }
                this.page.func_73732_a(this.page.fontRendererObj, this.content.substring(this.content.indexOf("title.") + 6), 128, y, 65535);
                if ((this.page.page.name.contains("tile.") || this.page.page.name.contains("item.")) && this.page.stack != null) {
                    ResourceHandler.bindResource("textures/gui/Widgets.png");
                    GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
                    this.page.func_73729_b(119, y + 11, 138, 0, 18, 18);
                    this.page.drawItemStack(this.page.stack, 120, 12 + y, "");
                }
            } else if (this.textLines != null) {
                for (int i = 0; i < this.textLines.length; ++i) {
                    int y = this.yPos + i * 10 - this.page.scrollOffset;
                    if (y > 310 || y < 5) continue;
                    this.page.fontRendererObj.func_78276_b(this.textLines[i], 20, y, 0);
                }
            }
        }

        private void renderImage() {
            CustomResourceLocation image = null;
            if (this.slide) {
                int index = this.page.slideTick / 20 % this.slides.size();
                image = this.slides.size() > index ? ResourceHandler.downloadedImages.get(FilenameUtils.getName((String)this.slides.get(index))) : null;
            } else if (ResourceHandler.downloadedImages.containsKey(FilenameUtils.getName((String)this.content))) {
                image = ResourceHandler.downloadedImages.get(FilenameUtils.getName((String)this.content));
            }
            if (image != null) {
                image.bind();
                Tessellator tess = Tessellator.field_78398_a;
                double ySize = (double)image.getHeight() / (double)image.getWidth() * 220.0;
                double topS = 0.0;
                if (this.yPos - this.page.scrollOffset < 0) {
                    topS = this.yPos - 5 - this.page.scrollOffset;
                }
                double btmS = 0.0;
                if ((double)(this.yPos - this.page.scrollOffset) + ySize > 310.0) {
                    btmS = (double)(this.yPos - 5 - this.page.scrollOffset - 310) + ySize;
                }
                double xmin = 17.5;
                double xmax = 237.5;
                double ymin = (double)(this.yPos - this.page.scrollOffset) - topS;
                double ymax = (double)this.yPos + ySize - (double)this.page.scrollOffset - btmS;
                double vmin = Math.max(0.0, topS / -ySize);
                double vmax = Math.min(1.0, 1.0 - btmS / ySize);
                tess.func_78382_b();
                tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
                tess.func_78374_a(xmin, ymin, 0.0, 0.0, vmin);
                tess.func_78374_a(xmin, ymax, 0.0, 0.0, vmax);
                tess.func_78374_a(xmax, ymax, 0.0, 1.0, vmax);
                tess.func_78374_a(xmax, ymin, 0.0, 1.0, vmin);
                tess.func_78381_a();
                if (this.slide && (int)ymax - 10 < 305 && (int)ymax - 10 > 0 && !InfoHelper.isShiftKeyDown()) {
                    this.page.fontRendererObj.func_78276_b(this.page.ttl("info.de.shiftToPause.txt"), 20, (int)ymax - 8, 0xFF0000);
                }
            }
        }

        private void renderCrafting(int mouseX, int mouseY) {
            ItemStack stack;
            int y;
            int x;
            int i;
            int yDown;
            int index;
            if (this.result == null) {
                return;
            }
            ResourceHandler.bindResource("textures/gui/Widgets.png");
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int posX = 70;
            int posY = this.yPos - this.page.scrollOffset;
            for (IRecipe iRecipe : this.recipes) {
                index = this.recipes.indexOf(iRecipe);
                yDown = index * 57;
                for (i = 0; i < 9; ++i) {
                    x = i % 3 * 18;
                    y = i / 3 * 18;
                    if (y + yDown + posY < 0 || y + yDown + posY > 305) continue;
                    this.page.func_73729_b(x + posX, y + yDown + posY, 138, 0, 18, 18);
                    stack = (ItemStack)(this.getRecipeInput(iRecipe).length > i && this.getRecipeInput(iRecipe)[i] instanceof ItemStack ? this.getRecipeInput(iRecipe)[i] : (this.getRecipeInput(iRecipe).length > i && this.getRecipeInput(iRecipe)[i] instanceof ArrayList ? ((ArrayList)this.getRecipeInput(iRecipe)[i]).get(0) : null));
                    if (stack == null) continue;
                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                        stack.func_77964_b(0);
                    }
                    this.page.drawItemStack(stack, 1 + x + posX, 1 + y + yDown + posY, "");
                }
                if (14 + yDown + posY > 0 && 14 + yDown + posY < 300) {
                    this.page.func_73729_b(90 + posX, 14 + yDown + posY, 156, 0, 26, 26);
                }
                if (19 + yDown + posY <= 0 || 19 + yDown + posY >= 305) continue;
                this.page.func_73729_b(61 + posX, 19 + yDown + posY, 204, 0, 22, 15);
                if (iRecipe.func_77571_b() == null) continue;
                this.page.drawItemStack(iRecipe.func_77571_b(), 95 + posX, 19 + yDown + posY, "");
            }
            for (IRecipe iRecipe : this.recipes) {
                index = this.recipes.indexOf(iRecipe);
                yDown = index * 57;
                if (19 + yDown + posY > 0 && 19 + yDown + posY < 305 && GuiHelper.isInRect((int)(95 + posX), (int)(19 + yDown + posY), (int)18, (int)18, (int)mouseX, (int)mouseY)) {
                    GL11.glPushAttrib((int)1048575);
                    if (iRecipe.func_77571_b() != null) {
                        this.page.renderToolTip(iRecipe.func_77571_b(), mouseX, mouseY);
                    }
                    ResourceHandler.bindResource("textures/gui/Widgets.png");
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopAttrib();
                }
                for (i = 0; i < 9; ++i) {
                    x = i % 3 * 18;
                    y = i / 3 * 18;
                    if (y + yDown + posY < 0 || y + yDown + posY > 305 || (stack = (ItemStack)(this.getRecipeInput(iRecipe).length > i && this.getRecipeInput(iRecipe)[i] instanceof ItemStack ? this.getRecipeInput(iRecipe)[i] : (this.getRecipeInput(iRecipe).length > i && this.getRecipeInput(iRecipe)[i] instanceof ArrayList ? ((ArrayList)this.getRecipeInput(iRecipe)[i]).get(0) : null))) == null || !GuiHelper.isInRect((int)(1 + x + posX), (int)(1 + y + yDown + posY), (int)18, (int)18, (int)mouseX, (int)mouseY)) continue;
                    GL11.glPushAttrib((int)1048575);
                    this.page.renderToolTip(stack, mouseX, mouseY);
                    ResourceHandler.bindResource("textures/gui/Widgets.png");
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopAttrib();
                }
            }
            for (ItemStack itemStack : this.smeltingRecipes) {
                index = this.smeltingRecipes.indexOf(itemStack);
                yDown = (this.recipes.size() + index) * 57;
                if (yDown + posY > 0 && yDown + posY < 305) {
                    this.page.func_73729_b(posX + 18, yDown + posY, 138, 0, 18, 18);
                    this.page.drawItemStack(itemStack, posX + 19, yDown + posY + 1, "");
                }
                if (21 + yDown + posY > 0 && 21 + yDown + posY < 305) {
                    this.page.func_73729_b(posX + 18, yDown + posY + 21, 238, 0, 18, 15);
                }
                if (36 + yDown + posY > 0 && 36 + yDown + posY < 305) {
                    this.page.func_73729_b(posX + 18, yDown + posY + 36, 238, 15, 18, 33);
                }
                if (14 + yDown + posY > 0 && 14 + yDown + posY < 300) {
                    this.page.func_73729_b(90 + posX, 14 + yDown + posY, 156, 0, 26, 26);
                    this.page.drawItemStack(this.result, 95 + posX, 19 + yDown + posY, "");
                }
                if (19 + yDown + posY > 0 && 19 + yDown + posY < 305) {
                    this.page.func_73729_b(50 + posX, 19 + yDown + posY, 204, 0, 22, 15);
                }
                if (yDown + posY > 0 && yDown + posY < 305 && GuiHelper.isInRect((int)(posX + 19), (int)(yDown + posY + 1), (int)18, (int)18, (int)mouseX, (int)mouseY)) {
                    GL11.glPushAttrib((int)1048575);
                    this.page.renderToolTip(itemStack, mouseX, mouseY);
                    ResourceHandler.bindResource("textures/gui/Widgets.png");
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopAttrib();
                }
                if (14 + yDown + posY <= 0 || 14 + yDown + posY >= 305 || !GuiHelper.isInRect((int)(95 + posX), (int)(19 + yDown + posY), (int)18, (int)18, (int)mouseX, (int)mouseY)) continue;
                GL11.glPushAttrib((int)1048575);
                this.page.renderToolTip(this.result, mouseX, mouseY);
                ResourceHandler.bindResource("textures/gui/Widgets.png");
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopAttrib();
            }
        }

        private Object[] getRecipeInput(IRecipe recipe) {
            if (recipe instanceof ShapelessOreRecipe) {
                return ((ShapelessOreRecipe)recipe).getInput().toArray();
            }
            if (recipe instanceof ShapedOreRecipe) {
                return this.getShapedOreRecipe((ShapedOreRecipe)recipe);
            }
            if (recipe instanceof ShapedRecipes) {
                return ((ShapedRecipes)recipe).field_77574_d;
            }
            if (recipe instanceof ShapelessRecipes) {
                return ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[0]);
            }
            return null;
        }

        private Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
            try {
                Field field = ShapedOreRecipe.class.getDeclaredField("width");
                if (field != null) {
                    field.setAccessible(true);
                    int width = field.getInt(recipe);
                    Object[] input = recipe.getInput();
                    Object[] grid = new Object[9];
                    int i = 0;
                    int offset = 0;
                    for (int y = 0; y < 3; ++y) {
                        int x = 0;
                        while (x < 3) {
                            if (x < width && offset < input.length) {
                                grid[i] = input[offset];
                                ++offset;
                            } else {
                                grid[i] = null;
                            }
                            ++x;
                            ++i;
                        }
                    }
                    return grid;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

