/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.motion;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import me.planetguy.lib.util.Lang;
import me.planetguy.lib.util.Reflection;
import me.planetguy.remaininmotion.carriage.BlockCarriage;
import me.planetguy.remaininmotion.core.RIMBlocks;
import me.planetguy.remaininmotion.core.RiMConfiguration;
import me.planetguy.remaininmotion.core.interop.EventPool;
import me.planetguy.remaininmotion.core.interop.ModInteraction;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.drive.TileEntityCarriageTranslocator;
import me.planetguy.remaininmotion.motion.BlacklistManager;
import me.planetguy.remaininmotion.motion.CarriageMatchers;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriageObstructionException;
import me.planetguy.remaininmotion.util.position.BlockPosition;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import me.planetguy.remaininmotion.util.position.BlockRecordSet;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CarriagePackage {
    public boolean blacklistByRotation = false;
    public BlockPosition RenderCacheKey;
    public TileEntityCarriageTranslocator Translocator;
    public WorldServer world;
    public final BlockRecord driveRecord;
    public boolean DriveIsAnchored;
    public BlockRecord AnchorRecord;
    public Directions MotionDirection;
    public int axis;
    public static volatile CarriagePackage activePackage;
    public BlockRecordSet Body = new BlockRecordSet();
    public BlockRecordSet spectersToDestroy = new BlockRecordSet();
    public static int MaxBlockCount;
    public int MinX = Integer.MAX_VALUE;
    public int MinY = Integer.MAX_VALUE;
    public int MinZ = Integer.MAX_VALUE;
    public int MaxX = Integer.MIN_VALUE;
    public int MaxY = Integer.MIN_VALUE;
    public int MaxZ = Integer.MIN_VALUE;
    public BlockRecordSet NewPositions = new BlockRecordSet();
    public BlockRecordSet Carriages = new BlockRecordSet();
    public BlockRecordSet Cargo = new BlockRecordSet();
    private double Mass = 0.0;
    public static boolean ObstructedByLiquids;
    public static boolean ObstructedByFragileBlocks;
    public BlockRecordSet PotentialObstructions = new BlockRecordSet();
    public NBTTagList PendingBlockUpdates = new NBTTagList();
    TreeMap<BlockRecord, Double> CargoBurdenFactors = new TreeMap();

    public CarriagePackage(TileEntityCarriageDrive Drive, TileEntity Anchor, Directions MotionDirection) {
        this.world = (WorldServer)Drive.func_145831_w();
        this.driveRecord = new BlockRecord(Drive.field_145851_c, Drive.field_145848_d, Drive.field_145849_e);
        this.driveRecord.Identify((World)this.world);
        this.DriveIsAnchored = Drive.Anchored();
        this.AnchorRecord = new BlockRecord(Anchor.field_145851_c, Anchor.field_145848_d, Anchor.field_145849_e);
        this.AnchorRecord.Identify((World)this.world);
        this.MotionDirection = MotionDirection;
    }

    public boolean MatchesCarriageType(BlockRecord record) {
        if (record.entity == null) {
            record.entity = new TileEntity();
        }
        return CarriageMatchers.matches(record.block, record.Meta, record.entity, this);
    }

    public boolean AddBlock(BlockRecord record) throws CarriageMotionException {
        boolean couldAddBlock = this.AddBlock_impl(record);
        if (!couldAddBlock) {
            this.AddPotentialObstruction(record);
        }
        return couldAddBlock;
    }

    private boolean AddBlock_impl(BlockRecord record) throws CarriageMotionException {
        String result;
        if (this.MotionDirection == Directions.PosY && record.Y >= 254) {
            throw new CarriageObstructionException("cannot move carriage above height limit", record.X, record.Y, record.Z);
        }
        if (this.MotionDirection == Directions.NegY && record.Y <= 0) {
            throw new CarriageObstructionException("cannot move carriage below depth limit", record.X, record.Y, record.Z);
        }
        if (BlacklistManager.lookup(BlacklistManager.blacklistHard, record)) {
            throw new CarriageObstructionException(Lang.translate((String)"JAKJ_RedstoneInMotion.bannedBlock"), record.X, record.Y, record.Z);
        }
        if (this.blacklistByRotation && BlacklistManager.lookup(BlacklistManager.blacklistRotation, record)) {
            throw new CarriageObstructionException(Lang.translate((String)"JAKJ_RedstoneInMotion.bannedTurningBlock"), record.X, record.Y, record.Z);
        }
        if (BlacklistManager.lookup(BlacklistManager.blacklistSoft, record)) {
            return false;
        }
        if (record.X == this.driveRecord.X && record.Y == this.driveRecord.Y && record.Z == this.driveRecord.Z && record.entity instanceof TileEntityCarriageTranslocator) {
            return false;
        }
        if (record.entity != null) {
            record.entityRecord = new NBTTagCompound();
            record.entity.func_145841_b(record.entityRecord);
        }
        if ((result = EventPool.postBlockSelectForMoveEvent(this, this.blacklistByRotation, record, this.axis)) != null && result.equals("<skipme>")) {
            return false;
        }
        if (result != null) {
            throw new CarriageMotionException("motion killed by block at " + record + ": " + result);
        }
        this.Body.add(record);
        if (MaxBlockCount > 0 && this.Body.size() > MaxBlockCount) {
            throw new CarriageMotionException("carriage exceeds maximum size of " + MaxBlockCount + " blocks");
        }
        if (this.MotionDirection == null) {
            BlockRecord record1 = new BlockRecord(record.X - this.driveRecord.X, record.Y - this.driveRecord.Y, record.Z - this.driveRecord.Z);
            record1.block = record.block;
            this.NewPositions.add(record1);
        } else {
            this.NewPositions.add(record.NextInDirection(this.MotionDirection));
        }
        this.MinX = Math.min(this.MinX, record.X);
        this.MinY = Math.min(this.MinY, record.Y);
        this.MinZ = Math.min(this.MinZ, record.Z);
        this.MaxX = Math.max(this.MaxX, record.X);
        this.MaxY = Math.max(this.MaxY, record.Y);
        this.MaxZ = Math.max(this.MaxZ, record.Z);
        if (RiMConfiguration.HardMode.HardmodeActive) {
            if (record.block == RIMBlocks.Carriage) {
                this.Carriages.add(record);
                this.setMass(this.getMass() + BlockCarriage.Types.values()[record.Meta].Burden);
            } else {
                this.Cargo.add(record);
                Block b = record.block;
                double massFactor = Math.min(b.func_149712_f(record.World, record.X, record.Y, record.Z), b.func_149638_a(null));
                this.setMass(this.getMass() + Math.max(1.0, Math.log(massFactor)));
            }
        }
        return true;
    }

    public void FailBecauseObstructed(BlockRecord Record, String Type2) throws CarriageMotionException {
        throw new CarriageObstructionException("Carriage motion obstructed by " + Type2, Record.X, Record.Y, Record.Z);
    }

    public void AssertNotObstruction(BlockRecord record) throws CarriageMotionException {
        if (this.Body.contains(record)) {
            return;
        }
        int i = TileEntityCarriageDrive.isBlockReplaceable((World)this.world, record);
        switch (i) {
            case 0: {
                return;
            }
            case 1: {
                this.FailBecauseObstructed(record, "fragile");
                break;
            }
            case 2: {
                this.FailBecauseObstructed(record, "liquid");
                break;
            }
            case 3: {
                this.FailBecauseObstructed(record, "block");
            }
        }
    }

    public void AddPotentialObstruction(BlockRecord Record) {
        this.PotentialObstructions.add(Record);
    }

    public void StorePendingBlockUpdateRecord(NextTickListEntry PendingBlockUpdate, long WorldTime) {
        NBTTagCompound PendingBlockUpdateRecord = new NBTTagCompound();
        PendingBlockUpdateRecord.func_74768_a("X", PendingBlockUpdate.field_77183_a);
        PendingBlockUpdateRecord.func_74768_a("Y", PendingBlockUpdate.field_77181_b);
        PendingBlockUpdateRecord.func_74768_a("Z", PendingBlockUpdate.field_77182_c);
        PendingBlockUpdateRecord.func_74768_a("Id", Block.func_149682_b((Block)PendingBlockUpdate.func_151351_a()));
        PendingBlockUpdateRecord.func_74768_a("Delay", (int)(PendingBlockUpdate.field_77180_e - WorldTime));
        PendingBlockUpdateRecord.func_74768_a("Priority", PendingBlockUpdate.field_82754_f);
        this.PendingBlockUpdates.func_74742_a((NBTBase)PendingBlockUpdateRecord);
    }

    public void ApplyCargoBurdenFactor(BlockRecord Position, double Factor) {
        Double CurrFactor = this.CargoBurdenFactors.get(Position);
        if (CurrFactor == null) {
            this.CargoBurdenFactors.put(Position, Factor);
        } else {
            this.CargoBurdenFactors.put(Position, CurrFactor * Factor);
        }
    }

    public void Finalize() throws CarriageMotionException {
        this.updateHardModeData();
        for (BlockRecord PotentialObstruction : this.PotentialObstructions) {
            this.AssertNotObstruction(PotentialObstruction);
        }
        long WorldTime = this.world.func_72912_H().func_82573_f();
        try {
            TreeSet ticks = (TreeSet)Reflection.get(WorldServer.class, (Object)this.world, (String)"pendingTickListEntriesTreeSet");
            Set ticksHash = (Set)Reflection.get(WorldServer.class, (Object)this.world, (String)"pendingTickListEntriesHashSet");
            Iterator PendingBlockUpdateSetIterator = ticks.iterator();
            while (PendingBlockUpdateSetIterator.hasNext()) {
                NextTickListEntry PendingBlockUpdate = (NextTickListEntry)PendingBlockUpdateSetIterator.next();
                if (!this.Body.contains(new BlockRecord(PendingBlockUpdate.field_77183_a, PendingBlockUpdate.field_77181_b, PendingBlockUpdate.field_77182_c))) continue;
                PendingBlockUpdateSetIterator.remove();
                ticks.remove(PendingBlockUpdate);
                ticksHash.remove(PendingBlockUpdate);
                this.StorePendingBlockUpdateRecord(PendingBlockUpdate, WorldTime);
            }
        }
        catch (Throwable VanillaThrowable) {
            if (VanillaThrowable instanceof ThreadDeath) {
                throw (ThreadDeath)VanillaThrowable;
            }
            try {
                Set PendingBlockUpdateSet = (Set)ModInteraction.PendingBlockUpdateSetField.get(this.world);
                while (true) {
                    NextTickListEntry PendingBlockUpdate = null;
                    for (Object Target2 : PendingBlockUpdateSet) {
                        NextTickListEntry TargetPendingBlockUpdate = (NextTickListEntry)Target2;
                        if (!this.Body.contains(new BlockRecord(TargetPendingBlockUpdate.field_77183_a, TargetPendingBlockUpdate.field_77181_b, TargetPendingBlockUpdate.field_77182_c))) continue;
                        PendingBlockUpdate = TargetPendingBlockUpdate;
                        break;
                    }
                    if (PendingBlockUpdate != null) {
                        this.StorePendingBlockUpdateRecord(PendingBlockUpdate, WorldTime);
                        ModInteraction.RemovePendingBlockUpdate.invoke((Object)this.world, PendingBlockUpdate);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable McpcThrowable) {
                McpcThrowable.printStackTrace();
                VanillaThrowable.printStackTrace();
            }
        }
        this.PotentialObstructions = null;
        this.Carriages = null;
        this.Cargo = null;
        this.CargoBurdenFactors = null;
    }

    public void updateHardModeData() throws CarriageMotionException {
        if (RiMConfiguration.HardMode.HardmodeActive) {
            for (BlockRecord CargoRecord : this.Cargo) {
                Double BurdenFactor = this.CargoBurdenFactors.get(CargoRecord);
                double Burden = this.GetBaseBurden(CargoRecord);
                if (BurdenFactor == null) {
                    this.setMass(this.getMass() + Burden);
                    continue;
                }
                this.setMass(this.getMass() + Burden * BurdenFactor);
            }
        }
        TileEntityCarriageDrive drive = (TileEntityCarriageDrive)this.driveRecord.entity;
        drive.removeUsedEnergy(this);
        NBTTagCompound tag = new NBTTagCompound();
        drive.func_145841_b(tag);
        this.driveRecord.entityRecord = tag;
    }

    public double GetBaseBurden(BlockRecord Record) {
        return 1.0;
    }

    public double getMass() {
        return this.Mass;
    }

    public void setMass(double mass) {
        this.Mass = mass;
    }
}

