/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive.gui;

import java.util.List;
import me.planetguy.lib.prefab.ContainerPrefab;
import me.planetguy.lib.prefab.GuiPrefab;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.drive.gui.Buttons;
import me.planetguy.remaininmotion.drive.gui.ContainerDrive;
import me.planetguy.remaininmotion.drive.gui.ITooltipDrawer;
import me.planetguy.remaininmotion.drive.gui.IconButton;
import me.planetguy.remaininmotion.network.PacketCarriageUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiDriveCommon
extends GuiPrefab
implements ITooltipDrawer {
    public boolean initialized = false;
    private static ResourceLocation rl = new ResourceLocation("JAKJ_RedstoneInMotion:textures/gui/container/disposer.png");
    public TileEntityCarriageDrive cde;
    protected int buttonID = 0;
    protected long state = 0L;
    private List<String> deferredTooltipLines;

    public GuiDriveCommon(InventoryPlayer playerInv, TileEntity te) {
        super((ContainerPrefab)new ContainerDrive(playerInv, te), rl);
        this.cde = (TileEntityCarriageDrive)te;
        this.stateFromTE(this.cde);
    }

    public void stateFromTE(TileEntityCarriageDrive te) {
        for (int i = 0; i < 6; ++i) {
            if (!te.SideClosed[i]) continue;
            this.state |= (long)(1 << i + 3 + Buttons.DOWN.ordinal());
        }
        if (te.Continuous) {
            this.state |= (long)(1 << 3 + Buttons.CONTINUOUS_MODE.ordinal());
        }
        if (te.zeroContinuousCooldown) {
            this.state |= (long)(1 << 3 + Buttons.ZERO_COOLDOWN.ordinal());
        }
        if (te.requiresScrewdriverToOpen) {
            this.state |= (long)(1 << 3 + Buttons.SCREWDRIVER_MODE.ordinal());
        }
        if (!te.isAnchored) {
            this.state |= (long)(1 << 3 + Buttons.MOVE_WITH_CARRIAGE.ordinal());
        }
    }

    public void stateToButtons() {
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof IconButton)) continue;
            ((IconButton)b).setIsActive((this.state & (long)(1 << ((IconButton)b).icon.ordinal() + 3)) != 0L);
        }
    }

    public void stateFromButtons() {
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof IconButton)) continue;
            this.state = ((IconButton)b).writeInto(this.state);
        }
    }

    public String getLabel() {
        return "Carriage Drive";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButton(-81, -60, Buttons.SCREWDRIVER_MODE);
        this.createButton(-59, -60, Buttons.CONTINUOUS_MODE);
        this.createButton(-14, -60, Buttons.ZERO_COOLDOWN);
        this.createAnchorButton();
        this.createButton(-59, -31, Buttons.NORTH);
        this.createButton(-37, -31, Buttons.DOWN);
        this.createButton(-81, -9, Buttons.WEST);
        this.createButton(-59, -9, Buttons.UP);
        this.createButton(-37, -9, Buttons.EAST);
        this.createButton(-59, 13, Buttons.SOUTH);
        this.stateToButtons();
    }

    protected void createAnchorButton() {
        this.createButton(-37, -60, Buttons.MOVE_WITH_CARRIAGE);
    }

    protected void createButton(int x, int y, Buttons button) {
        this.field_146292_n.add(new IconButton(this.buttonID++, this.field_146294_l / 2 + x, this.field_146295_m / 2 + y, (this.state & 1L << button.ordinal()) != 0L, button, this));
    }

    public boolean handle(IconButton b) {
        b.isActive = !b.isActive;
        return true;
    }

    protected void func_146284_a(GuiButton b) {
        if (b instanceof IconButton) {
            this.handle((IconButton)b);
        }
    }

    @Override
    public void drawTooltip(List<String> icon, int mouseX, int mouseY) {
        this.deferredTooltipLines = icon;
    }

    public void func_146281_b() {
        if (this.initialized) {
            this.stateFromButtons();
            PacketCarriageUpdate.send(this.cde, this.state);
        }
    }

    protected void func_146979_b(int param1, int param2) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        fr.func_78276_b(this.getLabel(), 8, 6, 0x404040);
        this.initialized = true;
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.deferredTooltipLines = null;
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        if (this.deferredTooltipLines != null) {
            this.drawHoveringText(this.deferredTooltipLines, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
    }
}

