/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.drive;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import me.planetguy.lib.util.Lang;
import me.planetguy.remaininmotion.drive.TileEntityCarriageDrive;
import me.planetguy.remaininmotion.motion.CarriageMotionException;
import me.planetguy.remaininmotion.motion.CarriageObstructionException;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.MultiTypeCarriageUtil;
import me.planetguy.remaininmotion.util.general.ECIExpose;
import me.planetguy.remaininmotion.util.transformations.Directions;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityCarriageController
extends TileEntityCarriageDrive
implements IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public boolean lastMoveWorked;
    public boolean Simulating;
    public Directions MotionDirection;
    public CarriageMotionException Error;
    public boolean Obstructed;
    public int ObstructionX;
    public int ObstructionY;
    public int ObstructionZ;
    private volatile boolean finishedMoving = false;
    public boolean Anchored;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_145845_h() {
        TileEntityCarriageController tileEntityCarriageController = this;
        synchronized (tileEntityCarriageController) {
            block9: {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (this.CooldownRemaining > 0) {
                    --this.CooldownRemaining;
                    this.MarkServerRecordDirty();
                    return;
                }
                if (this.Stale) {
                    this.HandleNeighbourBlockChange();
                }
                if (this.MotionDirection == null) {
                    return;
                }
                this.lastMoveWorked = true;
                try {
                    this.Move();
                }
                catch (CarriageMotionException Error2) {
                    this.lastMoveWorked = false;
                    this.Error = Error2;
                    if (!(Error2 instanceof CarriageObstructionException)) break block9;
                    this.Obstructed = true;
                    this.ObstructionX = ((CarriageObstructionException)Error2).X;
                    this.ObstructionY = ((CarriageObstructionException)Error2).Y;
                    this.ObstructionZ = ((CarriageObstructionException)Error2).Z;
                }
            }
            this.MotionDirection = null;
            this.notify();
        }
    }

    @Override
    public boolean Anchored() {
        return this.Anchored;
    }

    public void AssertArgumentCount(Object[] Arguments2, int ArgumentCount) throws Exception {
        if (Arguments2.length < ArgumentCount) {
            throw new Exception("too few arguments");
        }
        if (Arguments2.length > ArgumentCount) {
            throw new Exception("too many arguments");
        }
    }

    public boolean ParseBooleanArgument(Object Argument, String Label) throws Exception {
        try {
            return (Boolean)Argument;
        }
        catch (Throwable Throwable2) {
            throw new Exception("invalid " + Label + " flag");
        }
    }

    public Directions ParseDirectionArgument(Object Argument) throws Exception {
        if (Argument instanceof Double) {
            try {
                return Directions.values()[(int)Math.round((Double)Argument)];
            }
            catch (Throwable Throwable2) {
                throw new Exception("direction index out of range");
            }
        }
        try {
            String Direction = (String)Argument;
            if (Direction.equalsIgnoreCase("down") || Direction.equalsIgnoreCase("negy")) {
                return Directions.NegY;
            }
            if (Direction.equalsIgnoreCase("up") || Direction.equalsIgnoreCase("posy")) {
                return Directions.PosY;
            }
            if (Direction.equalsIgnoreCase("north") || Direction.equalsIgnoreCase("negz")) {
                return Directions.NegZ;
            }
            if (Direction.equalsIgnoreCase("south") || Direction.equalsIgnoreCase("posz")) {
                return Directions.PosZ;
            }
            if (Direction.equalsIgnoreCase("west") || Direction.equalsIgnoreCase("negx")) {
                return Directions.NegX;
            }
            if (Direction.equalsIgnoreCase("east") || Direction.equalsIgnoreCase("posx")) {
                return Directions.PosX;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new Exception("invalid direction " + Argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetupMotion(Directions MotionDirection, boolean Simulating, boolean Anchored) {
        TileEntityCarriageController tileEntityCarriageController = this;
        synchronized (tileEntityCarriageController) {
            this.MotionDirection = MotionDirection;
            this.Simulating = Simulating;
            this.Anchored = Anchored;
            this.lastMoveWorked = false;
            this.notify();
        }
    }

    @ECIExpose
    public Object[] move(Object[] Arguments2) throws Exception {
        this.AssertArgumentCount(Arguments2, 3);
        this.SetupMotion(this.ParseDirectionArgument(Arguments2[0]), this.ParseBooleanArgument(Arguments2[1], "simulation"), this.ParseBooleanArgument(Arguments2[2], "anchoring"));
        this.Error = null;
        this.Obstructed = false;
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ECIExpose
    public Object[] status(Object[] args) {
        TileEntityCarriageController tileEntityCarriageController = this;
        synchronized (tileEntityCarriageController) {
            if (this.Obstructed) {
                return new Object[]{this.energyStored, this.lastMoveWorked, this.Error.getMessage(), this.ObstructionX, this.ObstructionY, this.ObstructionZ};
            }
            if (this.Error == null) {
                return new Object[]{this.energyStored, this.lastMoveWorked};
            }
            return new Object[]{this.energyStored, this.lastMoveWorked, this.Error.getMessage()};
        }
    }

    @Override
    public void removeUsedEnergy(CarriagePackage _package) throws CarriageMotionException {
        if (!this.Simulating) {
            super.removeUsedEnergy(_package);
        }
    }

    public void Move() throws CarriageMotionException {
        if (this.Active || this.CooldownRemaining > 0) {
            throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.active"));
        }
        if (this.CarriageDirection == null) {
            throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.noValidCarriage"));
        }
        CarriagePackage Package2 = this.PreparePackage(this.MotionDirection);
        if (this.Simulating) {
            return;
        }
        this.InitiateMotion(Package2);
    }

    @Override
    public CarriagePackage GeneratePackage(TileEntity carriage, Directions CarriageDirection, Directions MotionDirection) throws CarriageMotionException {
        CarriagePackage Package2;
        if (this.Anchored) {
            if (MotionDirection == CarriageDirection) {
                throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.noPushWhenAnchored"));
            }
            if (MotionDirection == CarriageDirection.opposite()) {
                throw new CarriageMotionException(Lang.translate((String)"JAKJ_RedstoneInMotion.noPullWhenAnchored"));
            }
            Package2 = new CarriagePackage(this, carriage, MotionDirection);
            MultiTypeCarriageUtil.fillPackage(Package2, carriage);
            if (Package2.Body.contains(Package2.driveRecord)) {
                throw new CarriageMotionException("carriage is attempting to move controller while in anchored mode");
            }
            if (Package2.Body.contains(Package2.driveRecord.NextInDirection(MotionDirection.opposite()))) {
                throw new CarriageMotionException("carriage is obstructed by controller while in anchored mode");
            }
        } else {
            Package2 = new CarriagePackage(this, carriage, MotionDirection);
            Package2.AddBlock(Package2.driveRecord);
            if (MotionDirection != CarriageDirection) {
                Package2.AddPotentialObstruction(Package2.driveRecord.NextInDirection(MotionDirection));
            }
            MultiTypeCarriageUtil.fillPackage(Package2, carriage);
        }
        Package2.Finalize();
        return Package2;
    }

    public String type() {
        return "carriage";
    }

    public Method[] listMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : this.getClass().getMethods()) {
            if (!m.isAnnotationPresent(ECIExpose.class)) continue;
            methods.add(m);
        }
        return methods.toArray(new Method[0]);
    }

    public String[] getMethodNames() {
        Method[] methods = this.listMethods();
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = methods[i].getName();
        }
        return names;
    }

    public String getType() {
        return this.type();
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        try {
            Method m = this.listMethods()[method];
            return (Object[])m.invoke((Object)this, new Object[]{arguments});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LuaException(e.getLocalizedMessage());
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public String getComponentName() {
        return this.type();
    }

    public String[] methods() {
        return this.getMethodNames();
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        for (Method m : this.listMethods()) {
            if (!m.getName().equals(method)) continue;
            return (Object[])m.invoke((Object)this, new Object[]{args.toArray()});
        }
        throw new NoSuchMethodException(method);
    }

    public static enum Commands {
        move,
        anchored_move,
        check_anchored_move,
        unanchored_move,
        check_unanchored_move;

    }
}

