/*
 * Decompiled with CFR 0.152.
 */
package me.planetguy.remaininmotion.core.interop;

import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Field;
import java.util.Set;
import me.planetguy.remaininmotion.api.RiMRegistry;
import me.planetguy.remaininmotion.api.event.BlockPreMoveEvent;
import me.planetguy.remaininmotion.api.event.BlockRotateEvent;
import me.planetguy.remaininmotion.api.event.BlockSelectForMoveEvent;
import me.planetguy.remaininmotion.api.event.BlockSelectForRotateEvent;
import me.planetguy.remaininmotion.api.event.BlocksReplacedEvent;
import me.planetguy.remaininmotion.api.event.CancelableOnBlockAddedEvent;
import me.planetguy.remaininmotion.api.event.IBlockPos;
import me.planetguy.remaininmotion.api.event.MotionFinalizeEvent;
import me.planetguy.remaininmotion.api.event.RotatingTEPreUnpackEvent;
import me.planetguy.remaininmotion.api.event.TEPostPlaceEvent;
import me.planetguy.remaininmotion.api.event.TEPrePlaceEvent;
import me.planetguy.remaininmotion.api.event.TEPreUnpackEvent;
import me.planetguy.remaininmotion.motion.CarriagePackage;
import me.planetguy.remaininmotion.util.position.BlockRecord;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EventPool {
    private static BlockPreMoveEvent theBlockPreMoveEvent = new BlockPreMoveEvent();
    private static BlockSelectForMoveEvent theBlockSelectForMoveEvent = new BlockSelectForMoveEvent();
    private static BlockSelectForRotateEvent theBlockSelectForRotateEvent = new BlockSelectForRotateEvent();
    private static CancelableOnBlockAddedEvent theCancelableOnBlockAddedEvent = new CancelableOnBlockAddedEvent();
    private static MotionFinalizeEvent theMotionFinalizeEvent = new MotionFinalizeEvent();
    private static BlocksReplacedEvent theBlocksReplacedEvent = new BlocksReplacedEvent();
    private static TEPreUnpackEvent theTEPreUnpackEvent = new TEPreUnpackEvent();
    private static TEPrePlaceEvent theTEPrePlaceEvent = new TEPrePlaceEvent();
    private static TEPostPlaceEvent theTEPostPlaceEvent = new TEPostPlaceEvent();
    private static RotatingTEPreUnpackEvent theRotatingTEPreUnpackEvent = new RotatingTEPreUnpackEvent();
    private static BlockRotateEvent theBlockRotateEvent = new BlockRotateEvent();
    private static Field eventPhase;

    public static void postBlockPreMoveEvent(IBlockPos old, IBlockPos blockRecord, Set body) {
        EventPool.theBlockPreMoveEvent.location = old;
        EventPool.theBlockPreMoveEvent.newLoc = blockRecord;
        EventPool.theBlockPreMoveEvent.blocks = body;
        EventPool.postEvent(theBlockPreMoveEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postBlockSelectForMoveEvent(CarriagePackage poster, boolean blacklistByRotation, BlockRecord record, int axis) {
        BlockSelectForMoveEvent e;
        if (blacklistByRotation) {
            e = theBlockSelectForRotateEvent;
            EventPool.theBlockSelectForRotateEvent.axis = axis;
        } else {
            e = theBlockSelectForMoveEvent;
        }
        e.location = record;
        Class<CarriagePackage> clazz = CarriagePackage.class;
        synchronized (CarriagePackage.class) {
            CarriagePackage.activePackage = poster;
            EventPool.postEvent(e);
            CarriagePackage.activePackage = null;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (e.isExcluded()) {
                return "<skipme>";
            }
            if (e.isCanceled() || e.getCancelMessag() != null) {
                return e.getCancelMessag() == null ? "unspecified" : e.getCancelMessag();
            }
            return null;
        }
    }

    public static boolean postCancelableOnBlockAddedEvent(World worldObj, int x, int y, int z) {
        EventPool.theCancelableOnBlockAddedEvent.worldObj = worldObj;
        EventPool.theCancelableOnBlockAddedEvent.xCoord = x;
        EventPool.theCancelableOnBlockAddedEvent.yCoord = y;
        EventPool.theCancelableOnBlockAddedEvent.zCoord = z;
        EventPool.postEvent(theCancelableOnBlockAddedEvent);
        return theCancelableOnBlockAddedEvent.isCanceled();
    }

    public static void postMotionFinalizeEvent(BlockRecord record) {
        EventPool.theMotionFinalizeEvent.location = record;
        EventPool.postEvent(theMotionFinalizeEvent);
    }

    public static void postBlocksReplacedEvent(TileEntity te) {
        EventPool.theBlocksReplacedEvent.unpackingEntity = te;
        EventPool.postEvent(theBlocksReplacedEvent);
    }

    public static void postTEPreUnpackEvent(TileEntity unpacker, BlockRecord record) {
        EventPool.theTEPreUnpackEvent.location = record;
        EventPool.theTEPreUnpackEvent.spectre = unpacker;
        EventPool.postEvent(theTEPreUnpackEvent);
    }

    public static void postTEPrePlaceEvent(TileEntity te, BlockRecord record) {
        EventPool.theTEPrePlaceEvent.location = record;
        EventPool.theTEPrePlaceEvent.spectre = te;
        EventPool.postEvent(theTEPrePlaceEvent);
    }

    public static void postTEPostPlaceEvent(TileEntity te, BlockRecord record) {
        EventPool.theTEPostPlaceEvent.location = record;
        EventPool.theTEPostPlaceEvent.spectre = te;
        EventPool.postEvent(theTEPostPlaceEvent);
    }

    public static void postRotatingTEPreUnpackEvent(TileEntity te, BlockRecord record, ForgeDirection dir) {
        EventPool.theRotatingTEPreUnpackEvent.axis = dir;
        EventPool.theRotatingTEPreUnpackEvent.location = record;
        EventPool.theRotatingTEPreUnpackEvent.spectre = te;
        EventPool.postEvent(theRotatingTEPreUnpackEvent);
    }

    public static void postBlockRotateEvent(BlockRecord record, ForgeDirection forgeDirection) {
        EventPool.theBlockRotateEvent.axis = forgeDirection;
        EventPool.theBlockRotateEvent.location = record;
        EventPool.postEvent(theBlockRotateEvent);
    }

    static void postEvent(Event e) {
        try {
            eventPhase.set(e, null);
        }
        catch (IllegalArgumentException e1) {
            throw new RuntimeException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new RuntimeException(e1);
        }
        RiMRegistry.blockMoveBus.post(e);
    }

    static {
        try {
            eventPhase = Event.class.getDeclaredField("phase");
            eventPhase.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

