/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.lwjgl.opengl.GL11;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.codechicken.lib.vec.Vector3;

public class ItemFlyteCharm
extends Item
implements IWarpingGear {
    boolean isFlying = false;
    static final int burstCooldown = 40;
    static final AspectList cost = new AspectList().add(Aspect.AIR, 10);
    static final String TAG_SPRINTING = "isSprinting";
    static final String TAG_COOLDOWN = "cooldown";
    List<String> playersWithFlight = new ArrayList<String>();
    private static final ResourceLocation circle = new ResourceLocation("taintedmagic:textures/misc/circle.png");

    public ItemFlyteCharm() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFlyteCharm");
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack s) {
        return TaintedMagic.rarityCreation;
    }

    public void func_77624_a(ItemStack s, EntityPlayer p, List l, boolean b) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("taintedmagic:ItemFlyteCharm");
    }

    @SubscribeEvent
    public void updateFlight(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.entityLiving;
            this.isFlying = p.field_71075_bZ.field_75100_b;
            if (this.playersWithFlight.contains(this.playerStr(p))) {
                if (this.shouldPlayerHaveFlight(p)) {
                    p.field_71075_bZ.field_75101_c = true;
                } else {
                    if (!p.field_71075_bZ.field_75098_d) {
                        p.field_71075_bZ.field_75101_c = false;
                        p.field_71075_bZ.field_75100_b = false;
                        p.field_71075_bZ.field_75102_a = false;
                    }
                    this.playersWithFlight.remove(this.playerStr(p));
                }
            } else if (this.shouldPlayerHaveFlight(p)) {
                this.playersWithFlight.add(this.playerStr(p));
                p.field_71075_bZ.field_75101_c = true;
            }
            ItemStack s = null;
            for (int i = 0; i < p.field_71071_by.func_70302_i_(); ++i) {
                if (p.field_71071_by.func_70301_a(i) != null && p.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemFlyteCharm) {
                    s = p.field_71071_by.func_70301_a(i);
                    break;
                }
                s = null;
            }
            if (s != null) {
                if (s.field_77990_d == null) {
                    s.field_77990_d = new NBTTagCompound();
                }
                boolean wasSprinting = s.field_77990_d.func_74767_n(TAG_SPRINTING);
                boolean isSprinting = p.func_70051_ag();
                if (isSprinting != wasSprinting) {
                    s.field_77990_d.func_74757_a(TAG_SPRINTING, isSprinting);
                }
                if (this.getBurstCooldown(s) > 0.0f) {
                    this.setBurstCooldown(s, (int)Math.max(this.getBurstCooldown(s) - 1.0f, 0.0f));
                }
                if (p.field_70701_bs > 0.0f) {
                    float mul = 0.033333335f;
                    p.func_70060_a(0.0f, 1.0f, mul);
                    p.field_70747_aH = 2.0E-5f;
                }
                Vector3 look = new Vector3(p.func_70040_Z());
                look.normalize();
                if (this.isFlying) {
                    if (!p.field_71075_bZ.field_75098_d) {
                        TaintedMagicHelper.consumeVisFromInventory(p, cost, true);
                    }
                    if (!wasSprinting && isSprinting && this.getBurstCooldown(s) == 0.0f && TaintedMagicHelper.consumeVisFromInventory(p, new AspectList().add(Aspect.FIRE, 500), true)) {
                        p.field_70170_p.func_72980_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, "taintedmagic:burst", 5.0f, 1.0f + (float)Math.random() * 0.1f, true);
                        p.field_70159_w += look.x * 1.5;
                        p.field_70179_y += look.z * 1.5;
                        this.setBurstCooldown(s, 40);
                    } else if (this.getBurstCooldown(s) > 0.0f) {
                        if (40.0f - this.getBurstCooldown(s) < 2.0f) {
                            p.func_70060_a(0.0f, 1.0f, 5.0f);
                        } else if (40.0f - this.getBurstCooldown(s) < 10.0f) {
                            p.func_70031_b(false);
                        }
                    }
                } else {
                    boolean doGlide;
                    boolean bl = doGlide = p.func_70093_af() && !p.field_70122_E && p.field_70143_R >= 2.0f;
                    if (doGlide) {
                        p.field_70181_x = Math.max((double)-0.4f, p.field_70181_x * 2.0);
                        float mul = 3.0f;
                        p.field_70159_w = look.x * (double)mul;
                        p.field_70179_y = look.z * (double)mul;
                        p.field_70143_R = 2.0f;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.player.func_146103_bH().getName();
        this.playersWithFlight.remove(username + ":false");
        this.playersWithFlight.remove(username + ":true");
    }

    public String playerStr(EntityPlayer p) {
        return p.func_146103_bH().getName() + ":" + p.field_70170_p.field_72995_K;
    }

    private boolean shouldPlayerHaveFlight(EntityPlayer p) {
        for (int i = 0; i < p.field_71071_by.func_70302_i_(); ++i) {
            if (p.field_71071_by.func_70301_a(i) == null || !(p.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemFlyteCharm) || !TaintedMagicHelper.consumeVisFromInventory(p, cost, false)) continue;
            return true;
        }
        return false;
    }

    public void setBurstCooldown(ItemStack s, int cooldown) {
        if (s.field_77990_d == null) {
            s.field_77990_d = new NBTTagCompound();
        }
        s.func_77978_p().func_74768_a(TAG_COOLDOWN, cooldown);
    }

    public float getBurstCooldown(ItemStack s) {
        if (s.field_77990_d == null) {
            s.field_77990_d = new NBTTagCompound();
        }
        return s.field_77990_d.func_74762_e(TAG_COOLDOWN);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Specials.Post event) {
        EntityPlayer p = event.entityPlayer;
        boolean render = false;
        for (int i = 0; i < p.field_71071_by.func_70302_i_(); ++i) {
            if (p.field_71071_by.func_70301_a(i) != null && p.field_71071_by.func_70301_a(i).func_77973_b() instanceof ItemFlyteCharm) {
                render = true;
                break;
            }
            render = false;
        }
        if (render) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (p.func_70093_af()) {
                GL11.glRotatef((float)28.64789f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glTranslated((double)0.0, (double)((double)((p != Minecraft.func_71410_x().field_71439_g ? 1.62f : 0.0f) - p.getDefaultEyeHeight()) + (p.func_70093_af() ? 0.0625 : 0.0)), (double)0.0);
            GL11.glRotatef((float)45.0f, (float)-1.0f, (float)0.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.2f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glShadeModel((int)7425);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            Tessellator t = Tessellator.field_78398_a;
            GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
            GL11.glRotatef((float)((float)p.field_70173_aa + event.partialRenderTick), (float)0.0f, (float)1.0f, (float)0.0f);
            UtilsFX.bindTexture((ResourceLocation)circle);
            t.func_78382_b();
            t.func_78374_a(-1.0, 0.0, -1.0, 0.0, 0.0);
            t.func_78374_a(-1.0, 0.0, 1.0, 0.0, 1.0);
            t.func_78374_a(1.0, 0.0, 1.0, 1.0, 1.0);
            t.func_78374_a(1.0, 0.0, -1.0, 1.0, 0.0);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public int getWarp(ItemStack s, EntityPlayer p) {
        return 5;
    }
}

