/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.gui.components;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.client.SharedAssets;
import com.builtbroken.mc.client.helpers.Render2DHelper;
import com.builtbroken.mc.prefab.gui.GuiContainerBase;
import com.builtbroken.mc.prefab.gui.buttons.GuiButton9px;
import com.builtbroken.mc.prefab.gui.components.GuiComponent;
import com.builtbroken.mc.prefab.gui.components.GuiComponentContainer;
import com.builtbroken.mc.prefab.gui.pos.HugBottom;
import com.builtbroken.mc.prefab.gui.pos.HugXSide;
import com.builtbroken.mc.prefab.gui.screen.GuiScreenBase;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScrollBar
extends GuiComponentContainer<GuiScrollBar> {
    public static final int barU = 16;
    public static final int barV = 0;
    public static final int barWidth = 9;
    public static final int barHeight = 139;
    public static final int sbarU = 26;
    public static final int sbarV = 0;
    public static final int sbarWidth = 7;
    public static final int sbarHeight = 138;
    private int currentScroll = 0;
    private int maxScroll;
    private int middleHeight;
    private int totalSize;
    protected GuiButton9px upButton;
    protected GuiButton9px downButton;

    public GuiScrollBar(int id, IPos2D point, int height, int maxScroll) {
        super(id, point);
        this.field_146120_f = 9;
        this.field_146121_g = height;
        this.maxScroll = maxScroll;
        this.addArrows();
        this.setHeight(height);
    }

    public GuiScrollBar(int id, int x, int y, int height, int maxScroll) {
        super(id, x, y, 9, height, "");
        this.maxScroll = maxScroll;
        this.addArrows();
        this.setHeight(height);
    }

    protected void addArrows() {
        this.upButton = (GuiButton9px)((Object)((GuiComponent)((Object)this.add(GuiButton9px.newUpButton(0, 0, 0).setRelativePosition(new HugXSide((GuiComponent)this, 0, true))))).disable());
        this.downButton = (GuiButton9px)((Object)this.add(GuiButton9px.newDownButton(1, 0, 0).setRelativePosition(new HugBottom(this, 0, -9, true))));
    }

    @Override
    public GuiScrollBar setHeight(int height) {
        super.setHeight(Math.max(height, 58));
        this.middleHeight = height - (this.getTopHeight() + this.getBotHeight()) - 18;
        this.totalSize = this.getTopHeight() + this.middleHeight + this.getBotHeight();
        return this;
    }

    @Override
    public GuiScrollBar setWidth(int w) {
        return this;
    }

    public void setMaxScroll(int maxScroll) {
        this.maxScroll = Math.max(0, maxScroll);
    }

    @Override
    protected void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        Color color = new Color(144, 144, 144);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)1.0f);
        Render2DHelper.renderWithRepeatVertical(this.field_146128_h, this.field_146129_i + 9, 16, 0, 9, 139, this.getTopHeight(), this.getBotHeight(), this.middleHeight);
        if (this.maxScroll > 0) {
            int maxScroll = this.maxScroll + 1;
            float heightP = Math.min(1.0f, 1.0f / (float)maxScroll);
            int barHeight = (int)(heightP * (float)this.totalSize);
            float barPercent = (float)(this.getCurrentScroll() + 1) / (float)maxScroll;
            int sliderRenderY = Math.max((int)(barPercent * (float)this.totalSize) - barHeight + this.field_146129_i, this.field_146129_i);
            color = new Color(119, 119, 119);
            GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)1.0f);
            Render2DHelper.renderWithRepeatVertical(this.field_146128_h + 1, sliderRenderY + 9, 26, 0, 7, 138, 4, 4, barHeight - 8);
        }
    }

    @Override
    public boolean handleMouseInput(Minecraft mc, int mouseX, int mouseY) {
        int scroll;
        if (this.isMouseInside(mouseX, mouseY) && (scroll = Mouse.getEventDWheel()) != 0) {
            this.setCurrentScroll(this.getCurrentScroll() - Math.min(Math.max(scroll, -1), 1));
            this.setCurrentScroll(Math.max(0, Math.min(this.maxScroll, this.getCurrentScroll())));
            if (mc.field_71462_r instanceof GuiScreenBase) {
                ((GuiScreenBase)mc.field_71462_r).func_146284_a(this);
            } else if (mc.field_71462_r instanceof GuiContainerBase) {
                ((GuiContainerBase)mc.field_71462_r).actionPerformedCallback(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getTexture() {
        return SharedAssets.GUI_COMPONENTS_BARS;
    }

    public int getTopHeight() {
        return 20;
    }

    public int getBotHeight() {
        return 20;
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 0) {
            if (this.getCurrentScroll() > 0) {
                this.setCurrentScroll(this.getCurrentScroll() - 1);
                this.downButton.enable();
            }
            if (this.getCurrentScroll() < 0) {
                this.setCurrentScroll(0);
            }
            if (this.getCurrentScroll() == 0) {
                this.upButton.disable();
            }
        } else if (button.field_146127_k == 1) {
            if (this.getCurrentScroll() < this.maxScroll) {
                this.setCurrentScroll(this.getCurrentScroll() + 1);
                this.upButton.enable();
            }
            if (this.getCurrentScroll() > this.maxScroll) {
                this.setCurrentScroll(this.maxScroll - 1);
            }
            if (this.getCurrentScroll() == this.maxScroll) {
                this.downButton.disable();
            }
        }
    }

    public int getCurrentScroll() {
        return this.currentScroll;
    }

    public void setCurrentScroll(int currentScroll) {
        this.currentScroll = currentScroll;
    }
}

