/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.map.data;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.world.map.data.ChunkMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class ChunkMapManager<M extends ChunkMap> {
    protected final HashMap<Integer, M> worldMaps = new HashMap();
    public final String saveFolder;
    public final String fileSaveName;

    public ChunkMapManager(String saveFolder, String saveFileName) {
        this.saveFolder = saveFolder;
        this.fileSaveName = saveFileName;
        if (!Engine.isJUnitTest()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            FMLCommonHandler.instance().bus().register((Object)this);
        }
    }

    public M getMap(World world, boolean create) {
        return this.getMapForDim(world.field_73011_w.field_76574_g, create);
    }

    public M getMapForDim(int dim, boolean create) {
        if (this.worldMaps.containsKey(dim)) {
            return (M)((ChunkMap)this.worldMaps.get(dim));
        }
        if (create) {
            this.loadOrCreate(dim);
            return (M)((ChunkMap)this.worldMaps.get(dim));
        }
        return null;
    }

    protected void loadOrCreate(int dim) {
        File file = this.getSaveFile(dim);
        M map = this.createNewMap(dim);
        if (file.exists()) {
            NBTTagCompound tag = NBTUtility.loadData(file);
            ((ChunkMap)map).load(tag);
            ((ChunkMap)map).onLoad();
        }
        this.worldMaps.put(dim, map);
    }

    public File getSaveFile(int dimID) {
        return new File(NBTUtility.getSaveDirectory(), "bbm/" + this.saveFolder + "/" + this.fileSaveName + "_" + dimID + ".dat");
    }

    protected abstract M createNewMap(int var1);

    @SubscribeEvent
    public void worldUpdateTick(TickEvent.WorldTickEvent event) {
        int dim;
        if (event.world.field_73011_w != null && event.side == Side.SERVER && event.phase == TickEvent.Phase.END && this.worldMaps.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            M map = this.getMapForDim(dim, false);
            if (((ChunkMap)map).shouldUnload()) {
                this.worldMaps.remove(dim);
            } else {
                ((ChunkMap)map).update();
            }
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        int dim;
        if (event.world.field_73011_w != null && this.worldMaps.containsKey(dim = event.world.field_73011_w.field_76574_g)) {
            M map = this.getMapForDim(dim, false);
            ((ChunkMap)map).onWorldUnload();
            this.worldMaps.remove(dim);
        }
    }
}

