/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class MathUtility {
    public static final Random rand = new Random();

    public static short randomShort() {
        return (short)(rand.nextInt(65534) - Short.MAX_VALUE);
    }

    public static float clampAngle(float var, float min, float max) {
        while (var < min) {
            var += 360.0f;
        }
        while (var > max) {
            var -= 360.0f;
        }
        return var;
    }

    public static double clampAngle(double var, double min, float max) {
        while (var < min) {
            var += (double)max;
        }
        while (var > (double)max) {
            var -= (double)max;
        }
        return var;
    }

    public static double clampAngleTo180(double var) {
        return MathUtility.clampAngle(var, -180.0, 180.0f);
    }

    public static double getSphereVolume(double radius) {
        return Math.PI * 4 * (radius * radius * radius) / 3.0;
    }

    public static int func_154353_e(double p_154353_0_) {
        return (int)(p_154353_0_ >= 0.0 ? p_154353_0_ : -p_154353_0_ + 1.0);
    }

    public static ForgeDirection getFacingDirectionFromAngle(float yaw) {
        float angle = MathHelper.func_76142_g((float)yaw);
        if (angle >= -45.0f && angle <= 45.0f) {
            return ForgeDirection.SOUTH;
        }
        if (angle >= 45.0f && angle <= 135.0f) {
            return ForgeDirection.WEST;
        }
        if (angle >= 135.0f && angle <= -135.0f) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.EAST;
    }

    public static ForgeDirection getFacingDirectionFromAngle(double yaw) {
        return MathUtility.getFacingDirectionFromAngle((float)yaw);
    }
}

