/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.energy.data;

import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractEnergyBuffer
implements IEnergyBuffer {
    private int energyStorage;

    @Override
    public int addEnergyToStorage(int energy, boolean doAction) {
        int prev = this.getEnergyStored();
        if (energy > 0) {
            int roomLeft = this.getMaxBufferSize() - this.getEnergyStored();
            if (energy < roomLeft) {
                if (doAction) {
                    this.energyStorage += energy;
                    if (prev != this.energyStorage) {
                        this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.ADD);
                    }
                }
                return energy;
            }
            if (doAction) {
                this.energyStorage = this.getMaxBufferSize();
                if (prev != this.energyStorage) {
                    this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.ADD);
                }
            }
            return roomLeft;
        }
        return 0;
    }

    @Override
    public int removeEnergyFromStorage(int energy, boolean doAction) {
        int prev = this.getEnergyStored();
        if (energy > 0 && this.getEnergyStored() > 0) {
            if (energy >= this.getEnergyStored()) {
                if (doAction) {
                    this.energyStorage = 0;
                    if (prev != this.getEnergyStored()) {
                        this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.REMOVE);
                    }
                }
                return this.getMaxBufferSize();
            }
            if (doAction) {
                this.energyStorage -= energy;
                if (prev != this.getEnergyStored()) {
                    this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.REMOVE);
                }
            }
            return energy;
        }
        return 0;
    }

    protected void onPowerChange(int prevEnergy, int current, EnergyActionType actionType) {
    }

    @Override
    public int getEnergyStored() {
        return this.energyStorage;
    }

    @Override
    public void setEnergyStored(int energy) {
        int prev = this.getEnergyStored();
        this.energyStorage = Math.min(this.getMaxBufferSize(), Math.max(0, energy));
        if (prev != this.energyStorage) {
            this.onPowerChange(prev, this.getEnergyStored(), EnergyActionType.SET);
        }
    }

    public void addEmeryFromItem(ItemStack stackInSlot) {
        int energy;
        if (UniversalEnergySystem.isHandler(stackInSlot, ForgeDirection.UNKNOWN) && (energy = (int)Math.floor(UniversalEnergySystem.drain(stackInSlot, 2.147483647E9, false))) > 0) {
            UniversalEnergySystem.drain(stackInSlot, this.addEnergyToStorage(energy, true), true);
        }
    }

    public static enum EnergyActionType {
        ADD,
        REMOVE,
        SET;

    }
}

