/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.handler;

import com.builtbroken.mc.api.tile.IRemovable;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class InteractionHandler {
    @SideOnly(value=Side.CLIENT)
    public static Block getMouseOverBlockClient() {
        MovingObjectPosition m = InteractionHandler.getMouseOverClient();
        if (m != null && m.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return new Location((World)Minecraft.func_71410_x().field_71441_e, m.field_72311_b, m.field_72312_c, m.field_72309_d).getBlock();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static Location getAimHitClient() {
        MovingObjectPosition m = InteractionHandler.getMouseOverClient();
        if (m != null) {
            if (m.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                return new Location((World)Minecraft.func_71410_x().field_71441_e, m.field_72311_b, m.field_72312_c, m.field_72309_d);
            }
            if (m.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                return new Location(m.field_72308_g);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition getMouseOverClient() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer != null) {
            Location vec = new Location(event.entityPlayer.field_70170_p, event.x, event.y, event.z);
            TileEntity tile = vec.getTileEntity();
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && tile instanceof IRemovable) {
                boolean do_drop = false;
                if (tile instanceof IRemovable.ICustomRemoval) {
                    do_drop = ((IRemovable.ICustomRemoval)tile).canBeRemoved(event.entityPlayer);
                } else if (tile instanceof IRemovable.ISneakWrenchable) {
                    do_drop = event.entityPlayer.func_70093_af() && WrenchUtility.isHoldingWrench(event.entityPlayer);
                } else if (tile instanceof IRemovable.IWrenchable) {
                    do_drop = WrenchUtility.isHoldingWrench(event.entityPlayer);
                } else if (tile instanceof IRemovable.ISneakPickup) {
                    do_drop = event.entityPlayer.func_70093_af() && event.entityPlayer.func_70694_bm() == null;
                } else {
                    boolean bl = do_drop = tile instanceof IRemovable.IPickup && event.entityPlayer.func_70694_bm() == null;
                }
                if (do_drop) {
                    List<ItemStack> drops = ((IRemovable)tile).getRemovedItems(event.entityPlayer);
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    try {
                        vec.oldWorld().func_147475_p(vec.xi(), vec.yi(), vec.zi());
                        vec.setBlock(Blocks.field_150350_a);
                        if (drops != null && !drops.isEmpty()) {
                            for (ItemStack item : drops) {
                                if (!event.entityPlayer.field_71071_by.func_70441_a(item)) {
                                    InventoryUtility.dropItemStack(vec, item);
                                    continue;
                                }
                                event.entityPlayer.field_71071_by.func_70296_d();
                            }
                            event.entityPlayer.field_71069_bz.func_75142_b();
                        }
                    }
                    catch (Exception e) {
                        Engine.logger().error("Failed to pick up block using event system");
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

