/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.codegen.template;

import com.builtbroken.mc.codegen.Main;
import com.builtbroken.mc.codegen.template.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Template {
    public static Pattern importPattern = Pattern.compile("import(.*?);");
    public static Pattern multiLineCommentPattern = Pattern.compile("\\/\\*(.*?)\\*\\/");
    public static Pattern extendsPattern = Pattern.compile("extends(.*?)implements");
    public static Pattern extendsPattern2 = Pattern.compile("extends(.*?)\\{");
    public static Pattern implementsPattern = Pattern.compile("implements(.*?)\\{");
    public static Pattern methodBodyPattern = Pattern.compile("(?s)#StartMethods#(.*?)//#EndMethods#(?-s)");
    public static Pattern fieldBodyPattern = Pattern.compile("(?s)#StartFields#(.*?)//#EndFields#(?-s)");
    private List<String> imports = new ArrayList<String>();
    private List<String> interfaces = new ArrayList<String>();
    private List<String> annotations = new ArrayList<String>();
    public String fieldBody;
    public String methodBody;
    String classExtending;
    private boolean valid = true;
    private String key;
    public final String annotationKey;
    public final String extendsCheck;

    public Template(String annotationKey, String extendsCheck) {
        this.annotationKey = annotationKey;
        this.extendsCheck = extendsCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template loadFile(File file, String spacer) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null && !(line = line.trim()).startsWith("@")) {
                builder.append(line);
            }
            String string = builder.toString();
            Matcher matcher = importPattern.matcher(string);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    this.imports.add(matcher.group(i).trim());
                }
            }
            builder = new StringBuilder();
            builder.append(line);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).contains("class")) {
                    if (line.startsWith("class")) break;
                    builder.append(line.substring(0, line.indexOf("class")));
                    line = line.substring(line.indexOf("class"), line.length());
                    break;
                }
                builder.append(line);
            }
            string = builder.toString();
            this.annotations.addAll(Parser.getAnnotations(string));
            Main.out(spacer + "  Annotations:");
            for (String annotation : this.annotations) {
                Main.out(spacer + "      " + annotation);
                if (!annotation.startsWith(this.annotationKey)) continue;
                String data = annotation.substring(annotation.indexOf("(") + 1, annotation.length() - 1);
                this.key = data.split("=")[1].replace("\"", "").trim();
            }
            if (this.key == null) {
                Main.out(spacer + "Class does not contain " + this.annotationKey + " or the key set was empty");
                this.valid = false;
                Iterator<String> i = null;
                return i;
            }
            builder = new StringBuilder();
            builder.append(line);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("//")) continue;
                if (line.contains("//")) {
                    line = line.substring(0, line.indexOf("/"));
                    Main.warn("Found comment '" + line.substring(line.indexOf("/"), line.length()) + "' nested inside class header, commends should not be nested inside the class header. Remove these to improve class parsing and to improve readability.");
                }
                if (line.contains("{")) {
                    builder.append(line);
                    if (line.startsWith("{")) break;
                    line = line.substring(line.indexOf("{") + 1, line.length());
                    break;
                }
                builder.append(line);
            }
            string = builder.toString();
            matcher = multiLineCommentPattern.matcher(string);
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String comment = "/*" + matcher.group(i) + "*/";
                    string = string.replace(comment, "");
                    Main.warn(spacer + "Found comment '" + comment + "' nested inside class header, commends should not be nested inside the class header. Remove these to improve class parsing and to improve readability.");
                }
            }
            Main.out(spacer + "  Extends:");
            matcher = extendsPattern.matcher(string);
            if (matcher.find()) {
                this.classExtending = matcher.group(1).trim();
            }
            if (this.classExtending == null && (matcher = extendsPattern2.matcher(string)).find()) {
                this.classExtending = matcher.group(1).trim();
            }
            if (this.classExtending != null) {
                Main.out(spacer + "      " + this.classExtending);
                if (!this.classExtending.equals(this.extendsCheck)) {
                    Main.out(spacer + "      Error class must extend TileEntityWrapper");
                    this.valid = false;
                    Template i = this;
                    return i;
                }
            } else {
                Main.out(spacer + "      none");
                Main.out(spacer + "      Error class must extend something");
                this.valid = false;
                Template i = this;
                return i;
            }
            Main.out(spacer + "  Interfaces:");
            matcher = implementsPattern.matcher(string);
            while (matcher.find()) {
                String[] imps;
                for (String imp : imps = matcher.group(1).trim().split(",")) {
                    this.interfaces.add(imp.trim());
                    Main.out(spacer + "      " + imp);
                }
            }
            if (this.interfaces.isEmpty()) {
                Main.out(spacer + "      none");
            }
            builder = new StringBuilder();
            builder.append(line);
            while ((line = br.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            string = builder.toString();
            matcher = fieldBodyPattern.matcher(string);
            if (matcher.find()) {
                this.fieldBody = matcher.group(1);
            }
            if ((matcher = methodBodyPattern.matcher(string)).find()) {
                this.methodBody = matcher.group(1);
            }
        }
        return this;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }
}

