/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.integration.minetweaker;

import flaxbeard.steamcraft.tile.TileEntitySmasher;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.fsp.RockSmasher")
public class RockSmasherTweaker {
    @ZenMethod
    public static void addSmashingRecipe(IItemStack in, IItemStack out) {
        ItemStack inStack = MineTweakerMC.getItemStack((IItemStack)in);
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        MineTweakerAPI.apply((IUndoableAction)new Add(inStack, outStack));
    }

    @ZenMethod
    public static void addSmashingOreRecipe(String dict, IItemStack out) {
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        MineTweakerAPI.apply((IUndoableAction)new Add(dict, outStack));
    }

    @ZenMethod
    public static void removeSmashingRecipe(IItemStack in, IItemStack out) {
        ItemStack inStack = MineTweakerMC.getItemStack((IItemStack)in);
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        MineTweakerAPI.apply((IUndoableAction)new Remove(inStack, outStack));
    }

    @ZenMethod
    public static void removeSmashingOreRecipe(String dict, IItemStack out) {
        ItemStack outStack = MineTweakerMC.getItemStack((IItemStack)out);
        MineTweakerAPI.apply((IUndoableAction)new Remove(dict, outStack));
    }

    private static class Remove
    implements IUndoableAction {
        private final Object in;
        private final ItemStack out;

        public Remove(Object in, ItemStack out) {
            this.in = in;
            this.out = out;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                TileEntitySmasher.REGISTRY.removeSmashable((ItemStack)this.in, this.out);
            } else if (this.in instanceof String) {
                TileEntitySmasher.REGISTRY.removeSmashable((String)this.in, this.out);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.in instanceof ItemStack) {
                TileEntitySmasher.REGISTRY.registerSmashable((ItemStack)this.in, this.out);
            } else if (this.in instanceof String) {
                TileEntitySmasher.REGISTRY.registerSmashable((String)this.in, this.out);
            }
        }

        public String describe() {
            if (this.in instanceof ItemStack) {
                return "Removing smashing recipe for " + ((ItemStack)this.in).func_77977_a();
            }
            if (this.in instanceof String) {
                return "Removing smashing recipe for " + this.in;
            }
            return null;
        }

        public String describeUndo() {
            if (this.in instanceof ItemStack) {
                return "Adding smashing recipe for " + ((ItemStack)this.in).func_77977_a();
            }
            if (this.in instanceof String) {
                return "Adding smashing recipe for " + this.in;
            }
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final Object in;
        private final ItemStack out;

        public Add(Object in, ItemStack out) {
            this.in = in;
            this.out = out;
        }

        public void apply() {
            if (this.in instanceof ItemStack) {
                TileEntitySmasher.REGISTRY.registerSmashable((ItemStack)this.in, this.out);
            } else if (this.in instanceof String) {
                TileEntitySmasher.REGISTRY.registerSmashable((String)this.in, this.out);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.in instanceof ItemStack) {
                TileEntitySmasher.REGISTRY.removeSmashable((ItemStack)this.in, this.out);
            } else if (this.in instanceof String) {
                TileEntitySmasher.REGISTRY.removeSmashable((String)this.in, this.out);
            }
        }

        public String describe() {
            if (this.in instanceof ItemStack) {
                return "Adding smashing recipe for " + ((ItemStack)this.in).func_77977_a();
            }
            if (this.in instanceof String) {
                return "Adding smashing recipe for " + this.in;
            }
            return null;
        }

        public String describeUndo() {
            if (this.in instanceof ItemStack) {
                return "Removing smashing recipe for " + ((ItemStack)this.in).func_77977_a();
            }
            if (this.in instanceof String) {
                return "Removing smashing recipe for " + this.in;
            }
            return null;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

