/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.api.block.IDisguisableBlock;
import flaxbeard.steamcraft.api.enhancement.UtilEnhancements;
import flaxbeard.steamcraft.client.ClientProxy;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.integration.baubles.BaublesIntegration;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.ItemSteamCell;
import flaxbeard.steamcraft.network.CamoPacket;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.tuple.MutablePair;

public class SteamcraftTickHandler {
    private static float zoom = 0.0f;
    ResourceLocation spyglassfiller = new ResourceLocation("steamcraft:textures/gui/spyglassfiller.png");
    ResourceLocation spyglass = new ResourceLocation("steamcraft:textures/gui/spyglassfiller.png");
    private boolean inUse = false;
    private boolean wasInUse = false;
    private float fov = 0.0f;
    private float sensitivity = 0.0f;
    private int zoomSettingOn = 0;
    private boolean lastPressingKey = false;
    private boolean isJumping = false;
    private int ticksSinceLastCellFill = 0;
    private int lavaTicks = 0;
    private int chargeTicks = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemExosuitArmor item;
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        boolean isServer = event.side == Side.SERVER;
        ItemStack chest = player.func_82169_q(2);
        ItemStack boots = player.func_82169_q(0);
        if (!isServer) {
            this.isJumping = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        if (CrossMod.BAUBLES) {
            ++this.ticksSinceLastCellFill;
            if (BaublesIntegration.checkForSteamCellFiller(player)) {
                if (this.ticksSinceLastCellFill >= 10) {
                    for (int i = 0; i < InventoryPlayer.func_70451_h(); ++i) {
                        ItemStack item2 = player.field_71071_by.func_70301_a(i);
                        if (item2 == null || !(item2.func_77973_b() instanceof ItemSteamCell) || !ItemSteamCell.chargeItems(player, false)) continue;
                        player.field_71071_by.func_70298_a(i, 1);
                        this.ticksSinceLastCellFill = 0;
                        break;
                    }
                }
            } else {
                this.ticksSinceLastCellFill = -40;
            }
        }
        if (this.isJumping) {
            ItemExosuitArmor item3;
            if (boots != null && boots.func_77973_b() instanceof ItemExosuitArmor && (item3 = (ItemExosuitArmor)boots.func_77973_b()).hasUpgrade(boots, SteamcraftItems.doubleJump) && SteamcraftEventHandler.hasPower((EntityLivingBase)player, 15)) {
                if (isServer) {
                    if (!boots.field_77990_d.func_74764_b("usedJump")) {
                        boots.field_77990_d.func_74757_a("usedJump", false);
                    }
                    if (!boots.field_77990_d.func_74764_b("releasedSpace")) {
                        boots.field_77990_d.func_74757_a("releasedSpace", false);
                    }
                }
                if (!player.field_70122_E && boots.field_77990_d.func_74767_n("releasedSpace") && !boots.field_77990_d.func_74767_n("usedJump") && !player.field_71075_bZ.field_75100_b) {
                    if (isServer) {
                        boots.field_77990_d.func_74757_a("usedJump", true);
                        SteamcraftEventHandler.drainSteam(player.func_82169_q(2), 10);
                    }
                    player.field_70181_x = 0.65;
                    player.field_70143_R = 0.0f;
                }
                if (isServer) {
                    boots.field_77990_d.func_74757_a("releasedSpace", false);
                }
            }
            if (chest != null && chest.func_77973_b() instanceof ItemExosuitArmor) {
                item = (ItemExosuitArmor)chest.func_77973_b();
                if (item.hasUpgrade(chest, SteamcraftItems.jetpack) && SteamcraftEventHandler.hasPower((EntityLivingBase)player, 5) && !player.field_70122_E && !player.field_71075_bZ.field_75100_b) {
                    player.field_70181_x += 0.06;
                    player.field_70143_R = 0.0f;
                    if (!isServer) {
                        double rotation = Math.toRadians(player.field_70761_aq);
                        world.func_72869_a("smoke", player.field_70165_t + 0.4 * Math.sin(rotation + (double)0.9f), player.field_70163_u - 1.0, player.field_70161_v - 0.4 * Math.cos(rotation + (double)0.9f), 0.0, -1.0, 0.0);
                        world.func_72869_a("smoke", player.field_70165_t + 0.4 * Math.sin(rotation - (double)0.9f), player.field_70163_u - 1.0, player.field_70161_v - 0.4 * Math.cos(rotation - (double)0.9f), 0.0, -1.0, 0.0);
                    } else {
                        SteamcraftEventHandler.drainSteam(chest, Config.jetpackConsumption);
                    }
                }
                if (item.hasUpgrade(chest, SteamcraftItems.pitonDeployer) && isServer && chest.field_77990_d.func_74764_b("grappled") && chest.field_77990_d.func_74767_n("grappled")) {
                    chest.field_77990_d.func_74757_a("grappled", false);
                }
            }
        } else if (boots != null && boots.func_77973_b() instanceof ItemExosuitArmor && (item = (ItemExosuitArmor)boots.func_77973_b()).hasUpgrade(boots, SteamcraftItems.doubleJump) && !player.field_70122_E && isServer) {
            boots.field_77990_d.func_74757_a("releasedSpace", true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void tickStart(TickEvent.ClientTickEvent event) {
        this.wasInUse = this.inUse;
        Minecraft mc = Minecraft.func_71410_x();
        this.inUse = false;
        if (event.side == Side.CLIENT && mc.field_71439_g != null) {
            ItemStack item;
            ItemStack hat;
            boolean hasHat;
            MovingObjectPosition pos;
            if (mc.field_71462_r == null || !(mc.field_71462_r instanceof GuiMerchant)) {
                SteamcraftEventHandler.lastViewVillagerGui = false;
            }
            EntityClientPlayerMP player = mc.field_71439_g;
            if (mc.field_71474_y.field_74313_G.func_151470_d() && player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemBlock && (pos = mc.field_71476_x) != null) {
                int x = pos.field_72311_b;
                int y = pos.field_72312_c;
                int z = pos.field_72309_d;
                TileEntity te = mc.field_71441_e.func_147438_o(x, y, z);
                if (mc.field_71441_e.func_147439_a(x, y, z) == SteamcraftBlocks.pipe || te != null && te instanceof IDisguisableBlock) {
                    CamoPacket packet = new CamoPacket(x, y, z);
                    Steamcraft.channel.sendToServer((IMessage)packet);
                }
            }
            if (SteamcraftEventHandler.hasPower((EntityLivingBase)player, 1) && player.func_71124_b(2) != null && player.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor) {
                ItemExosuitArmor leggings = (ItemExosuitArmor)player.func_71124_b(2).func_77973_b();
                if (player.field_70170_p.field_72995_K && leggings.hasUpgrade(player.func_71124_b(2), SteamcraftItems.thrusters) && !player.field_70122_E && Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > 0.0 && !player.func_70090_H() && !player.field_71075_bZ.field_75100_b) {
                    double rotation = Math.toRadians(player.field_70761_aq + 90.0f);
                    double rotation2 = Math.toRadians(player.field_70761_aq + 270.0f);
                    player.field_70170_p.func_72869_a("smoke", player.field_70165_t + 0.5 * Math.sin(rotation), player.field_70163_u - 1.0, player.field_70161_v - 0.5 * Math.cos(rotation), player.field_70159_w * (double)-0.1f, 0.0, player.field_70179_y * (double)-0.1f);
                    player.field_70170_p.func_72869_a("smoke", player.field_70165_t + 0.5 * Math.sin(rotation2), player.field_70163_u - 1.0, player.field_70161_v - 0.5 * Math.cos(rotation2), player.field_70159_w * (double)-0.1f, 0.0, player.field_70179_y * (double)-0.1f);
                }
            }
            boolean bl = hasHat = (hat = player.field_71071_by.field_70460_b[3]) != null && (hat.func_77973_b() == SteamcraftItems.monacle || hat.func_77973_b() == SteamcraftItems.goggles || hat.func_77973_b() == SteamcraftItems.exoArmorHead && (((ItemExosuitArmor)hat.func_77973_b()).hasUpgrade(hat, SteamcraftItems.goggles) || ((ItemExosuitArmor)hat.func_77973_b()).hasUpgrade(hat, SteamcraftItems.monacle)));
            if (hasHat && mc.field_71474_y.field_74320_O == 0) {
                if (ClientProxy.keyBindings.get("monocle").func_151470_d() && !this.lastPressingKey) {
                    ++this.zoomSettingOn;
                    this.zoomSettingOn %= 4;
                    switch (this.zoomSettingOn) {
                        case 0: {
                            mc.field_71474_y.field_74334_X = this.fov;
                            mc.field_71474_y.field_74341_c = this.sensitivity;
                            break;
                        }
                        case 1: {
                            int i;
                            mc.field_71474_y.field_74334_X = this.fov;
                            mc.field_71474_y.field_74341_c = this.sensitivity;
                            for (i = 0; Math.abs(mc.field_71474_y.field_74334_X - (this.fov + 5.0f) / 2.0f) > 2.5f && i < 200; ++i) {
                                zoom += 1.0f;
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                        case 2: {
                            int i;
                            mc.field_71474_y.field_74334_X = this.fov;
                            mc.field_71474_y.field_74341_c = this.sensitivity;
                            for (i = 0; Math.abs(mc.field_71474_y.field_74334_X - (this.fov + 5.0f) / 5.0f) > 2.5f && i < 200; ++i) {
                                zoom += 1.0f;
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                        case 3: {
                            int i;
                            mc.field_71474_y.field_74334_X = this.fov;
                            mc.field_71474_y.field_74341_c = this.sensitivity;
                            for (i = 0; Math.abs(mc.field_71474_y.field_74334_X - (this.fov + 5.0f) / 12.0f) > 2.5f && i < 200; ++i) {
                                zoom += 1.0f;
                                mc.field_71474_y.field_74334_X -= 2.5f;
                                mc.field_71474_y.field_74341_c -= 0.01f;
                            }
                            break;
                        }
                    }
                    this.lastPressingKey = true;
                } else if (!ClientProxy.keyBindings.get("monocle").func_151470_d()) {
                    this.lastPressingKey = false;
                }
                boolean bl2 = this.inUse = this.zoomSettingOn != 0;
            }
            if ((item = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c)) != null && item.func_77973_b() == SteamcraftItems.spyglass && mc.field_71474_y.field_74320_O == 0) {
                this.inUse = true;
                this.renderTelescopeOverlay();
            }
            if (!this.wasInUse && item != null && player.func_71039_bw() && item.func_77973_b() == SteamcraftItems.musket && UtilEnhancements.getEnhancementFromItem(item) == SteamcraftItems.spyglass) {
                NBTTagCompound nbt;
                boolean isShooting = false;
                if (item.field_77990_d != null && (nbt = item.func_77978_p()).func_74762_e("loaded") > 0) {
                    isShooting = true;
                }
                if (isShooting && mc.field_71474_y.field_74320_O == 0) {
                    this.inUse = true;
                    mc.field_71474_y.field_74334_X -= 30.0f;
                    mc.field_71474_y.field_74341_c -= 0.3f;
                    this.renderTelescopeOverlay();
                }
            }
            if (!this.inUse && !this.wasInUse) {
                this.fov = mc.field_71474_y.field_74334_X;
                this.sensitivity = mc.field_71474_y.field_74341_c;
            }
            if (!this.inUse && this.wasInUse) {
                mc.field_71474_y.field_74334_X = this.fov;
                mc.field_71474_y.field_74341_c = this.sensitivity;
            }
            if (this.inUse && !this.wasInUse) {
                zoom = 0.0f;
            }
            if (this.inUse && mc.field_71474_y.field_74312_F.func_151470_d() && zoom > 0.0f && item != null && item.func_77973_b() == SteamcraftItems.spyglass) {
                zoom -= 1.0f;
                mc.field_71474_y.field_74334_X += 2.5f;
                mc.field_71474_y.field_74341_c += 0.01f;
            }
            if (this.inUse && mc.field_71474_y.field_74313_G.func_151470_d() && mc.field_71474_y.field_74334_X > 5.0f && item != null && item.func_77973_b() == SteamcraftItems.spyglass) {
                zoom += 1.0f;
                mc.field_71474_y.field_74334_X -= 2.5f;
                mc.field_71474_y.field_74341_c -= 0.01f;
            }
        }
    }

    @SubscribeEvent
    public void fallFast(TickEvent.PlayerTickEvent event) {
        ItemExosuitArmor bootArmor;
        Item boots;
        ItemStack equipment;
        EntityPlayer player = event.player;
        if (SteamcraftEventHandler.hasPower((EntityLivingBase)player, 1) && (equipment = player.func_71124_b(1)) != null && (boots = equipment.func_77973_b()) instanceof ItemExosuitArmor && (bootArmor = (ItemExosuitArmor)boots).hasUpgrade(equipment, SteamcraftItems.anchorHeels)) {
            double newY;
            double d = newY = player.func_70090_H() ? -0.6 : -1.1;
            if (player.field_70181_x < -0.3 && player.field_70181_x != newY) {
                player.field_70181_x = newY;
            }
        }
    }

    @SubscribeEvent
    public void deleteLavaAndExplodeCharges(TickEvent.WorldTickEvent event) {
        Tuple3 coords;
        Map.Entry<MutablePair<Integer, Tuple3>, Integer> entry;
        if (event.side.isClient()) {
            return;
        }
        ++this.lavaTicks;
        ++this.chargeTicks;
        Iterator<Map.Entry<MutablePair<Integer, Tuple3>, Integer>> it = SteamcraftEventHandler.quickLavaBlocks.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            MutablePair<Integer, Tuple3> dimCoords = entry.getKey();
            coords = (Tuple3)dimCoords.getRight();
            int dim = (Integer)dimCoords.getLeft();
            int waitTicks = entry.getValue();
            WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (this.lavaTicks != waitTicks) continue;
            worldServer.func_147468_f(((Integer)coords.first).intValue(), ((Integer)coords.second).intValue(), ((Integer)coords.third).intValue());
            it.remove();
        }
        it = SteamcraftEventHandler.charges.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            MutablePair<Integer, Tuple3> playerCoords = entry.getKey();
            coords = (Tuple3)playerCoords.getRight();
            EntityPlayer player = (EntityPlayer)playerCoords.getLeft();
            int dim = player.field_71093_bK;
            int waitTicks = entry.getValue();
            WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(dim);
            if (this.chargeTicks < waitTicks) continue;
            double x = ((Integer)coords.first).intValue();
            double y = ((Integer)coords.second).intValue();
            double z = ((Integer)coords.third).intValue();
            worldServer.func_72876_a((Entity)player, x, y, z, 2.0f, true);
            it.remove();
        }
        if (this.lavaTicks >= 30) {
            this.lavaTicks = 0;
        }
        if (this.chargeTicks >= 360) {
            this.chargeTicks = 0;
        }
    }

    private void renderTelescopeOverlay() {
    }
}

