/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.handler;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.Steamcraft;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.IPipeWrench;
import flaxbeard.steamcraft.api.ISteamChargable;
import flaxbeard.steamcraft.api.IWrenchDisplay;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.api.block.IDisguisableBlock;
import flaxbeard.steamcraft.api.event.AnimalTradeEvent;
import flaxbeard.steamcraft.api.exosuit.ExosuitPlate;
import flaxbeard.steamcraft.api.exosuit.UtilPlates;
import flaxbeard.steamcraft.api.steamnet.SteamNetworkRegistry;
import flaxbeard.steamcraft.api.steamnet.data.SteamNetworkData;
import flaxbeard.steamcraft.api.tool.ISteamTool;
import flaxbeard.steamcraft.api.tool.UtilSteamTool;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.entity.EntityCanisterItem;
import flaxbeard.steamcraft.entity.ExtendedPropertiesMerchant;
import flaxbeard.steamcraft.entity.ExtendedPropertiesPlayer;
import flaxbeard.steamcraft.entity.ExtendedPropertiesVillager;
import flaxbeard.steamcraft.gui.GuiSteamcraftBook;
import flaxbeard.steamcraft.integration.BloodMagicIntegration;
import flaxbeard.steamcraft.integration.BotaniaIntegration;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.integration.EnchiridionIntegration;
import flaxbeard.steamcraft.integration.baubles.BaublesIntegration;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import flaxbeard.steamcraft.item.ItemSteamcraftBook;
import flaxbeard.steamcraft.item.firearm.ItemFirearm;
import flaxbeard.steamcraft.item.firearm.ItemRocketLauncher;
import flaxbeard.steamcraft.item.tool.steam.ItemDrillHeadUpgrade;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamAxe;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamDrill;
import flaxbeard.steamcraft.item.tool.steam.ItemSteamShovel;
import flaxbeard.steamcraft.item.tool.steam.SteamToolHelper;
import flaxbeard.steamcraft.misc.DrillHeadMaterial;
import flaxbeard.steamcraft.misc.FrequencyMerchant;
import flaxbeard.steamcraft.misc.OreDictHelper;
import flaxbeard.steamcraft.tile.TileEntitySmasher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMerchant;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SteamcraftEventHandler {
    private static final UUID uuid = UUID.fromString("bbd786a9-611f-4c31-88ad-36dc9da3e15c");
    private static final AttributeModifier exoBoost = new AttributeModifier(uuid, "EXOMOD", 0.2, 2).func_111168_a(true);
    private static final UUID uuid2 = UUID.fromString("33235dc2-bf3d-40e4-ae0e-78037c7535e6");
    private static final AttributeModifier exoBoostBad = new AttributeModifier(uuid2, "EXOMODBAD", -0.2, 2).func_111168_a(true);
    private static final UUID uuid3 = UUID.fromString("33235dc2-bf3d-40e4-ae0e-78037c7535e7");
    private static final AttributeModifier exoSwimBoost = new AttributeModifier(uuid3, "EXOSWIMBOOST", 1.0, 2).func_111168_a(true);
    private static final ResourceLocation icons = new ResourceLocation("steamcraft:textures/gui/icons.png");
    public static boolean lastViewVillagerGui = false;
    public static int use = -1;
    boolean lastWearing = false;
    boolean worldStartUpdate = false;
    private SPLog log = Steamcraft.log;
    private static boolean isShiftDown;
    private static Field lastBuyingPlayerField;
    private static Field timeUntilResetField;
    private static Field merchantField;
    private static Field buyingListField;
    List<DamageSource> invalidSources = Arrays.asList(DamageSource.field_76369_e, DamageSource.field_76380_i, DamageSource.field_76366_f, DamageSource.field_82727_n);
    private int sideHit;
    public static HashMap<MutablePair<Integer, Tuple3>, Integer> quickLavaBlocks;
    public static HashMap<MutablePair<EntityPlayer, Tuple3>, Integer> charges;
    public static final int PEACEFUL_CHARGE = 240;
    public static final int EASY_CHARGE_CAP = 280;
    public static final int EASY_CHARGE_MIN = 160;
    public static final int NORMAL_CHARGE_CAP = 320;
    public static final int NORMAL_CHARGE_MIN = 120;
    public static final int HARD_CHARGE_CAP = 360;
    public static final int HARD_CHARGE_MIN = 80;
    private static int[][] extraBlocksSide;
    private static int[][] extraBlocksForward;
    private static int[][] extraBlocksVertical;
    private static int[][] extraBlocks9Side;
    private static int[][] extraBlocks9Forward;
    private static int[][] extraBlocks9Vertical;
    private ArrayList<Material> LEAF_MATERIALS = new ArrayList<Material>(){
        {
            this.add(Material.field_151584_j);
            this.add(Material.field_151589_v);
            this.add(Material.field_151596_z);
            this.add(Material.field_151585_k);
        }
    };

    public static void drainSteam(ItemStack stack, int amount) {
        if (stack != null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.field_77990_d.func_74764_b("steamFill")) {
                stack.field_77990_d.func_74768_a("steamFill", 0);
            }
            int fill = stack.field_77990_d.func_74762_e("steamFill");
            fill = Math.max(0, fill - amount);
            stack.field_77990_d.func_74768_a("steamFill", fill);
        }
    }

    public static boolean hasPower(EntityLivingBase entityLiving, int i) {
        ItemStack chestStack;
        if (entityLiving.func_71124_b(3) != null && (chestStack = entityLiving.func_71124_b(3)).func_77973_b() instanceof ItemExosuitArmor) {
            return ((ItemExosuitArmor)chestStack.func_77973_b()).hasPower(chestStack, i);
        }
        return false;
    }

    @SubscribeEvent
    public void initializeEntityProperties(EntityEvent.EntityConstructing event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            entity.registerExtendedProperties(Steamcraft.PLAYER_PROPERTY_ID, (IExtendedEntityProperties)new ExtendedPropertiesPlayer());
        } else if (entity instanceof EntityVillager) {
            entity.registerExtendedProperties(Steamcraft.VILLAGER_PROPERTY_ID, (IExtendedEntityProperties)new ExtendedPropertiesVillager());
        } else if (entity instanceof EntityWolf || entity instanceof EntityOcelot) {
            entity.registerExtendedProperties(Steamcraft.MERCHANT_PROPERTY_ID, (IExtendedEntityProperties)new ExtendedPropertiesMerchant());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleRocketDisplay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL && Minecraft.func_71410_x().field_71439_g.func_70694_bm() != null && Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77973_b() == SteamcraftItems.rocketLauncher) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution var5 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int var6 = var5.func_78326_a();
            int var7 = var5.func_78328_b();
            FontRenderer var8 = mc.field_71466_p;
            int selectedRocketType = 0;
            if (Minecraft.func_71410_x().field_71439_g.func_70694_bm().func_77942_o() && Minecraft.func_71410_x().field_71439_g.func_70694_bm().field_77990_d.func_74764_b("rocketType")) {
                selectedRocketType = Minecraft.func_71410_x().field_71439_g.func_70694_bm().field_77990_d.func_74762_e("rocketType");
            }
            if (selectedRocketType > SteamcraftRegistry.rockets.size() - 1) {
                selectedRocketType = 0;
            }
            String tooltip = StatCollector.func_74838_a((String)"steamcraft.rocket") + " " + (selectedRocketType == 0 ? StatCollector.func_74838_a((String)"item.steamcraft:rocket.name.2") : StatCollector.func_74838_a((String)(((Item)SteamcraftRegistry.rockets.get(selectedRocketType)).func_77658_a() + ".name")));
            int tooltipStartX = (var6 - var8.func_78256_a(tooltip)) / 2;
            int tooltipStartY = var7 - 35 - (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? 0 : 35);
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            var8.func_78261_a(tooltip, tooltipStartX, tooltipStartY, 0xFFFFFF);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public void handleCanningMachine(EntityItemPickupEvent event) {
        block12: {
            ItemExosuitArmor leggings;
            EntityPlayer player;
            if (!(event.entityLiving instanceof EntityPlayer) || event.entityLiving.field_70170_p.field_72995_K || !SteamcraftEventHandler.hasPower((EntityLivingBase)(player = (EntityPlayer)event.entityLiving), 10) || player.func_71124_b(2) == null || !(player.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor) || !(leggings = (ItemExosuitArmor)player.func_71124_b(2).func_77973_b()).hasUpgrade(player.func_71124_b(2), SteamcraftItems.canner)) break block12;
            boolean isCannable = false;
            ItemStack item = event.item.func_92059_d().func_77946_l();
            if (item.func_77942_o() && item.field_77990_d.func_74764_b("canned")) {
                return;
            }
            if (item.func_77973_b().func_77667_c(item).toLowerCase().contains("ingot") || item.func_77973_b().func_77667_c(item).toLowerCase().contains("gem") || item.func_77973_b().func_77667_c(item).toLowerCase().contains("ore")) {
                isCannable = true;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)item)) {
                String str = OreDictionary.getOreName((int)id);
                if (!str.toLowerCase().contains("ingot") && !str.toLowerCase().contains("gem") && !str.toLowerCase().contains("ore")) continue;
                isCannable = true;
            }
            if (isCannable) {
                int i;
                int numCans = 0;
                for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != SteamcraftItems.canister) continue;
                    numCans += player.field_71071_by.func_70301_a((int)i).field_77994_a;
                }
                if (numCans >= item.field_77994_a) {
                    if (!item.func_77942_o()) {
                        item.func_77982_d(new NBTTagCompound());
                    }
                    item.field_77990_d.func_74768_a("canned", 0);
                    event.item.func_92058_a(item);
                    for (i = 0; i < item.field_77994_a; ++i) {
                        player.field_71071_by.func_146026_a(SteamcraftItems.canister);
                        player.field_71069_bz.func_75142_b();
                    }
                } else if (numCans != 0) {
                    item.field_77994_a -= numCans;
                    event.item.func_92058_a(item);
                    ItemStack item2 = item.func_77946_l();
                    item2.field_77994_a = numCans;
                    if (!item2.func_77942_o()) {
                        item2.func_77982_d(new NBTTagCompound());
                    }
                    item2.field_77990_d.func_74768_a("canned", 0);
                    EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, item2);
                    player.field_70170_p.func_72838_d((Entity)entityItem);
                    for (int i2 = 0; i2 < numCans; ++i2) {
                        player.field_71071_by.func_146026_a(SteamcraftItems.canister);
                        player.field_71069_bz.func_75142_b();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void handleCans(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.entity instanceof EntityItem && !(event.entity instanceof EntityCanisterItem) && (item = (EntityItem)event.entity).func_92059_d().func_77942_o() && item.func_92059_d().field_77990_d.func_74764_b("canned")) {
            if (!event.world.field_72995_K) {
                EntityCanisterItem item2 = new EntityCanisterItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, item);
                item2.field_70159_w = item.field_70159_w;
                item2.field_70181_x = item.field_70181_x;
                item2.field_70179_y = item.field_70179_y;
                item2.field_145804_b = item.field_145804_b;
                item.field_70170_p.func_72838_d((Entity)item2);
            }
            item.func_70106_y();
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            SteamNetworkData.get(event.world);
            SteamNetworkRegistry.initialize();
        }
    }

    public void renderTexture(int screenX, int screenY, int screenEndX, int screenEndY, double startU, double startV, double endU, double endV) {
        boolean zLevel = true;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + screenEndY), (double)zLevel, startU, endV);
        tessellator.func_78374_a((double)(screenX + screenEndX), (double)(screenY + screenEndY), (double)zLevel, endU, endV);
        tessellator.func_78374_a((double)(screenX + screenEndX), (double)(screenY + 0), (double)zLevel, endU, startV);
        tessellator.func_78374_a((double)(screenX + 0), (double)(screenY + 0), (double)zLevel, startU, startV);
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            Block block;
            ItemStack stack;
            ItemExosuitArmor chest;
            TileEntity te;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            MovingObjectPosition pos = mc.field_71476_x;
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() instanceof IPipeWrench && ((IPipeWrench)equipped).canWrench((EntityPlayer)player, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) && (te = mc.field_71441_e.func_147438_o(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)) instanceof IWrenchDisplay) {
                ((IWrenchDisplay)te).displayWrench(event);
            }
            if (CrossMod.BOTANIA && pos != null && player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && player.func_71124_b(4) != null && player.func_71124_b(4).func_77973_b() instanceof ItemExosuitArmor && (player.func_70694_bm() == null || player.func_70694_bm().func_77973_b() != BotaniaIntegration.twigWand()) && (chest = (ItemExosuitArmor)player.func_71124_b(3).func_77973_b()).hasUpgrade(player.func_71124_b(3), BotaniaIntegration.floralLaurel)) {
                Block block2 = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                BotaniaIntegration.displayThings(pos, event);
            }
            if (pos != null && mc.field_71439_g.func_71045_bC() != null && mc.field_71439_g.func_71045_bC().func_77973_b() == SteamcraftItems.book && (stack = (block = mc.field_71441_e.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d)).getPickBlock(pos, player.field_70170_p, pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (EntityPlayer)player)) != null) {
                for (ItemStack stack2 : SteamcraftRegistry.bookRecipes.keySet()) {
                    if (stack2.func_77973_b() != stack.func_77973_b() || stack2.func_77960_j() != stack.func_77960_j()) continue;
                    GL11.glPushMatrix();
                    int x = event.resolution.func_78326_a() / 2 - 8;
                    int y = event.resolution.func_78328_b() / 2 - 8;
                    int color = 0x6600FF00;
                    RenderItem.getInstance().func_77015_a(mc.field_71466_p, mc.field_71446_o, new ItemStack(SteamcraftItems.book), x, y);
                    GL11.glDisable((int)2896);
                    mc.field_71466_p.func_78261_a("", x + 15, y + 13, 0xC6C6C6);
                    GL11.glPopMatrix();
                    GL11.glEnable((int)3042);
                }
            }
        }
    }

    private static Field getField(String fieldName, String obfName, Class clazz) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(obfName);
        }
        catch (NoSuchFieldException e) {
            FMLLog.warning((String)("[FSP] Unable to find field " + fieldName + " with its obfuscated " + "name. Trying to find it by its name " + fieldName), (Object[])new Object[0]);
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
                String fields = "";
                for (Field field1 : clazz.getDeclaredFields()) {
                    fields = fields.isEmpty() ? fields + field1.getName() : fields + ", " + field1.getName();
                }
                FMLLog.warning((String)("Unable to find " + fieldName + " field in " + clazz.getName() + "class. Available fields are: " + fields + ". Things are not going to work right."), (Object[])new Object[0]);
            }
        }
        return field;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void updateVillagersClientside(GuiScreenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (merchantField != null && event.gui instanceof GuiMerchant && !lastViewVillagerGui) {
            GuiMerchant gui = (GuiMerchant)event.gui;
            if (mc.field_71439_g.field_71071_by.field_70460_b[3] != null && (mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat || mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)mc.field_71439_g.field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(mc.field_71439_g.field_71071_by.field_70460_b[3], SteamcraftItems.tophat))) {
                IMerchant merch = gui.func_147035_g();
                MerchantRecipeList recipeList = merch.func_70934_b((EntityPlayer)mc.field_71439_g);
                if (recipeList != null) {
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                    }
                    lastViewVillagerGui = true;
                }
                merch.func_70930_a(recipeList);
                try {
                    merchantField.set(gui, merch);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void updateVillagers(LivingEvent.LivingUpdateEvent event) {
        EntityVillager villager;
        if (event.entityLiving instanceof EntityVillager && timeUntilResetField != null && lastBuyingPlayerField != null) {
            EntityPlayer player;
            villager = (EntityVillager)event.entityLiving;
            Integer timeUntilReset = null;
            String lastBuyingPlayer = null;
            try {
                timeUntilReset = timeUntilResetField.getInt(villager);
                lastBuyingPlayer = (String)lastBuyingPlayerField.get(villager);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (!villager.func_70940_q() && timeUntilReset != null && timeUntilReset == 39 && lastBuyingPlayer != null && (player = villager.field_70170_p.func_72924_a(lastBuyingPlayer)) != null) {
                int level;
                ItemStack hat;
                if (player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat) {
                    hat = player.field_71071_by.field_70460_b[3];
                    if (!hat.func_77942_o()) {
                        hat.func_77982_d(new NBTTagCompound());
                    }
                    if (!hat.field_77990_d.func_74764_b("level")) {
                        hat.field_77990_d.func_74768_a("level", 0);
                    }
                    level = hat.field_77990_d.func_74762_e("level");
                    hat.field_77990_d.func_74768_a("level", ++level);
                } else if (player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(player.field_71071_by.field_70460_b[3], SteamcraftItems.tophat)) {
                    hat = ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).getStackInSlot(player.field_71071_by.field_70460_b[3], 3);
                    if (!hat.func_77942_o()) {
                        hat.func_77982_d(new NBTTagCompound());
                    }
                    if (!hat.field_77990_d.func_74764_b("level")) {
                        hat.field_77990_d.func_74768_a("level", 0);
                    }
                    level = hat.field_77990_d.func_74762_e("level");
                    hat.field_77990_d.func_74768_a("level", ++level);
                    ((ItemExosuitArmor)player.field_71071_by.field_70460_b[3].func_77973_b()).setInventorySlotContents(player.field_71071_by.field_70460_b[3], 3, hat);
                }
            }
        }
        if (event.entityLiving instanceof EntityVillager && !event.entityLiving.field_70170_p.field_72995_K && buyingListField != null) {
            villager = (EntityVillager)event.entityLiving;
            ExtendedPropertiesVillager nbt = (ExtendedPropertiesVillager)villager.getExtendedProperties(Steamcraft.VILLAGER_PROPERTY_ID);
            if (nbt.lastHadCustomer == null) {
                nbt.lastHadCustomer = false;
            }
            boolean hasCustomer = false;
            if (villager.func_70931_l_() != null && villager.func_70931_l_().field_71071_by.field_70460_b[3] != null && (villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.tophat || villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b() == SteamcraftItems.exoArmorHead && ((ItemExosuitArmor)villager.func_70931_l_().field_71071_by.field_70460_b[3].func_77973_b()).hasUpgrade(villager.func_70931_l_().field_71071_by.field_70460_b[3], SteamcraftItems.tophat))) {
                EntityPlayer customer = villager.func_70931_l_();
                hasCustomer = true;
                if (!nbt.lastHadCustomer.booleanValue()) {
                    MerchantRecipeList recipeList = villager.func_70934_b(customer);
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77397_d().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77394_a().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77396_b().field_77994_a / 1.25f));
                    }
                    try {
                        buyingListField.set(villager, recipeList);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!hasCustomer && nbt.lastHadCustomer.booleanValue()) {
                MerchantRecipeList recipeList = null;
                try {
                    recipeList = (MerchantRecipeList)buyingListField.get(villager);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (recipeList != null) {
                    for (Object obj : recipeList) {
                        MerchantRecipe recipe = (MerchantRecipe)obj;
                        if (recipe.func_77397_d().field_77994_a > 1 && recipe.func_77397_d().field_77994_a != MathHelper.func_76123_f((float)((float)recipe.func_77397_d().field_77994_a / 1.25f))) {
                            recipe.func_77397_d().field_77994_a = MathHelper.func_76123_f((float)((float)recipe.func_77397_d().field_77994_a / 1.25f));
                            continue;
                        }
                        if (recipe.func_77394_a().field_77994_a > 1 && recipe.func_77394_a().field_77994_a != MathHelper.func_76141_d((float)((float)recipe.func_77394_a().field_77994_a * 1.25f))) {
                            recipe.func_77394_a().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77394_a().field_77994_a * 1.25f));
                            continue;
                        }
                        if (recipe.func_77396_b() == null || recipe.func_77396_b().field_77994_a <= 1 || recipe.func_77396_b().field_77994_a == MathHelper.func_76141_d((float)((float)recipe.func_77396_b().field_77994_a * 1.25f))) continue;
                        recipe.func_77396_b().field_77994_a = MathHelper.func_76141_d((float)((float)recipe.func_77396_b().field_77994_a * 1.25f));
                    }
                }
                try {
                    buyingListField.set(villager, recipeList);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            nbt.lastHadCustomer = hasCustomer;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void muffleSounds(PlaySoundEvent17 event) {
        if (event.name.contains("step")) {
            float x = event.sound.func_147649_g();
            float y = event.sound.func_147654_h();
            float z = event.sound.func_147651_i();
            List entities = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - 0.5f), (double)(y - 0.5f), (double)(z - 0.5f), (double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f)));
            for (Object obj : entities) {
                ItemExosuitArmor leggings;
                EntityLivingBase entity = (EntityLivingBase)obj;
                if (entity.func_71124_b(2) == null || !(entity.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor) || !(leggings = (ItemExosuitArmor)entity.func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_71124_b(2), SteamcraftItems.stealthUpgrade)) continue;
                event.result = null;
            }
        }
    }

    @SubscribeEvent
    public void hideCloakedPlayers(LivingEvent.LivingUpdateEvent event) {
        ItemExosuitArmor leggings;
        EntityLiving entity;
        if (event.entityLiving instanceof EntityLiving && (entity = (EntityLiving)event.entityLiving).func_70638_az() != null && entity.func_70638_az().func_71124_b(2) != null && entity.func_70638_az().func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (leggings = (ItemExosuitArmor)entity.func_70638_az().func_71124_b(2).func_77973_b()).hasUpgrade(entity.func_70638_az().func_71124_b(2), SteamcraftItems.stealthUpgrade)) {
            IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double d0 = iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
            List list = entity.field_70170_p.func_72872_a(Entity.class, entity.field_70121_D.func_72314_b(d0 /= 1.5, 4.0, d0));
            boolean foundPlayer = false;
            for (Object mob : list) {
                Entity ent = (Entity)mob;
                if (ent != entity.func_70638_az()) continue;
                foundPlayer = true;
            }
            if (!foundPlayer) {
                entity.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void hideCloakedPlayers(LivingSetAttackTargetEvent event) {
        if (event.entityLiving instanceof EntityLiving) {
            ItemExosuitArmor leggings;
            EntityLiving entity = (EntityLiving)event.entityLiving;
            if (event.target != null && event.target.func_71124_b(2) != null && event.target.func_71124_b(2).func_77973_b() instanceof ItemExosuitArmor && (leggings = (ItemExosuitArmor)event.target.func_71124_b(2).func_77973_b()).hasUpgrade(event.target.func_71124_b(2), SteamcraftItems.stealthUpgrade)) {
                IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
                double d0 = iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
                List list = entity.field_70170_p.func_72872_a(Entity.class, entity.field_70121_D.func_72314_b(d0 /= 1.5, 4.0, d0));
                boolean foundPlayer = false;
                for (Object mob : list) {
                    Entity ent = (Entity)mob;
                    if (ent != event.target) continue;
                    foundPlayer = true;
                }
                if (!foundPlayer) {
                    entity.func_70624_b(null);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void plateTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.itemStack;
        if (UtilPlates.getPlate(stack) != null) {
            event.toolTip.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"steamcraft.plate.bonus") + UtilPlates.getPlate(stack).effect());
        }
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("canned")) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"steamcraft.canned"));
        }
        if (stack.func_77973_b() instanceof ItemExosuitArmor || stack.func_77973_b() instanceof ISteamChargable) {
            ArrayList<String> linesToRemove = new ArrayList<String>();
            for (String str : event.toolTip) {
                if (str == "") {
                    linesToRemove.add(str);
                }
                if (str.contains("+")) {
                    linesToRemove.add(str);
                }
                if (!str.contains("/") || str.contains("SU")) continue;
                linesToRemove.add(str);
            }
            for (String str : linesToRemove) {
                if (str.contains("+") && !str.contains("+0.25")) {
                    event.toolTip.remove(str);
                    event.toolTip.add(1, str);
                    continue;
                }
                event.toolTip.remove(str);
            }
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            for (ItemStack stack2 : SteamcraftRegistry.bookRecipes.keySet()) {
                if (stack2.func_77973_b() != stack.func_77973_b() || stack2.func_77960_j() != stack.func_77960_j() && !(stack.func_77973_b() instanceof ItemArmor) && !(stack.func_77973_b() instanceof ItemTool)) continue;
                boolean foundBook = CrossMod.ENCHIRIDION ? EnchiridionIntegration.hasBook(SteamcraftItems.book, (EntityPlayer)player) : false;
                for (int p = 0; p < player.field_71071_by.func_70302_i_(); ++p) {
                    if (player.field_71071_by.func_70301_a(p) == null || !(player.field_71071_by.func_70301_a(p).func_77973_b() instanceof ItemSteamcraftBook)) continue;
                    foundBook = true;
                    break;
                }
                if (!foundBook) continue;
                event.toolTip.add(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"steamcraft.book.shiftright"));
                boolean mouseDown = Mouse.isButtonDown((int)0);
                if (Config.singleButtonTrackpad && !mouseDown) {
                    mouseDown = Mouse.isButtonDown((int)1);
                }
                if ((!mouseDown || !Keyboard.isKeyDown((int)29)) && !Keyboard.isKeyDown((int)157)) continue;
                GuiSteamcraftBook.openRecipeFor(stack2, (EntityPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void doubleExp(PlayerPickupXpEvent event) {
        EntityPlayer player = event.entityPlayer;
        for (int i = 1; i < 5; ++i) {
            ItemExosuitArmor armor;
            ItemStack stack;
            float multiplier = 1.0f;
            if (player.func_71124_b(i) != null && (stack = player.func_71124_b(i)).func_77973_b() instanceof ItemExosuitArmor && (armor = (ItemExosuitArmor)stack.func_77973_b()).hasPlates(stack)) {
                ExosuitPlate plate = UtilPlates.getPlate(stack.field_77990_d.func_74779_i("plate"));
                String id = plate.getIdentifier();
                if (id.equals("Gold")) {
                    multiplier *= 1.25f;
                } else if (id.equals("Gilded Iron")) {
                    multiplier = (float)((double)multiplier * 1.125);
                }
            }
            event.orb.field_70530_e = MathHelper.func_76123_f((float)((float)event.orb.field_70530_e * multiplier));
        }
    }

    @SubscribeEvent
    public void useItem(PlayerUseItemEvent.Tick event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = event.duration;
        }
    }

    @SubscribeEvent
    public void useItemEnd(PlayerUseItemEvent.Finish event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = -1;
        }
    }

    @SubscribeEvent
    public void useItemEnd(PlayerUseItemEvent.Stop event) {
        if (event.item.func_77973_b() instanceof ItemFirearm || event.item.func_77973_b() instanceof ItemRocketLauncher) {
            use = -1;
        }
    }

    @SubscribeEvent
    public void handleFirePunch(LivingAttackEvent event) {
        ItemExosuitArmor chest;
        EntityLivingBase entity;
        boolean hasPower;
        if (event.source.func_76364_f() instanceof EntityLivingBase && (hasPower = SteamcraftEventHandler.hasPower(entity = (EntityLivingBase)event.source.func_76364_f(), Config.powerFistConsumption)) && entity.func_71124_b(3) != null && entity.func_70694_bm() == null && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.powerFist)) {
            entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "random.explode", 4.0f, (1.0f + (entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            event.entityLiving.field_70159_w += 3.0 * entity.func_70040_Z().func_72432_b().field_72450_a;
            event.entityLiving.field_70181_x = event.entityLiving.field_70181_x + ((entity.func_70040_Z().func_72432_b().field_72448_b > 0.0 ? 2.0 * entity.func_70040_Z().func_72432_b().field_72448_b : 0.0) + 1.5);
            event.entityLiving.field_70179_y += 3.0 * entity.func_70040_Z().func_72432_b().field_72449_c;
            entity.field_70159_w += -0.5 * entity.func_70040_Z().func_72432_b().field_72450_a;
            entity.field_70179_y += -0.5 * entity.func_70040_Z().func_72432_b().field_72449_c;
            SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.powerFistConsumption);
        }
    }

    @SubscribeEvent
    public void handlePistonPunch(PlayerInteractEvent event) {
        ItemExosuitArmor armor;
        ItemStack chestStack;
        Item chest;
        EntityPlayer entity = event.entityPlayer;
        int consumption = Config.pistonPushConsumption;
        boolean hasPower = SteamcraftEventHandler.hasPower((EntityLivingBase)entity, consumption);
        ItemStack heldItem = entity.func_70694_bm();
        if (hasPower && heldItem == null && (chest = (chestStack = entity.func_71124_b(3)).func_77973_b()) instanceof ItemExosuitArmor && (armor = (ItemExosuitArmor)chest).hasUpgrade(chestStack, SteamcraftItems.pistonPush)) {
            World world = event.world;
            int face = event.face;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            if (face == 0) {
                if (y != 256) {
                    ++y;
                }
            } else if (face == 1) {
                if (y != 0) {
                    --y;
                }
            } else if (face == 2) {
                z = z < 0 ? ++z : --z;
            } else if (face == 3) {
                z = z < 0 ? --z : ++z;
            } else if (face == 4) {
                x = x < 0 ? --x : ++x;
            } else if (face == 5) {
                x = x < 0 ? ++x : --x;
            }
            int i = event.x;
            int j = event.y;
            int k = event.z;
            Block clickedBlock = world.func_147439_a(i, j, k);
            Block blockInPlace = world.func_147439_a(x, y, z);
            int clickedMeta = world.func_72805_g(i, j, k);
            if ((blockInPlace == null || blockInPlace == Blocks.field_150350_a || blockInPlace instanceof BlockFluidBase) && clickedBlock.func_149712_f(world, x, y, z) >= 0.0f && clickedBlock.func_149656_h() != 2 && clickedBlock != Blocks.field_150343_Z && j >= 0 && !clickedBlock.hasTileEntity(clickedMeta)) {
                world.func_147468_f(i, j, k);
                world.func_147465_d(x, y, z, clickedBlock, clickedMeta, 3);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
            }
        }
    }

    @SubscribeEvent
    public void hearMeRoar(LivingAttackEvent event) {
        if (event.source.func_76364_f() instanceof EntityLivingBase && !event.source.func_94541_c()) {
            EntityLivingBase entity = (EntityLivingBase)event.source.func_76364_f();
            World world = entity.field_70170_p;
            ItemStack equipment = entity.func_71124_b(4);
            ItemStack chest = entity.func_71124_b(3);
            if (entity.func_70694_bm() == null && entity.func_70093_af() && equipment != null && chest != null && chest.func_77973_b() instanceof ItemExosuitArmor && chest.func_77942_o()) {
                ItemExosuitArmor helmetArmor;
                int consumption = chest.field_77990_d.func_74762_e("maxFill") / 2 + Config.dragonRoarConsumption;
                Item helmet = equipment.func_77973_b();
                if (SteamcraftEventHandler.hasPower(entity, consumption) && helmet instanceof ItemExosuitArmor && (helmetArmor = (ItemExosuitArmor)helmet).hasUpgrade(equipment, SteamcraftItems.dragonRoar)) {
                    if (world.field_72995_K) {
                        world.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "mob.enderdragon.growl", 5.0f, 0.8f + world.field_73012_v.nextFloat() * 0.3f, false);
                    } else {
                        world.func_72876_a((Entity)entity, entity.field_70165_t + 0.5, entity.field_70163_u, entity.field_70161_v + 0.5, 10.0f, false);
                    }
                    SteamcraftEventHandler.drainSteam(chest, consumption);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleFallDamage(LivingHurtEvent event) {
        int safe;
        int i;
        EntityPlayer player;
        if (CrossMod.BLOOD_MAGIC) {
            BloodMagicIntegration.handleAttack(event);
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && !event.entityLiving.field_70170_p.field_72995_K && (player = (EntityPlayer)event.entityLiving).func_110143_aJ() <= 5.0f) {
            int vibrantLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Vibrant") continue;
                ++vibrantLevel;
            }
            if (vibrantLevel > 0 && player.field_70170_p.field_73012_v.nextInt(5 - vibrantLevel) == 0) {
                int startRotation = player.field_70170_p.field_73012_v.nextInt(360);
                boolean foundSpot = false;
                int range = 14;
                int counter = 0;
                int yO = 2;
                int tX = 0;
                int tY = 0;
                int tZ = 0;
                int safeRange = 7;
                safe = 0;
                while (!foundSpot && range < 28 && safe < 10000) {
                    ++safe;
                    tX = (int)(player.field_70165_t + (double)range * Math.sin(Math.toRadians(startRotation)));
                    List mobs = player.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((float)tX + 0.5f - (float)safeRange), (double)((float)(tY = (int)player.field_70163_u + yO) + 0.5f - (float)safeRange), (double)((float)(tZ = (int)(player.field_70161_v + (double)range * Math.cos(Math.toRadians(startRotation)))) + 0.5f - (float)safeRange), (double)((float)tX + 0.5f + (float)safeRange), (double)((float)tY + 0.5f + (float)safeRange), (double)((float)tZ + 0.5f + (float)safeRange)));
                    if (mobs.size() == 0 && player.field_70170_p.isSideSolid(tX, tY - 1, tZ, ForgeDirection.UP) && !player.field_70170_p.func_72953_d(AxisAlignedBB.func_72330_a((double)tX, (double)(tY - 1), (double)tZ, (double)tX, (double)(tY + 1), (double)tZ)) && player.field_70170_p.func_147437_c(tX, tZ, tY) && player.field_70170_p.func_147437_c(tX, tZ, tY + 1)) {
                        foundSpot = true;
                        continue;
                    }
                    if (counter >= 36) {
                        if (yO > -2) {
                            --yO;
                            counter = 0;
                            continue;
                        }
                        counter = 0;
                        yO = 2;
                        range += 2;
                        continue;
                    }
                    startRotation += 10;
                    ++counter;
                }
                if (foundSpot) {
                    ((EntityPlayerMP)player).field_71135_a.func_147364_a((double)tX, (double)tY, (double)tZ, (float)player.field_70170_p.field_73012_v.nextInt(360), player.field_70125_A);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && !event.entityLiving.field_70170_p.field_72995_K) {
            player = (EntityPlayer)event.entityLiving;
            Entity mob = event.source.func_76346_g();
            int enderiumLevel = 0;
            for (int i2 = 0; i2 < player.field_71071_by.field_70460_b.length; ++i2) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i2];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Enderium") continue;
                ++enderiumLevel;
            }
            if (enderiumLevel > 0 && player.field_70170_p.field_73012_v.nextFloat() < (float)enderiumLevel * 0.075f) {
                int startRotation = player.field_70170_p.field_73012_v.nextInt(360);
                boolean foundSpot = false;
                int range = 8;
                int counter = 0;
                int yO = 2;
                int tX = 0;
                int tY = 0;
                int tZ = 0;
                for (safe = 0; !foundSpot && range < 16 && safe < 10000; ++safe) {
                    tX = (int)(mob.field_70165_t + (double)range * Math.sin(Math.toRadians(startRotation)));
                    if (player.field_70170_p.isSideSolid(tX, (tY = (int)mob.field_70163_u + yO) - 1, tZ = (int)(mob.field_70161_v + (double)range * Math.cos(Math.toRadians(startRotation))), ForgeDirection.UP) && !player.field_70170_p.func_72953_d(AxisAlignedBB.func_72330_a((double)tX, (double)(tY - 1), (double)tZ, (double)tX, (double)(tY + 1), (double)tZ)) && player.field_70170_p.func_147437_c(tX, tZ, tY) && player.field_70170_p.func_147437_c(tX, tZ, tY + 1)) {
                        foundSpot = true;
                        continue;
                    }
                    if (counter >= 36) {
                        if (yO > -2) {
                            --yO;
                            counter = 0;
                            continue;
                        }
                        counter = 0;
                        yO = 2;
                        range += 2;
                        continue;
                    }
                    startRotation += 10;
                    ++counter;
                }
                if (foundSpot) {
                    mob.func_70080_a((double)tX, (double)tY, (double)tZ, mob.field_70177_z, mob.field_70125_A);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null) {
            player = (EntityPlayer)event.entityLiving;
            int fireLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Fiery") continue;
                fireLevel += 3;
            }
            if (fireLevel > 0 && player.field_70170_p.field_73012_v.nextInt(25) < fireLevel) {
                event.source.func_76346_g().func_70015_d(fireLevel / 2);
            }
        }
        if (event.entityLiving instanceof EntityPlayer && event.source.field_76373_n.equals("mob") && event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityLivingBase) {
            player = (EntityPlayer)event.entityLiving;
            int chillLevel = 0;
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                ItemExosuitArmor armorItem;
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ItemExosuitArmor) || !(armorItem = (ItemExosuitArmor)armor.func_77973_b()).hasPlates(armor) || UtilPlates.getPlate(armor.field_77990_d.func_74779_i("plate")).getIdentifier() != "Yeti") continue;
                ++chillLevel;
            }
            if (chillLevel > 0) {
                ((EntityLivingBase)event.source.func_76346_g()).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, chillLevel * 3 + 5, MathHelper.func_76123_f((float)((float)chillLevel / 2.0f))));
            }
        }
        if (event.source == DamageSource.field_76379_h) {
            ItemExosuitArmor boots;
            boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, (int)(event.ammount / 2.0f));
            int armor = this.getExoArmor(event.entityLiving);
            EntityLivingBase entity = event.entityLiving;
            if (hasPower && entity.func_71124_b(3) != null && entity.func_71124_b(1) != null && entity.func_71124_b(1).func_77973_b() instanceof ItemExosuitArmor && (boots = (ItemExosuitArmor)entity.func_71124_b(1).func_77973_b()).hasUpgrade(entity.func_71124_b(1), SteamcraftItems.fallAssist)) {
                if (event.ammount <= 6.0f) {
                    event.ammount = 0.0f;
                }
                event.ammount /= 3.0f;
                SteamcraftEventHandler.drainSteam(entity.func_71124_b(3), (int)(event.ammount / 2.0f));
                if (event.ammount == 0.0f) {
                    event.setResult(Event.Result.DENY);
                    event.setCanceled(true);
                }
            }
        }
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1).func_77973_b() instanceof ItemExosuitArmor) {
            ItemStack stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(1);
            ItemExosuitArmor item = (ItemExosuitArmor)stack.func_77973_b();
            float amount = event.ammount;
            EntityPlayer player2 = (EntityPlayer)event.entity;
            DamageSource src = event.source;
            if (!player2.func_85032_ar()) {
                if (amount <= 0.0f) {
                    return;
                }
                if (!src.func_76363_c() && player2.func_70632_aY() && amount > 0.0f) {
                    amount = (1.0f + amount) * 0.5f;
                }
                if ((amount = ISpecialArmor.ArmorProperties.ApplyArmor((EntityLivingBase)player2, (ItemStack[])player2.field_71071_by.field_70460_b, (DamageSource)src, (double)amount)) <= 0.0f) {
                    return;
                }
                float f1 = amount;
                amount = Math.max(amount - player2.func_110139_bj(), 0.0f);
            }
            if (amount > 0.0f) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        boolean hasPower = SteamcraftEventHandler.hasPower(event.entityLiving, Config.jumpBoostConsumptionShiftJump);
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0) != null && ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0).func_77973_b() instanceof ItemExosuitArmor) {
            ItemStack stack = ((EntityPlayer)event.entity).field_71071_by.func_70440_f(0);
            ItemExosuitArmor item = (ItemExosuitArmor)stack.func_77973_b();
            if ((event.entity.func_70093_af() && hasPower || SteamcraftEventHandler.hasPower(event.entityLiving, Config.jumpBoostConsumption)) && item.hasUpgrade(stack, SteamcraftItems.jumpAssist)) {
                if (event.entity.func_70093_af()) {
                    Vec3 vector = event.entityLiving.func_70676_i(0.5f);
                    double total = Math.abs(vector.field_72449_c + vector.field_72450_a);
                    EntityPlayer player = (EntityPlayer)event.entity;
                    double jump = 0.0;
                    if (jump >= 1.0) {
                        jump = (jump + 2.0) / 4.0;
                    }
                    if (vector.field_72448_b < total) {
                        vector.field_72448_b = total;
                    }
                    event.entityLiving.field_70181_x += (jump + 1.0) * vector.field_72448_b / 1.5;
                    event.entityLiving.field_70179_y += (jump + 1.0) * vector.field_72449_c * 2.0;
                    event.entityLiving.field_70159_w += (jump + 1.0) * vector.field_72450_a * 2.0;
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.jumpBoostConsumptionShiftJump);
                } else {
                    SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.jumpBoostConsumption);
                    event.entityLiving.field_70181_x += (double)0.275f;
                }
            }
            if (item.hasUpgrade(stack, SteamcraftItems.doubleJump)) {
                stack.field_77990_d.func_74757_a("releasedSpace", false);
            }
        }
    }

    public boolean hasItemInHotbar(EntityPlayer player, Item item) {
        for (int i = 0; i < 10; ++i) {
            if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void handleSteamcraftArmorMining(PlayerEvent.BreakSpeed event) {
        NBTTagCompound nbt;
        int speed;
        EntityPlayer player;
        ItemStack heldItemStack;
        EntityLivingBase entity = event.entityLiving;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        boolean hasPower = SteamcraftEventHandler.hasPower(entity, 1);
        int armor = this.getExoArmor(entity);
        if (hasPower && armor == 4) {
            event.newSpeed *= 1.2f;
        }
        if ((heldItemStack = (player = (EntityPlayer)entity).func_70694_bm()) == null) {
            return;
        }
        Item heldItem = heldItemStack.func_77973_b();
        int itemDamage = heldItemStack.func_77960_j();
        int maxDamage = heldItemStack.func_77958_k();
        if (CrossMod.BAUBLES) {
            if (BaublesIntegration.checkForSurvivalist(player) && heldItem instanceof ItemTool && itemDamage >= maxDamage - 1) {
                event.newSpeed = 0.0f;
            }
        } else if (this.hasItemInHotbar(player, SteamcraftItems.survivalist) && heldItem instanceof ItemTool && itemDamage >= maxDamage - 1) {
            event.newSpeed = 0.0f;
        }
        if (heldItem instanceof ItemSteamDrill) {
            NBTTagCompound nbt2 = SteamToolHelper.checkNBT(heldItemStack);
            int speed2 = nbt2.func_74762_e("Speed");
            if (speed2 > 0 && Items.field_151035_b.func_150893_a(heldItemStack, event.block) != 1.0f) {
                event.newSpeed *= 1.0f + 11.0f * ((float)speed2 / 1000.0f);
            }
        } else if (heldItem instanceof ItemSteamAxe) {
            NBTTagCompound nbt3 = SteamToolHelper.checkNBT(heldItemStack);
            int speed3 = nbt3.func_74762_e("Speed");
            if (speed3 > 0 && Items.field_151056_x.func_150893_a(player.func_70694_bm(), event.block) != 1.0f) {
                event.newSpeed *= 1.0f + 11.0f * ((float)speed3 / 1000.0f);
            }
        } else if (heldItem instanceof ItemSteamShovel && (speed = (nbt = SteamToolHelper.checkNBT(heldItemStack)).func_74762_e("Speed")) > 0 && Items.field_151047_v.func_150893_a(heldItemStack, event.block) != 1.0f) {
            event.newSpeed *= 1.0f + 19.0f * ((float)speed / 3000.0f);
        }
    }

    @SubscribeEvent
    public void handleFlippers(LivingEvent.LivingUpdateEvent event) {
        ItemExosuitArmor item;
        ItemExosuitArmor chest;
        EntityLivingBase entity = event.entityLiving;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        boolean hasPower = SteamcraftEventHandler.hasPower(entity, 1);
        if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.pitonDeployer) && entity.func_71124_b((int)3).field_77990_d.func_74764_b("grappled") && entity.func_71124_b((int)3).field_77990_d.func_74767_n("grappled")) {
            double lastX = entity.func_71124_b((int)3).field_77990_d.func_74760_g("x");
            double lastY = entity.func_71124_b((int)3).field_77990_d.func_74760_g("y");
            double lastZ = entity.func_71124_b((int)3).field_77990_d.func_74760_g("z");
            int blockX = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockX");
            int blockY = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockY");
            int blockZ = entity.func_71124_b((int)3).field_77990_d.func_74762_e("blockZ");
            if (Math.abs(lastX - entity.field_70165_t) > (double)0.1f || Math.abs(lastZ - entity.field_70161_v) > (double)0.1f || entity.func_70093_af() || entity.field_70170_p.func_147437_c(blockX, blockY, blockZ)) {
                entity.func_71124_b((int)3).field_77990_d.func_74757_a("grappled", false);
            } else {
                entity.field_70159_w = 0.0;
                entity.field_70181_x = entity.field_70181_x > 0.0 ? entity.field_70181_x : 0.0;
                entity.field_70179_y = 0.0;
            }
        }
        EntityPlayer player = (EntityPlayer)entity;
        ExtendedPropertiesPlayer nbt = (ExtendedPropertiesPlayer)player.getExtendedProperties(Steamcraft.PLAYER_PROPERTY_ID);
        ItemStack boots = player.field_71071_by.func_70440_f(0);
        ItemStack chest2 = player.func_71124_b(3);
        ItemStack leggings = player.func_71124_b(2);
        if (boots != null && boots.func_77973_b() instanceof ItemExosuitArmor && (item = (ItemExosuitArmor)boots.func_77973_b()).hasUpgrade(boots, SteamcraftItems.doubleJump) && event.entity.field_70122_E) {
            boots.field_77990_d.func_74757_a("usedJump", false);
        }
        if (chest2 != null && chest2.func_77973_b() instanceof ItemExosuitArmor && (item = (ItemExosuitArmor)chest2.func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.wings) && entity.field_70143_R > 1.5f && !entity.func_70093_af()) {
            entity.field_70143_R = 1.5f;
            entity.field_70181_x = Math.max(entity.field_70181_x, (double)-0.1f);
            entity.func_70091_d(entity.field_70159_w, 0.0, entity.field_70179_y);
        }
        if (hasPower && leggings != null && leggings.func_77973_b() instanceof ItemExosuitArmor) {
            item = (ItemExosuitArmor)leggings.func_77973_b();
            if (item.hasUpgrade(leggings, SteamcraftItems.thrusters)) {
                if (nbt.lastMotions == null) {
                    nbt.lastMotions = MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v);
                }
                double lastX = (Double)nbt.lastMotions.left;
                double lastZ = (Double)nbt.lastMotions.right;
                if (!(lastX == entity.field_70165_t && lastZ == entity.field_70161_v || entity.field_70122_E || entity.func_70090_H() || player.field_71075_bZ.field_75100_b)) {
                    entity.func_70091_d(entity.field_70159_w, 0.0, entity.field_70179_y);
                    if (!event.entityLiving.func_71124_b((int)3).field_77990_d.func_74764_b("ticksUntilConsume")) {
                        event.entityLiving.func_71124_b((int)3).field_77990_d.func_74768_a("ticksUntilConsume", 2);
                    }
                    if (event.entityLiving.func_71124_b((int)3).field_77990_d.func_74762_e("ticksUntilConsume") <= 0) {
                        SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.thrusterConsumption);
                    }
                }
            } else if (item.hasUpgrade(leggings, SteamcraftItems.runAssist)) {
                if (nbt.lastMotions == null) {
                    nbt.lastMotions = MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v);
                }
                double lastX = (Double)nbt.lastMotions.left;
                double lastZ = (Double)nbt.lastMotions.right;
                if (entity.field_70701_bs > 0.0f && (lastX != entity.field_70165_t || lastZ != entity.field_70161_v) && entity.field_70122_E && !entity.func_70090_H()) {
                    entity.func_70060_a(0.0f, 1.0f, 0.075f);
                    if (!event.entityLiving.func_71124_b((int)3).field_77990_d.func_74764_b("ticksUntilConsume")) {
                        event.entityLiving.func_71124_b((int)3).field_77990_d.func_74768_a("ticksUntilConsume", 2);
                    }
                    if (event.entityLiving.func_71124_b((int)3).field_77990_d.func_74762_e("ticksUntilConsume") <= 0) {
                        SteamcraftEventHandler.drainSteam(event.entityLiving.func_71124_b(3), Config.runAssistConsumption);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRangeClient(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            ItemExosuitArmor chest;
            this.worldStartUpdate = true;
            boolean wearing = false;
            if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.extendoFist)) {
                Steamcraft.proxy.checkRange(entity);
                wearing = true;
            }
            if (!wearing && this.lastWearing && entity.field_70170_p.field_72995_K) {
                Steamcraft.proxy.extendRange((Entity)entity, -2.0f);
            }
            this.lastWearing = wearing;
        }
    }

    @SubscribeEvent
    public void handleSteamcraftArmor(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        boolean hasPower = SteamcraftEventHandler.hasPower(entity, 1);
        int armor = this.getExoArmor(entity);
        ExtendedPropertiesPlayer tag = (ExtendedPropertiesPlayer)entity.getExtendedProperties(Steamcraft.PLAYER_PROPERTY_ID);
        if (entity.field_70170_p.field_72995_K) {
            this.updateRangeClient(event);
        } else {
            ItemExosuitArmor chest;
            boolean wearing = false;
            if (entity.func_71124_b(3) != null && entity.func_71124_b(3).func_77973_b() instanceof ItemExosuitArmor && (chest = (ItemExosuitArmor)entity.func_71124_b(3).func_77973_b()).hasUpgrade(entity.func_71124_b(3), SteamcraftItems.extendoFist) && !tag.isRangeExtended) {
                wearing = true;
                tag.isRangeExtended = true;
                Steamcraft.proxy.extendRange((Entity)entity, 2.0f);
            }
            if (!wearing && tag.isRangeExtended) {
                Steamcraft.proxy.extendRange((Entity)entity, -2.0f);
                tag.isRangeExtended = false;
            }
        }
        if (hasPower) {
            ItemStack stack;
            if (tag.lastMotions == null) {
                tag.lastMotions = MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoostBad);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoostBad);
            }
            if (!(stack = entity.func_71124_b(3)).func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.field_77990_d.func_74764_b("ticksUntilConsume")) {
                stack.field_77990_d.func_74768_a("ticksUntilConsume", 2);
            }
            int ticksLeft = stack.field_77990_d.func_74762_e("ticksUntilConsume");
            double lastX = (Double)tag.lastMotions.left;
            double lastZ = (Double)tag.lastMotions.right;
            if (ticksLeft <= 0) {
                if (Config.passiveDrain && (lastX != entity.field_70165_t || lastZ != entity.field_70161_v)) {
                    SteamcraftEventHandler.drainSteam(stack, 1);
                }
                ticksLeft = 2;
            }
            tag.lastMotions = MutablePair.of((Object)entity.field_70165_t, (Object)entity.field_70161_v);
            stack.field_77990_d.func_74768_a("ticksUntilConsume", --ticksLeft);
            if (armor == 4) {
                if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid) == null) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(exoBoost);
                }
                if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid) == null) {
                    entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(exoBoost);
                }
                if (tag.prevStep == null) {
                    tag.prevStep = Float.valueOf(entity.field_70138_W);
                }
                entity.field_70138_W = 1.0f;
            } else {
                this.removeGoodExoBoost(entity);
            }
        } else {
            this.removeGoodExoBoost(entity);
        }
        if (armor > 0 && !hasPower) {
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) == null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(exoBoostBad);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) == null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(exoBoostBad);
            }
        } else {
            this.removeBadExoBoost(entity);
        }
    }

    private void removeGoodExoBoost(EntityLivingBase entity) {
        if (entity.field_70173_aa % 20 == 0) {
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoost);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoost);
            }
            if (entity instanceof EntityPlayer) {
                ExtendedPropertiesPlayer tag = (ExtendedPropertiesPlayer)entity.getExtendedProperties(Steamcraft.PLAYER_PROPERTY_ID);
                if (tag.prevStep != null) {
                    entity.field_70138_W = tag.prevStep.floatValue();
                    tag.prevStep = null;
                }
            }
        }
    }

    private void removeBadExoBoost(EntityLivingBase entity) {
        if (entity.field_70173_aa % 20 == 0) {
            if (entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(exoBoostBad);
            }
            if (entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111127_a(uuid2) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(exoBoostBad);
            }
        }
    }

    public int getExoArmor(EntityLivingBase entityLiving) {
        int num = 0;
        for (int i = 1; i < 5; ++i) {
            ItemStack stack;
            if (entityLiving.func_71124_b(i) == null || !((stack = entityLiving.func_71124_b(i)).func_77973_b() instanceof ItemExosuitArmor)) continue;
            ++num;
        }
        return num;
    }

    @SubscribeEvent
    public void clickLeft(PlayerInteractEvent event) {
        if (CrossMod.BLOOD_MAGIC) {
            BloodMagicIntegration.clickLeft(event);
        }
        int x = event.x;
        int y = event.y;
        int z = event.z;
        World world = event.world;
        int face = event.face;
        PlayerInteractEvent.Action action = event.action;
        EntityPlayer player = event.entityPlayer;
        ItemStack chest = player.func_71124_b(3);
        if (action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            Block block1;
            Block block = world.func_147439_a(x, y, z);
            if (face != 1 && block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.getOrientation((int)face)) && chest != null && chest.func_77973_b() instanceof ItemExosuitArmor) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)face);
                AxisAlignedBB aabb = face == 0 ? AxisAlignedBB.func_72330_a((double)((float)x - 0.5f), (double)((float)y + (float)dir.offsetY / 6.0f - 0.4f), (double)((float)z - 0.2f), (double)((float)x + 0.5f + 1.0f), (double)((float)y + (float)dir.offsetY / 6.0f + 1.0f), (double)((float)z + 0.5f + 1.0f)) : AxisAlignedBB.func_72330_a((double)((float)x + (float)dir.offsetX / 6.0f), (double)((float)y + (float)dir.offsetY / 6.0f - 1.0f), (double)((float)z + (float)dir.offsetZ / 6.0f), (double)((float)x + (float)dir.offsetX / 6.0f + 1.0f), (double)((float)y + (float)dir.offsetY / 6.0f + 2.0f), (double)((float)z + (float)dir.offsetZ / 6.0f + 1.0f));
                ItemExosuitArmor chestArmor = (ItemExosuitArmor)chest.func_77973_b();
                boolean canStick = false;
                List list = world.func_72872_a(EntityPlayer.class, aabb);
                for (Object obj : list) {
                    if (obj != player) continue;
                    canStick = true;
                }
                if (canStick && chestArmor.hasUpgrade(chest, SteamcraftItems.pitonDeployer)) {
                    if (!world.field_72995_K) {
                        chest.field_77990_d.func_74776_a("x", (float)player.field_70165_t);
                        chest.field_77990_d.func_74776_a("z", (float)player.field_70161_v);
                        chest.field_77990_d.func_74776_a("y", (float)player.field_70163_u);
                        chest.field_77990_d.func_74768_a("blockX", event.x);
                        chest.field_77990_d.func_74768_a("blockY", event.y);
                        chest.field_77990_d.func_74768_a("blockZ", event.z);
                        chest.field_77990_d.func_74757_a("grappled", true);
                    }
                    player.field_70159_w = 0.0;
                    player.field_70181_x = 0.0;
                    player.field_70179_y = 0.0;
                    player.field_70143_R = 0.0f;
                }
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            ItemStack held = player.func_70694_bm();
            if (player.func_70093_af() && (tile != null && tile instanceof IDisguisableBlock || block == SteamcraftBlocks.pipe) && held != null && held.func_77973_b() instanceof ItemBlock && !((block1 = Block.func_149634_a((Item)event.entityPlayer.func_70694_bm().func_77973_b())) instanceof BlockContainer) && !(block1 instanceof ITileEntityProvider) && (block1.func_149645_b() == 0 || block1.func_149645_b() == 39 || block1.func_149645_b() == 31) && (block1.func_149686_d() || block1 == Blocks.field_150359_w && block == SteamcraftBlocks.pipe)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void burstZincPlate(LivingHurtEvent event) {
        EntityLivingBase entity = event.entityLiving;
        int consumption = Config.zincPlateConsumption;
        float amount = event.ammount;
        if (!this.invalidSources.contains(event.source) && entity instanceof EntityPlayer && SteamcraftEventHandler.hasPower(entity, consumption)) {
            EntityPlayer player = (EntityPlayer)entity;
            float health = player.func_110143_aJ();
            float maxHealth = player.func_110138_aP();
            float halfOfMax = maxHealth / 2.0f;
            if (amount >= halfOfMax || health <= halfOfMax) {
                ItemStack stackWithPlate = null;
                boolean hasZincPlate = false;
                for (int i = 1; i < 5; ++i) {
                    ItemExosuitArmor armor;
                    Item item;
                    ItemStack equipment = player.func_71124_b(i);
                    if (equipment == null || !((item = equipment.func_77973_b()) instanceof ItemExosuitArmor) || !(armor = (ItemExosuitArmor)item).hasPlates(equipment) || !UtilPlates.getPlate(equipment.field_77990_d.func_74779_i("plate")).getIdentifier().equals("Zinc")) continue;
                    stackWithPlate = equipment;
                    hasZincPlate = true;
                    break;
                }
                if (hasZincPlate) {
                    ItemStack zincPlates = new ItemStack(SteamcraftItems.steamcraftPlate, 2, 1);
                    World world = player.field_70170_p;
                    SteamcraftEventHandler.drainSteam(player.func_71124_b(3), consumption);
                    UtilPlates.removePlate(stackWithPlate);
                    EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, zincPlates);
                    world.func_72838_d((Entity)entityItem);
                    player.func_70606_j(health);
                    player.func_70057_ab();
                    world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "steamcraft:hiss", 2.0f, 0.9f);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void dropDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null || event.block == null) {
            return;
        }
        Random rand = new Random();
        EntityPlayer player = event.harvester;
        Block block = event.block;
        int meta = event.blockMetadata;
        Item otherBlockItem = block.func_149650_a(meta, rand, 0);
        Item blockItem = Item.func_150898_a((Block)block);
        MutablePair pair = MutablePair.of((Object)blockItem, (Object)meta);
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof ItemSteamDrill) {
            ItemStack out;
            ItemSteamDrill drill = (ItemSteamDrill)equipped.func_77973_b();
            if (!drill.isWound(equipped)) {
                return;
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.fortuneUpgrade)) {
                event.drops.clear();
                ArrayList trueDrops = block.getDrops(event.world, event.x, event.y, event.z, meta, EnchantmentHelper.func_77517_e((EntityLivingBase)player) + 2);
                event.drops.addAll(trueDrops);
            }
            if (OreDictHelper.cobblestones.contains(pair)) {
                return;
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.stoneGrinder)) {
                String harvestTool = block.getHarvestTool(meta);
                if (harvestTool == null || !harvestTool.equals(drill.toolClass())) {
                    return;
                }
                boolean addedNugget = false;
                for (int i = 0; i < event.drops.size(); ++i) {
                    ItemStack drop = (ItemStack)event.drops.get(i);
                    MutablePair item = MutablePair.of((Object)drop.func_77973_b(), (Object)drop.func_77960_j());
                    if (!OreDictHelper.stones.contains(item) && !OreDictHelper.cobblestones.contains(item)) continue;
                    event.drops.remove(i);
                    int chance = rand.nextInt(5);
                    if (chance != 3 || addedNugget) continue;
                    int index = rand.nextInt(OreDictHelper.nuggets.size());
                    MutablePair<Item, Integer> nuggetPair = OreDictHelper.nuggets.get(index);
                    int size = rand.nextInt(3) + 1;
                    ItemStack nugget = new ItemStack((Item)nuggetPair.left, size, ((Integer)nuggetPair.right).intValue());
                    event.drops.add(nugget);
                    addedNugget = true;
                }
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.internalProcessingUnit) && (out = TileEntitySmasher.REGISTRY.getOutput(new ItemStack(block, 1, meta))) != null && out.func_77973_b() != null) {
                if (rand.nextInt(Config.chance) == 0) {
                    out.field_77994_a *= 2;
                }
                for (int i = 0; i < event.drops.size(); ++i) {
                    ItemStack drop = (ItemStack)event.drops.get(i);
                    if (drop.func_77973_b() != Item.func_150898_a((Block)block) || drop.func_77960_j() != meta) continue;
                    event.drops.remove(i);
                }
                event.drops.add(out);
                drill.addSteam(equipped, -(2 * drill.steamPerDurability()), player);
            }
        } else if (equipped.func_77973_b() instanceof ItemSteamShovel) {
            int chance;
            int i;
            ItemSteamShovel shovel = (ItemSteamShovel)equipped.func_77973_b();
            if (!shovel.hasUpgrade(equipped, SteamcraftItems.sifter) || !shovel.isWound(equipped)) {
                return;
            }
            for (i = 0; i < event.drops.size(); ++i) {
                Item item = ((ItemStack)event.drops.get(i)).func_77973_b();
                if (item != blockItem && item != otherBlockItem) continue;
                event.drops.remove(i);
            }
            if (OreDictHelper.sands.contains(pair) && (chance = rand.nextInt(8)) == 5) {
                int index = rand.nextInt(OreDictHelper.goldNuggets.size());
                MutablePair<Item, Integer> nuggetPair = OreDictHelper.goldNuggets.get(index);
                int size = rand.nextInt(3) + 1;
                ItemStack nugget = new ItemStack((Item)nuggetPair.left, size, ((Integer)nuggetPair.right).intValue());
                event.drops.add(nugget);
                return;
            }
            if ((block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150458_ak) && (chance = rand.nextInt(6)) == 4) {
                int boneOrSeeds = rand.nextInt(2);
                int stackSize = rand.nextInt(3) + 1;
                ItemStack itemstack = boneOrSeeds == 1 ? new ItemStack(Items.field_151103_aS) : new ItemStack(Items.field_151014_N);
                itemstack.field_77994_a = stackSize;
                event.drops.add(itemstack);
                return;
            }
            if (event.block == Blocks.field_150351_n) {
                for (i = 0; i < event.drops.size(); ++i) {
                    if (((ItemStack)event.drops.get(i)).func_77973_b() != Items.field_151145_ak) continue;
                    event.dropChance = 90.0f;
                    return;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void doPreciseCuttingHead(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null || event.block == null) {
            return;
        }
        EntityPlayer player = event.harvester;
        Block block = event.block;
        int meta = event.blockMetadata;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof ItemSteamDrill) {
            ItemSteamDrill drill = (ItemSteamDrill)equipped.func_77973_b();
            if (!drill.isWound(equipped)) {
                return;
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.preciseCuttingHead) && ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta)) {
                Object toAdd = new ItemStack(block, 1, meta);
                if (toAdd.func_77973_b() == null) {
                    toAdd = block == Blocks.field_150439_ay ? new ItemStack(Blocks.field_150450_ax) : null;
                }
                if (toAdd != null) {
                    event.drops.clear();
                    event.drops.add(toAdd);
                }
            }
        }
    }

    @SubscribeEvent
    public void rebreath(LivingAttackEvent event) {
        ItemExosuitArmor helmetArmor;
        Item helmet;
        EntityPlayer player;
        ItemStack equipment;
        EntityLivingBase entity;
        int consumption = Config.rebreatherConsumption;
        if (event.source == DamageSource.field_76369_e && (entity = event.entityLiving) instanceof EntityPlayer && SteamcraftEventHandler.hasPower(entity, consumption) && (equipment = (player = (EntityPlayer)entity).func_71124_b(4)) != null && (helmet = equipment.func_77973_b()) instanceof ItemExosuitArmor && (helmetArmor = (ItemExosuitArmor)helmet).hasUpgrade(equipment, SteamcraftItems.rebreather)) {
            SteamcraftEventHandler.drainSteam(player.func_71124_b(3), consumption);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ISteamTool tool;
        EntityPlayer player = event.getPlayer();
        Block block = event.block;
        int meta = event.blockMetadata;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        World world = event.world;
        if (player == null) {
            return;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null || block == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof ItemSteamDrill) {
            ItemSteamDrill drill = (ItemSteamDrill)equipped.func_77973_b();
            ItemStack upgrade = UtilSteamTool.getHarvestLevelModifier(equipped);
            if (!drill.isWound(equipped)) {
                return;
            }
            if (upgrade != null) {
                String mat = ItemDrillHeadUpgrade.getMyMaterial(upgrade);
                int harvestLevel = DrillHeadMaterial.materials.get((Object)mat).harvestLevel;
                if (harvestLevel >= block.getHarvestLevel(meta)) {
                    block.func_149636_a(world, player, x, y, z, meta);
                    world.func_147468_f(x, y, z);
                } else {
                    event.setCanceled(true);
                }
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.bigDrill) && block.isToolEffective(drill.toolClass(), meta)) {
                this.mineExtraBlocks(this.getExtraBlockCoordinates(this.sideHit), x, y, z, world, (ItemTool)drill, equipped, player);
            }
            if (drill.hasUpgrade(equipped, SteamcraftItems.preciseCuttingHead)) {
                event.setExpToDrop(0);
            }
        } else if (equipped.func_77973_b() instanceof ItemSteamShovel) {
            ItemSteamShovel shovel = (ItemSteamShovel)equipped.func_77973_b();
            if (!shovel.isWound(equipped)) {
                return;
            }
            if (shovel.hasUpgrade(equipped, SteamcraftItems.rotaryBlades) && block.isToolEffective(shovel.toolClass(), meta)) {
                this.mineExtraBlocks(this.getExtraBlockCoordinates(this.sideHit), x, y, z, world, (ItemTool)shovel, equipped, player);
            } else if (shovel.hasUpgrade(equipped, SteamcraftItems.backhoe)) {
                boolean isFalling = block instanceof BlockFalling;
                int end = isFalling ? y + Config.backhoeRange : y;
                for (int i = y - Config.backhoeRange; i < end; ++i) {
                    if (i < 0) continue;
                    Block block1 = world.func_147439_a(x, i, z);
                    int meta1 = world.func_72805_g(x, i, z);
                    if (!block1.isToolEffective(shovel.toolClass(), meta) || !block1.canHarvestBlock(player, meta)) continue;
                    if (Item.func_150898_a((Block)block) == Item.func_150898_a((Block)block1)) {
                        world.func_147468_f(x, i, z);
                        block.func_149636_a(world, player, x, i, z, meta1);
                        continue;
                    }
                    break;
                }
            }
        } else if (equipped.func_77973_b() instanceof ItemSteamAxe) {
            ItemSteamAxe axe = (ItemSteamAxe)equipped.func_77973_b();
            if (!axe.isWound(equipped)) {
                return;
            }
            if (axe.hasUpgrade(equipped, SteamcraftItems.treeFeller) && block.isToolEffective(axe.toolClass(), meta)) {
                this.fellBlocks(world, x, y, z, player, equipped);
            }
            if (axe.hasUpgrade(equipped, SteamcraftItems.forestFire)) {
                this.burnBlocks(world, x, y, z);
            }
        }
        if (equipped.func_77973_b() instanceof ISteamTool && (tool = (ISteamTool)equipped.func_77973_b()).isWound(equipped) && tool.hasUpgrade(equipped, SteamcraftItems.overclocker)) {
            tool.addSteam(equipped, -tool.steamPerDurability(), player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void placeLava(BlockEvent.HarvestDropsEvent event) {
        ItemSteamDrill drill;
        EntityPlayer player = event.harvester;
        Block block = event.block;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        World world = event.world;
        if (player == null) {
            return;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null || block == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof ItemSteamDrill && (drill = (ItemSteamDrill)equipped.func_77973_b()).hasUpgrade(equipped, SteamcraftItems.thermalDrill) && drill.isWound(equipped)) {
            world.func_147449_b(x, y, z, Blocks.field_150353_l);
            quickLavaBlocks.put((MutablePair<Integer, Tuple3>)MutablePair.of((Object)player.field_71093_bK, (Object)new Tuple3(x, y, z)), new Random().nextInt(30) + 1);
            event.drops.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void placeCharge(BlockEvent.BreakEvent event) {
        ItemSteamDrill drill;
        EntityPlayer player = event.getPlayer();
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (player == null) {
            return;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null) {
            return;
        }
        if (equipped.func_77973_b() instanceof ItemSteamDrill && (drill = (ItemSteamDrill)equipped.func_77973_b()).hasUpgrade(equipped, SteamcraftItems.chargePlacer) && drill.isWound(equipped)) {
            Random rand = new Random();
            drill.addSteam(equipped, -(2 * drill.steamPerDurability()), player);
            if (player.field_70170_p.field_73013_u == EnumDifficulty.HARD && rand.nextInt(100) < 15) {
                return;
            }
            int max = 0;
            int min = 0;
            int constant = 0;
            boolean useConstant = false;
            switch (player.field_70170_p.field_73013_u) {
                case HARD: {
                    max = 360;
                    min = 80;
                    break;
                }
                case NORMAL: {
                    max = 320;
                    min = 120;
                    break;
                }
                case EASY: {
                    max = 280;
                    min = 160;
                    break;
                }
                case PEACEFUL: {
                    constant = 240;
                    useConstant = true;
                    break;
                }
            }
            MutablePair pair = MutablePair.of((Object)player, (Object)new Tuple3(x, y, z));
            if (useConstant) {
                charges.put((MutablePair<EntityPlayer, Tuple3>)pair, constant);
            } else {
                charges.put((MutablePair<EntityPlayer, Tuple3>)pair, rand.nextInt(max - min + 1) + min);
            }
        }
    }

    private void fellBlocks(World world, int startX, int startY, int startZ, EntityPlayer player, ItemStack axe) {
        Block block;
        ItemSteamAxe sAxe = (ItemSteamAxe)axe.func_77973_b();
        for (int y = startY; y < 256 && OreDictHelper.arrayHasItem(OreDictHelper.logs, Item.func_150898_a((Block)(block = world.func_147439_a(startX, y, startZ)))); ++y) {
            int meta = world.func_72805_g(startX, y, startZ);
            world.func_147468_f(startX, y, startZ);
            block.func_149636_a(world, player, startX, y, startZ, meta);
            if (y % 2 == 0 && !sAxe.addSteam(axe, -sAxe.steamPerDurability(), player)) break;
        }
    }

    private void burnBlocks(World world, int startX, int startY, int startZ) {
        for (int x = startX - 5; x < startX + 5; ++x) {
            for (int y = startY - 5; y < startY + 5; ++y) {
                for (int z = startZ - 5; z < startZ + 5; ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null || world.func_147437_c(x, y, z) || !block.isFlammable((IBlockAccess)world, x, y, z, ForgeDirection.getOrientation((int)this.sideHit))) continue;
                    world.func_147449_b(x, y, z, (Block)Blocks.field_150480_ab);
                }
            }
        }
    }

    @SubscribeEvent
    public void autosmelt(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null || event.block == null) {
            return;
        }
        EntityPlayer player = event.harvester;
        Block block = event.block;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null || !(equipped.func_77973_b() instanceof ISteamTool)) {
            return;
        }
        ISteamTool tool = (ISteamTool)equipped.func_77973_b();
        if (!tool.hasUpgrade(equipped, SteamcraftItems.autosmelting) || !tool.isWound(equipped) || event.drops.isEmpty() || !block.isToolEffective(tool.toolClass(), event.blockMetadata)) {
            return;
        }
        int itemsSmelted = 0;
        for (int i = 0; i < event.drops.size(); ++i) {
            MutablePair<Item, Integer> output;
            ItemStack drop = (ItemStack)event.drops.get(i);
            if (drop == null || drop.func_77973_b() == null) continue;
            int meta = drop.func_77960_j() == Short.MAX_VALUE ? 0 : drop.func_77960_j();
            MutablePair input = MutablePair.of((Object)drop.func_77973_b(), (Object)meta);
            if (SteamcraftRegistry.steamingRecipes.containsKey(input)) {
                event.drops.remove(i);
                output = SteamcraftRegistry.steamingRecipes.get(input);
                ItemStack stack = new ItemStack((Item)output.left, drop.field_77994_a, ((Integer)output.right).intValue());
                event.drops.add(stack);
                ++itemsSmelted;
                continue;
            }
            output = FurnaceRecipes.func_77602_a().func_151395_a(drop);
            if (output == null || output.func_77973_b() == null) continue;
            event.drops.remove(i);
            event.drops.add(i, output.func_77946_l());
            ++itemsSmelted;
        }
        if (itemsSmelted > 0) {
            tool.addSteam(equipped, -(itemsSmelted * tool.steamPerDurability()), player);
        }
    }

    private boolean canDoVoidThings(ItemStack equipped) {
        if (equipped == null || equipped.func_77973_b() == null || !(equipped.func_77973_b() instanceof ISteamTool)) {
            return false;
        }
        ISteamTool tool = (ISteamTool)equipped.func_77973_b();
        return tool.isWound(equipped) && tool.hasUpgrade(equipped, SteamcraftItems.theVoid);
    }

    private ArrayList<ItemStack> addToInventory(ArrayList<ItemStack> drops, IInventory inv) {
        ArrayList<ItemStack> failures = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            if (drop == null) continue;
            boolean added = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stackInSlot = inv.func_70301_a(i);
                if (stackInSlot == null) {
                    inv.func_70299_a(i, drop);
                    added = true;
                    break;
                }
                if (stackInSlot.func_77973_b() != drop.func_77973_b() || stackInSlot.func_77960_j() != drop.func_77960_j() || stackInSlot.field_77994_a + drop.field_77994_a >= stackInSlot.func_77976_d()) continue;
                stackInSlot.field_77994_a += drop.field_77994_a;
                inv.func_70299_a(i, stackInSlot);
                added = true;
                break;
            }
            if (added) continue;
            failures.add(drop);
        }
        return failures;
    }

    private NBTTagCompound setVoidInventoryNBT(NBTTagCompound nbt, int x, int y, int z) {
        nbt.func_74768_a("x", x);
        nbt.func_74768_a("y", y);
        nbt.func_74768_a("z", z);
        return nbt;
    }

    private void indicateVoidSet(World world, int x, int y, int z) {
        Random rand = new Random();
        if (world.field_72995_K) {
            for (int i = 0; i < rand.nextInt(10) + 5; ++i) {
                world.func_72869_a("portal", (double)x + (rand.nextDouble() - 0.5), (double)y + rand.nextDouble(), (double)z + (rand.nextDouble() - 0.5), (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0);
            }
        }
        world.func_72908_a((double)x, (double)y, (double)z, "mob.endermen.portal", 1.0f, 1.0f);
    }

    @SubscribeEvent
    public void setVoidInventory(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        if (!player.func_70093_af()) {
            return;
        }
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        ItemStack equipped = player.func_71045_bC();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!this.canDoVoidThings(equipped) || !(tile instanceof IInventory) || ((IInventory)tile).func_70302_i_() < 1) {
            return;
        }
        if (!equipped.func_77942_o()) {
            equipped.func_77982_d(new NBTTagCompound());
        }
        if (equipped.field_77990_d.func_74764_b("voidInventory")) {
            NBTTagCompound nbt = equipped.field_77990_d.func_74775_l("voidInventory");
            int existingX = nbt.func_74762_e("x");
            int existingY = nbt.func_74762_e("y");
            int existingZ = nbt.func_74762_e("z");
            if (existingX == x && existingY == y && existingZ == z) {
                equipped.field_77990_d.func_82580_o("voidInventory");
            } else {
                equipped.field_77990_d.func_74782_a("voidInventory", (NBTBase)this.setVoidInventoryNBT(nbt, x, y, z));
            }
        } else {
            equipped.field_77990_d.func_74782_a("voidInventory", (NBTBase)this.setVoidInventoryNBT(new NBTTagCompound(), x, y, z));
        }
        this.indicateVoidSet(world, x, y, z);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void sendToVoid(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null || event.block == null) {
            return;
        }
        EntityPlayer player = event.harvester;
        World world = event.world;
        ItemStack equipped = player.func_71045_bC();
        if (!this.canDoVoidThings(equipped) || player.func_70093_af()) {
            return;
        }
        ArrayList<Object> failures = new ArrayList();
        if (equipped.func_77942_o() && equipped.field_77990_d.func_74764_b("voidInventory")) {
            NBTTagCompound nbt = equipped.field_77990_d.func_74775_l("voidInventory");
            int invX = nbt.func_74762_e("x");
            int invY = nbt.func_74762_e("y");
            int invZ = nbt.func_74762_e("z");
            TileEntity tile = world.func_147438_o(invX, invY, invZ);
            int x = event.x;
            int y = event.y;
            int z = event.z;
            if (tile == null || invX == x && invY == y && invZ == z) {
                equipped.func_77978_p().func_82580_o("voidInventory");
                this.indicateVoidSet(world, x, y, z);
                return;
            }
            if (tile instanceof IInventory) {
                failures = this.addToInventory(event.drops, (IInventory)tile);
            }
            tile.func_145845_h();
        } else {
            InventoryEnderChest ender = player.func_71005_bN();
            failures = this.addToInventory(event.drops, (IInventory)ender);
            ender.func_70487_g();
        }
        event.drops.clear();
        if (!failures.isEmpty()) {
            event.drops.addAll(failures);
        }
    }

    private boolean isFarmable(Block block) {
        return block != null && (block == Blocks.field_150346_d || block == Blocks.field_150349_c);
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            ItemSteamShovel shovel;
            this.sideHit = event.face;
            World world = event.world;
            if (world.field_72995_K) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            ItemStack equipped = player.func_71045_bC();
            if (equipped == null) {
                return;
            }
            if (equipped.func_77973_b() instanceof ItemSteamAxe) {
                ItemSteamAxe axe = (ItemSteamAxe)equipped.func_77973_b();
                if (!axe.isWound(equipped)) {
                    return;
                }
                if (axe.hasUpgrade(equipped, SteamcraftItems.leafBlower)) {
                    this.blowLeaves(this.getExtraBlock9Coordinates(this.sideHit), event.x, event.y, event.z, world, player);
                }
            } else if (equipped.func_77973_b() instanceof ItemSteamShovel && (shovel = (ItemSteamShovel)equipped.func_77973_b()).hasUpgrade(equipped, SteamcraftItems.cultivator) && shovel.isWound(equipped)) {
                int[][] coords;
                for (int[] aCoordinateArray : coords = extraBlocksVertical) {
                    int thisX = event.x + aCoordinateArray[0];
                    int thisY = event.y + aCoordinateArray[1];
                    int thisZ = event.z + aCoordinateArray[2];
                    Block block1 = world.func_147439_a(thisX, thisY, thisZ);
                    if (!this.isFarmable(block1)) continue;
                    world.func_147468_f(thisX, thisY, thisZ);
                    world.func_147449_b(thisX, thisY, thisZ, Blocks.field_150458_ak);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void openMerchant(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        Entity target = event.target;
        ItemStack held = player.func_70694_bm();
        if (this.playerHasFrequencyShifter(player) && (target instanceof EntityWolf || target instanceof EntityOcelot)) {
            boolean flag;
            boolean bl = flag = held == null || !(held.func_77973_b() instanceof ItemNameTag);
            if (!flag) {
                return;
            }
            EntityLiving living = (EntityLiving)target;
            ExtendedPropertiesMerchant nbt = (ExtendedPropertiesMerchant)living.getExtendedProperties(Steamcraft.MERCHANT_PROPERTY_ID);
            if (nbt.totalTrades > nbt.maximumTrades) {
                if (living instanceof EntityWolf) {
                    EntityWolf wolf = (EntityWolf)living;
                    wolf.func_70916_h(true);
                } else {
                    EntityOcelot cat = (EntityOcelot)living;
                    living.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)cat, true));
                }
            } else {
                if (living.func_94056_bM()) {
                    nbt.merchantName = living.func_94057_bL();
                }
                String name = nbt.merchantName;
                FrequencyMerchant merchant = new FrequencyMerchant(living, name);
                merchant.func_70932_a_(player);
                player.func_71030_a((IMerchant)merchant, name);
                ++nbt.totalTrades;
            }
        }
    }

    @SubscribeEvent
    public void doChainsaw(LivingAttackEvent event) {
        if (!(event.source.func_76364_f() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || equipped.func_77973_b() == null || !(equipped.func_77973_b() instanceof ItemSteamAxe)) {
            return;
        }
        ItemSteamAxe axe = (ItemSteamAxe)equipped.func_77973_b();
        if (!axe.isWound(equipped) || !axe.hasUpgrade(equipped, SteamcraftItems.chainsaw)) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            event.entityLiving.func_70097_a(DamageSource.field_76377_j, 9.0f);
            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 10));
        }
    }

    @SubscribeEvent
    public void toggleDrillDash(LivingEvent.LivingJumpEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null || !player.func_70093_af()) {
            return;
        }
        Item equippedItem = equipped.func_77973_b();
        if (equippedItem == null || !(equippedItem instanceof ItemSteamDrill)) {
            return;
        }
        ItemSteamDrill drill = (ItemSteamDrill)equippedItem;
        if (!drill.isWound(equipped) || !drill.hasUpgrade(equipped, SteamcraftItems.battleDrill)) {
            return;
        }
        Vec3 vector = player.func_70676_i(0.5f);
        double total = Math.abs(vector.field_72449_c + vector.field_72450_a);
        if (vector.field_72448_b < total) {
            vector.field_72448_b = total;
        }
        player.field_70179_y += vector.field_72449_c * 2.5;
        player.field_70159_w += vector.field_72450_a * 2.5;
        EntityLivingBase target = this.getEntityFromPlayer(player);
        if (target == null) {
            return;
        }
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 9.0f);
        drill.addSteam(equipped, -(Config.battleDrillConsumption * drill.steamPerDurability()), player);
    }

    private EntityLivingBase getEntityFromPlayer(EntityPlayer player) {
        Vec3 vec = player.func_70040_Z();
        double x = vec.field_72450_a + player.field_70165_t;
        double y = vec.field_72448_b + player.field_70163_u;
        double z = vec.field_72449_c + player.field_70161_v;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x - 5.0), (double)(y - 5.0), (double)(z - 5.0), (double)(x + 5.0), (double)(y + 5.0), (double)(z + 5.0));
        List entities = player.field_70170_p.func_72839_b((Entity)player, aabb);
        for (Object object : entities) {
            EntityLivingBase target;
            if (!(object instanceof EntityLivingBase) || !player.func_70685_l((Entity)(target = (EntityLivingBase)object)) || !target.func_70067_L()) continue;
            return target;
        }
        return null;
    }

    @SubscribeEvent
    public void updateBlockBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack equipped = event.entityPlayer.func_71045_bC();
        Block block = event.block;
        if (equipped != null && equipped.func_77973_b() != null && block != null) {
            ISteamTool tool;
            ItemSteamShovel shovel;
            float newSpeed = 0.0f;
            float original = event.originalSpeed;
            if (equipped.func_77973_b() instanceof ItemSteamDrill) {
                ItemSteamDrill drill = (ItemSteamDrill)equipped.func_77973_b();
                if (drill.isWound(equipped)) {
                    if (drill.hasUpgrade(equipped, SteamcraftItems.bigDrill)) {
                        newSpeed = original * 0.7f;
                    }
                    if (drill.hasUpgrade(equipped, SteamcraftItems.internalProcessingUnit)) {
                        newSpeed = newSpeed == 0.0f ? original / 2.0f : (newSpeed /= 2.0f);
                    }
                    if (drill.hasUpgrade(equipped, SteamcraftItems.thermalDrill) || drill.hasUpgrade(equipped, SteamcraftItems.chargePlacer)) {
                        newSpeed = newSpeed == 0.0f ? original * 5.0f : (newSpeed *= 5.0f);
                    }
                    if (drill.hasUpgrade(equipped, SteamcraftItems.battleDrill)) {
                        newSpeed = newSpeed == 0.0f ? original / 1.7f : (newSpeed /= 1.7f);
                    }
                }
            } else if (equipped.func_77973_b() instanceof ItemSteamAxe) {
                ItemSteamAxe axe = (ItemSteamAxe)equipped.func_77973_b();
                if (axe.isWound(equipped)) {
                    if (axe.hasUpgrade(equipped, SteamcraftItems.leafBlower)) {
                        newSpeed = original / 5.0f;
                    }
                    if (axe.hasUpgrade(equipped, SteamcraftItems.treeFeller)) {
                        newSpeed = newSpeed == 0.0f ? original * 0.7f : (newSpeed *= 0.7f);
                    }
                    if (axe.hasUpgrade(equipped, SteamcraftItems.chainsaw)) {
                        newSpeed = newSpeed == 0.0f ? original / 1.7f : (newSpeed /= 1.7f);
                    }
                }
            } else if (equipped.func_77973_b() instanceof ItemSteamShovel && (shovel = (ItemSteamShovel)equipped.func_77973_b()).isWound(equipped) && shovel.hasUpgrade(equipped, SteamcraftItems.rotaryBlades)) {
                newSpeed = original * 0.425f;
            }
            if (equipped.func_77973_b() instanceof ISteamTool && (tool = (ISteamTool)equipped.func_77973_b()).isWound(equipped) && tool.hasUpgrade(equipped, SteamcraftItems.overclocker)) {
                newSpeed = newSpeed == 0.0f ? original * 2.5f : (newSpeed *= 2.5f);
            }
            if (newSpeed != 0.0f) {
                event.newSpeed = newSpeed;
            }
        }
    }

    @SubscribeEvent
    public void handlePainfulFrequencies(AnimalTradeEvent event) {
        EntityLiving entity = event.salesperson;
        NBTTagCompound nbt = entity.getEntityData();
        if (nbt.func_74762_e("totalTrades") > nbt.func_74762_e("maximumTrades")) {
            entity.func_70624_b((EntityLivingBase)event.customer);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void ignoreChatMessage(ClientChatReceivedEvent event) {
        EntityPlayer messager;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        String message = event.message.func_150260_c();
        Matcher matcher = Pattern.compile("<(.+?)>").matcher(message);
        if (matcher.find() && (messager = world.func_72924_a(matcher.group(0))) != null && !messager.getDisplayName().equals(player.getDisplayName()) && this.playerHasFrequencyShifter(messager) && this.playerHasFrequencyShifter((EntityPlayer)player)) {
            event.setCanceled(true);
        }
    }

    private boolean playerHasFrequencyShifter(EntityPlayer player) {
        ItemExosuitArmor helmetArmor;
        Item helmetItem;
        ItemStack helmet = player.func_71124_b(4);
        return helmet != null && SteamcraftEventHandler.hasPower((EntityLivingBase)player, 1) && (helmetItem = helmet.func_77973_b()) instanceof ItemExosuitArmor && (helmetArmor = (ItemExosuitArmor)helmetItem).hasUpgrade(helmet, SteamcraftItems.frequencyShifter);
    }

    private int[][] getExtraBlockCoordinates(int sideHit) {
        switch (sideHit) {
            case 5: {
                return extraBlocksSide;
            }
            case 4: {
                return extraBlocksSide;
            }
            case 3: {
                return extraBlocksForward;
            }
            case 1: {
                return extraBlocksVertical;
            }
            case 0: {
                return extraBlocksVertical;
            }
        }
        return extraBlocksForward;
    }

    private int[][] getExtraBlock9Coordinates(int sideHit) {
        switch (sideHit) {
            case 5: {
                return extraBlocks9Side;
            }
            case 4: {
                return extraBlocks9Side;
            }
            case 3: {
                return extraBlocks9Forward;
            }
            case 1: {
                return extraBlocks9Vertical;
            }
            case 0: {
                return extraBlocks9Vertical;
            }
        }
        return extraBlocks9Forward;
    }

    private void mineExtraBlocks(int[][] coordinateArray, int x, int y, int z, World world, ItemTool tool, ItemStack toolStack, EntityPlayer player) {
        boolean isShovel = tool instanceof ItemSteamShovel;
        for (int[] aCoordinateArray : coordinateArray) {
            int thisX = x + aCoordinateArray[0];
            int thisY = y + aCoordinateArray[1];
            int thisZ = z + aCoordinateArray[2];
            Block block = world.func_147439_a(thisX, thisY, thisZ);
            int meta = world.func_72805_g(thisX, thisY, thisZ);
            boolean flag = tool.canHarvestBlock(block, toolStack);
            if (!flag && isShovel) {
                String toolClass = block.getHarvestTool(meta);
                boolean bl = flag = toolClass != null && toolClass.equals(((ISteamTool)tool).toolClass());
            }
            if (block == null || block.isAir((IBlockAccess)world, thisX, thisY, thisZ) || !flag) continue;
            world.func_147468_f(thisX, thisY, thisZ);
            block.func_149636_a(world, player, thisX, thisY, thisZ, meta);
        }
    }

    private void blowLeaves(int[][] coordinateArray, int x, int y, int z, World world, EntityPlayer player) {
        for (int[] aCoordinateArray : coordinateArray) {
            int thisX = x + aCoordinateArray[0];
            int thisY = y + aCoordinateArray[1];
            int thisZ = z + aCoordinateArray[2];
            Block block = world.func_147439_a(thisX, thisY, thisZ);
            int meta = world.func_72805_g(thisX, thisY, thisZ);
            if (block == null || block.isAir((IBlockAccess)world, thisX, thisY, thisZ) || !this.isLeaves(block, world, x, y, z)) continue;
            world.func_147468_f(thisX, thisY, thisZ);
            block.func_149636_a(world, player, thisX, thisY, thisZ, meta);
        }
    }

    private boolean isLeaves(Block block, World world, int x, int y, int z) {
        return OreDictHelper.arrayHasItem(OreDictHelper.leaves, Item.func_150898_a((Block)block)) || block.isLeaves((IBlockAccess)world, x, y, z) || this.LEAF_MATERIALS.contains(block.func_149688_o());
    }

    static {
        lastBuyingPlayerField = null;
        timeUntilResetField = null;
        merchantField = null;
        buyingListField = null;
        FMLLog.info((String)"[FSP] Getting some fields through reflection.", (Object[])new Object[0]);
        lastBuyingPlayerField = SteamcraftEventHandler.getField("lastBuyingPlayer", "field_82189_bL", EntityVillager.class);
        timeUntilResetField = SteamcraftEventHandler.getField("timeUntilReset", "field_70961_j", EntityVillager.class);
        buyingListField = SteamcraftEventHandler.getField("buyingList", "field_70963_i", EntityVillager.class);
        if (lastBuyingPlayerField != null) {
            lastBuyingPlayerField.setAccessible(true);
        }
        if (timeUntilResetField != null) {
            timeUntilResetField.setAccessible(true);
        }
        if (buyingListField != null) {
            buyingListField.setAccessible(true);
        }
        try {
            merchantField = SteamcraftEventHandler.getField("field_147037_w", "field_147037_w", GuiMerchant.class);
            if (merchantField != null) {
                merchantField.setAccessible(true);
            }
        }
        catch (NoClassDefFoundError ignore) {
            FMLLog.warning((String)"[FSP] GuiMerchant class not found. You are probably a server.", (Object[])new Object[0]);
        }
        quickLavaBlocks = new HashMap();
        charges = new HashMap();
        extraBlocksSide = new int[][]{{0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, -1, 0}, {0, -1, 0}, {0, -1, 1}};
        extraBlocksForward = new int[][]{{-1, 1, 0}, {0, 1, 0}, {1, 1, 0}, {-1, 0, 0}, {0, 0, 0}, {1, 0, 0}, {-1, -1, 0}, {0, -1, 0}, {1, -1, 0}};
        extraBlocksVertical = new int[][]{{-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {-1, 0, 0}, {0, 0, 0}, {1, 0, 0}, {-1, 0, -1}, {0, 0, -1}, {1, 0, -1}};
        extraBlocks9Side = new int[][]{{0, 4, -4}, {0, 4, -3}, {0, 4, -2}, {0, 4, -1}, {0, 4, 0}, {0, 4, 1}, {0, 4, 2}, {0, 4, 3}, {0, 4, 4}, {0, 3, -4}, {0, 3, -3}, {0, 3, -2}, {0, 3, -1}, {0, 3, 0}, {0, 3, 1}, {0, 3, 2}, {0, 3, 3}, {0, 3, 4}, {0, 2, -4}, {0, 3, -3}, {0, 2, -2}, {0, 2, -1}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 2, 3}, {0, 2, 4}, {0, 1, -4}, {0, 2, -3}, {0, 1, -2}, {0, 1, -1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 0, -4}, {0, 0, -3}, {0, 0, -2}, {0, 0, -1}, {0, 0, 0}, {0, 0, 1}, {0, 0, 2}, {0, 0, 3}, {0, 0, 4}, {0, -1, -4}, {0, -1, -3}, {0, -1, -2}, {0, -1, -1}, {0, -1, 0}, {0, -1, 1}, {0, -1, 2}, {0, -1, 3}, {0, -1, 4}, {0, -2, -4}, {0, -2, -3}, {0, -2, -2}, {0, -2, -1}, {0, -2, 0}, {0, -2, 1}, {0, -2, 2}, {0, -2, 3}, {0, -2, 4}, {0, -3, -4}, {0, -3, -3}, {0, -3, -2}, {0, -3, -1}, {0, -3, 0}, {0, -3, 1}, {0, -3, 2}, {0, -3, 3}, {0, -3, 4}, {0, -4, -4}, {0, -4, -3}, {0, -4, -2}, {0, -4, -1}, {0, -4, 0}, {0, -4, 1}, {0, -4, 2}, {0, -4, 3}, {0, -4, 4}};
        extraBlocks9Forward = new int[][]{{-4, 4, 0}, {-3, 4, 0}, {-2, 4, 0}, {-1, 4, 0}, {0, 4, 0}, {1, 4, 0}, {2, 4, 0}, {3, 4, 0}, {4, 4, 0}, {-4, 3, 0}, {-3, 3, 0}, {-2, 3, 0}, {-1, 3, 0}, {0, 3, 0}, {1, 3, 0}, {2, 3, 0}, {3, 3, 0}, {4, 3, 0}, {-4, 2, 0}, {-3, 2, 0}, {-2, 2, 0}, {-1, 2, 0}, {0, 2, 0}, {1, 2, 0}, {2, 2, 0}, {3, 2, 0}, {4, 2, 0}, {-4, 1, 0}, {-3, 1, 0}, {-2, 1, 0}, {-1, 1, 0}, {0, 1, 0}, {1, 1, 0}, {2, 1, 0}, {3, 1, 0}, {4, 1, 0}, {-4, 0, 0}, {-3, 0, 0}, {-2, 0, 0}, {-1, 0, 0}, {0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {3, 0, 0}, {4, 0, 0}, {-4, -1, 0}, {-3, -1, 0}, {-2, -1, 0}, {-1, -1, 0}, {0, -1, 0}, {1, -1, 0}, {2, -1, 0}, {3, -1, 0}, {4, -1, 0}, {-4, -2, 0}, {-3, -2, 0}, {-2, -2, 0}, {-1, -2, 0}, {0, -2, 0}, {1, -2, 0}, {2, -2, 0}, {3, -2, 0}, {4, -2, 0}, {-4, -3, 0}, {-3, -3, 0}, {-2, -3, 0}, {-1, -3, 0}, {0, -3, 0}, {1, -3, 0}, {2, -3, 0}, {3, -3, 0}, {4, -3, 0}, {-4, -4, 0}, {-3, -4, 0}, {-2, -4, 0}, {-1, -4, 0}, {0, -4, 0}, {1, -4, 0}, {2, -4, 0}, {3, -4, 0}, {4, -4, 0}};
        extraBlocks9Vertical = new int[][]{{-4, 0, 4}, {-4, 0, 4}, {-2, 0, 4}, {-4, 0, 4}, {0, 0, 4}, {1, 0, 4}, {2, 0, 4}, {3, 0, 4}, {4, 0, 4}, {-4, 0, 3}, {-3, 0, 3}, {-2, 0, 3}, {-3, 0, 3}, {0, 0, 3}, {1, 0, 3}, {2, 0, 3}, {3, 0, 3}, {4, 0, 3}, {-4, 0, 2}, {-3, 0, 2}, {-2, 0, 2}, {-1, 0, 2}, {0, 0, 2}, {1, 0, 2}, {2, 0, 2}, {3, 0, 2}, {4, 0, 2}, {-4, 0, 1}, {-3, 0, 1}, {-2, 0, 1}, {-1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {2, 0, 1}, {3, 0, 1}, {4, 0, 1}, {-4, 0, 0}, {-3, 0, 0}, {-2, 0, 0}, {-1, 0, 0}, {0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {3, 0, 0}, {4, 0, 0}, {-4, 0, -1}, {-3, 0, -1}, {-2, 0, -1}, {-1, 0, -1}, {0, 0, -1}, {1, 0, -1}, {2, 0, -1}, {3, 0, -1}, {4, 0, -1}, {-4, 0, -2}, {-3, 0, -2}, {-2, 0, -2}, {-1, 0, -2}, {0, 0, -2}, {1, 0, -2}, {2, 0, -2}, {3, 0, -2}, {4, 0, -2}, {-4, 0, -3}, {-3, 0, -3}, {-2, 0, -3}, {-1, 0, -3}, {0, 0, -3}, {1, 0, -3}, {2, 0, -3}, {3, 0, -3}, {4, 0, -3}, {-4, 0, -4}, {-3, 0, -4}, {-2, 0, -4}, {-1, 0, -4}, {0, 0, -4}, {1, 0, -4}, {2, 0, -4}, {3, 0, -4}, {4, 0, -4}};
    }
}

