/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.api.CrucibleLiquid;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.Tuple3;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.integration.thaumcraft.ThaumcraftIntegration;
import flaxbeard.steamcraft.tile.TileEntityCrucible;
import flaxbeard.steamcraft.tile.TileEntitySteamHeater;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.MutablePair;

public class BlockSteamcraftCrucible
extends BlockContainer
implements IWrenchable {
    private static float px = 0.0625f;
    public IIcon innerIcon;
    public IIcon topIcon;
    public IIcon bottomIcon;
    public IIcon liquidIcon;
    public IIcon blank;

    public BlockSteamcraftCrucible() {
        super(Material.field_151576_e);
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)((float)i + px), (double)((float)j + 0.0f + px), (double)((float)k + px), (double)((float)i + 1.0f - px), (double)((float)j + 1.0f - px), (double)((float)k + 1.0f - px));
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityCrucible) {
            TileEntityCrucible crucible = (TileEntityCrucible)te;
            return crucible.getComparatorOutput();
        }
        return 0;
    }

    public boolean isCrucibleHeated(World world, int x, int y, int z) {
        Block blockUnderCrucible = world.func_147439_a(x, y - 1, z);
        TileEntity tileUnderCrucible = world.func_147438_o(x, y - 1, z);
        int steam = Config.heaterConsumption;
        if (this == SteamcraftBlocks.hellCrucible || blockUnderCrucible.func_149688_o() == Material.field_151581_o || blockUnderCrucible.func_149688_o() == Material.field_151587_i || Config.enableThaumcraftIntegration && Config.enableNitorPoweredCrucible && CrossMod.THAUMCRAFT && ThaumcraftIntegration.isNitorUnderBlock(world, x, y, z)) {
            return true;
        }
        if (tileUnderCrucible instanceof TileEntitySteamHeater) {
            TileEntitySteamHeater steamHeater = (TileEntitySteamHeater)tileUnderCrucible;
            if (steamHeater.myDir() == ForgeDirection.UP && steamHeater.getSteam() >= steam) {
                steamHeater.decrSteam(steam);
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityItem) {
            EntityItem item = (EntityItem)entity;
            if (this.isCrucibleHeated(world, x, y, z)) {
                MutablePair<CrucibleLiquid, Integer> output;
                if (SteamcraftRegistry.liquidRecipes.containsKey(MutablePair.of((Object)item.func_92059_d().func_77973_b(), (Object)item.func_92059_d().func_77960_j()))) {
                    output = SteamcraftRegistry.liquidRecipes.get(MutablePair.of((Object)item.func_92059_d().func_77973_b(), (Object)item.func_92059_d().func_77960_j()));
                } else if (SteamcraftRegistry.liquidRecipes.containsKey(MutablePair.of((Object)item.func_92059_d().func_77973_b(), (Object)-1))) {
                    output = SteamcraftRegistry.liquidRecipes.get(MutablePair.of((Object)item.func_92059_d().func_77973_b(), (Object)-1));
                } else {
                    return;
                }
                TileEntityCrucible crucible = (TileEntityCrucible)world.func_147438_o(x, y, z);
                int amount = (Integer)output.right;
                if (crucible != null) {
                    if (item.field_145804_b > 2) {
                        item.field_145804_b = 2;
                    } else if (item.field_145804_b <= 1) {
                        ItemStack stack = item.func_92059_d();
                        ItemStack out = crucible.fillWith(stack, amount, output);
                        if (crucible.getFill() + amount <= 90) {
                            item.field_145804_b = 2;
                        }
                        if (out.field_77994_a <= 0) {
                            entity.func_70106_y();
                        } else {
                            item.func_92058_a(out);
                        }
                    }
                }
            }
        }
    }

    public void func_149689_a(World p_149689_1_, int p_149689_2_, int p_149689_3_, int p_149689_4_, EntityLivingBase p_149689_5_, ItemStack p_149689_6_) {
        int l = MathHelper.func_76128_c((double)((double)(p_149689_5_.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        p_149689_1_.func_72921_c(p_149689_2_, p_149689_3_, p_149689_4_, l, 2);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149719_a(IBlockAccess par1iBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(px, 0.0f + px, px, 1.0f - px, 1.0f - px, 1.0f - px);
        super.func_149719_a(par1iBlockAccess, par2, par3, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.blank;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.innerIcon = ir.func_94245_a(this.func_149641_N() + "_" + "inner");
        this.topIcon = ir.func_94245_a(this.func_149641_N() + "_top");
        this.bottomIcon = ir.func_94245_a(this.func_149641_N() + "_" + "bottom");
        this.field_149761_L = ir.func_94245_a(this.func_149641_N() + "_side");
        this.liquidIcon = ir.func_94245_a(this.func_149641_N() + "_liquid");
        this.blank = ir.func_94245_a("steamcraft:blankTexture");
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityCrucible();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        block8: {
            block7: {
                if (player.func_70093_af() || player.func_70694_bm() != null) break block7;
                TileEntityCrucible tile = (TileEntityCrucible)world.func_147438_o(x, y, z);
                if (tile.isTipping()) break block8;
                tile.setTipping();
                tile.needsUpdate = true;
                break block8;
            }
            if (player.func_70694_bm() != null) {
                TileEntityCrucible tile = (TileEntityCrucible)world.func_147438_o(x, y, z);
                for (CrucibleLiquid liquid : tile.contents) {
                    Tuple3 tuple = new Tuple3(player.func_70694_bm().func_77973_b(), player.func_70694_bm().func_77960_j(), liquid);
                    if (SteamcraftRegistry.dunkRecipes.containsKey(tuple)) {
                        int needed = (Integer)SteamcraftRegistry.dunkRecipes.get((Object)tuple).left;
                        ItemStack result = ((ItemStack)SteamcraftRegistry.dunkRecipes.get((Object)tuple).right).func_77946_l();
                        if (tile.number.get(liquid) < needed) continue;
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        int currNum = tile.number.get(liquid);
                        if ((currNum -= needed) == 0) {
                            tile.contents.remove(liquid);
                        }
                        tile.number.remove(liquid);
                        tile.number.put(liquid, currNum);
                        if (!player.field_71071_by.func_70441_a(result) && !player.field_70170_p.field_72995_K) {
                            player.func_70099_a(result, 0.0f);
                        }
                        tile.needsUpdate = true;
                        break;
                    }
                    Tuple3 tuple1 = new Tuple3(player.func_70694_bm(), -1, liquid);
                    if (!SteamcraftRegistry.dunkRecipes.containsKey(tuple1)) continue;
                    int needed = (Integer)SteamcraftRegistry.dunkRecipes.get((Object)tuple1).left;
                    ItemStack result = ((ItemStack)SteamcraftRegistry.dunkRecipes.get((Object)tuple1).right).func_77946_l();
                    if (tile.number.get(liquid) < needed) continue;
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    int currNum = tile.number.get(liquid);
                    if ((currNum -= needed) == 0) {
                        tile.contents.remove(liquid);
                    }
                    tile.number.remove(liquid);
                    tile.number.put(liquid, currNum);
                    if (!player.field_71071_by.func_70441_a(result) && !player.field_70170_p.field_72995_K) {
                        player.func_70099_a(result, 0.0f);
                    }
                    tile.needsUpdate = true;
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        int meta = world.func_72805_g(x, y, z);
        if (side != 0 && side != 1) {
            int output = meta;
            switch (side) {
                case 2: {
                    output = 2;
                    break;
                }
                case 3: {
                    output = 0;
                    break;
                }
                case 4: {
                    output = 1;
                    break;
                }
                case 5: {
                    output = 3;
                }
            }
            if (output == meta && side > 1 && side < 6) {
                switch (ForgeDirection.getOrientation((int)side).getOpposite().ordinal()) {
                    case 2: {
                        output = 2;
                        break;
                    }
                    case 3: {
                        output = 0;
                        break;
                    }
                    case 4: {
                        output = 1;
                        break;
                    }
                    case 5: {
                        output = 3;
                    }
                }
            }
            world.func_72921_c(x, y, z, output, 2);
            return true;
        }
        return false;
    }
}

